package com.ejianc.business.bid.service.impl;

import com.ejianc.business.bid.bean.*;
import com.ejianc.business.bid.consts.BidBillTypeEnum;
import com.ejianc.business.bid.service.*;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.StopApplyMapper;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import java.util.Arrays;
import java.util.List;

/**
 * 投标停止申请
 * 
 * @author generator
 * 
 */
@Service("stopApplyService")
public class StopApplyServiceImpl extends BaseServiceImpl<StopApplyMapper, StopApplyEntity> implements IStopApplyService{

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBpmApi iBpmApi;
    //资格预审
    @Autowired
    private IPrequaliFicationService prequaliFicationService;
    //招标文件评审
    @Autowired
    private IBiddingFileReviewService biddingFileReviewService;
    //投标文件评审
    @Autowired
    private IBidFileReviewService bidFileReviewService;
    //投标总结
    @Autowired
    private ISummaryService summaryService;

    @Async
    @Override
    public void stopApproval(Long enrollId, RequestAttributes context) {
        RequestContextHolder.setRequestAttributes(context);
        if(enrollId != null){
            QueryParam param = new QueryParam();
            param.getParams().put("enrollId",new Parameter(QueryParam.EQ,enrollId));
            param.getParams().put("billState",new Parameter(QueryParam.IN, Arrays.asList(
                    BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(),
                    BillStateEnum.APPROVING_HAS_STATE.getBillStateCode()
            )));
            //查询该投标报名信息的审批中的资格预审，中止流程
            List<PrequaliFicationEntity> prequaliFicationList = prequaliFicationService.queryList(param, false);
            prequaliFicationList.forEach((item)->{
                String id = item.getId().toString();
                iBpmApi.stopProcess(id, BidBillTypeEnum.ZI_GE_YU_SHEN.getCode());
            });
            //查询该投标报名信息的审批中的招标文件评审，中止流程
//            List<BiddingFileReviewEntity> biddingFileReviewList = biddingFileReviewService.queryList(param, false);
//            biddingFileReviewList.forEach((item)->{
//                String id = item.getId().toString();
//                iBpmApi.stopProcess(id, BidBillTypeEnum.ZHAO_BIAO_WEN_JIAN_PING_SHEN.getCode());
//            });
            //查询该投标报名信息的审批中的投标文件评审，中止流程
            List<BidFileReviewEntity> bidFileReviewList = bidFileReviewService.queryList(param, false);
            bidFileReviewList.forEach((item)->{
                String id = item.getId().toString();
                iBpmApi.stopProcess(id, BidBillTypeEnum.TOU_BIAO_WEN_JIAN_PING_SHEN.getCode());
            });
            //查询该投标报名信息的审批中的投标总结，中止流程
            List<SummaryEntity> summaryList = summaryService.queryList(param, false);
            summaryList.forEach((item)->{
                String id = item.getId().toString();
                iBpmApi.stopProcess(id, BidBillTypeEnum.TOU_BIAO_ZONG_JIE.getCode());
            });

        }
    }
}
