package com.ejianc.business.bid.controller;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.InfoTrackEntity;
import com.ejianc.business.bid.bean.InfoTrackRecordContentEntity;
import com.ejianc.business.bid.bean.InfoTrackUpdateContentEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.consts.BiddingFormEnum;
import com.ejianc.business.bid.service.*;
import com.ejianc.business.bid.utils.DateUtil;
import com.ejianc.business.bid.vo.InfoTrackRecordContentVO;
import com.ejianc.business.bid.vo.InfoTrackVO;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.models.auth.In;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 投标信息跟踪
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("infoTrack")
@Api(value = "投标信息跟踪", tags = {"投标信息跟踪"})
public class InfoTrackController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    /**此处需要根据实际修改 */
    private static final String BILL_CODE = "BID_ENGINEERING_CODE";
    @Autowired
    private ITenantApi tenantApi;


    private static final String PC_A_URL = "/ejc-bid-frontend/#/infoTrack/card?id=";

    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IInfoTrackService service;
    @Autowired
    private IRecordService recordService;
    @Autowired
    private IInfoTrackStopService infoTrackStopService;
    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private IInfoTrackRecordContentService infoTrackRecordContentService;
    @Autowired
    private IInfoTrackUpdateContentService infoTrackUpdateContentService;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InfoTrackVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody InfoTrackVO saveorUpdateVO) {
        String userName;
        CommonResponse<EmployeeVO> userData = employeeApi.getById(InvocationInfoProxy.getUserid());
        if(userData.isSuccess()) {
            //此处需要根据实际修改 删除本行或者上一行
            userName = userData.getData().getName();
        }else{
            throw new BusinessException("网络异常， 名称生成失败， 请稍后再试");
        }
        InfoTrackEntity entity = BeanMapper.map(saveorUpdateVO, InfoTrackEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            //新增 默认未中止 0
            entity.setIsStop(BidCommonConsts.NO);
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveorUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                //此处需要根据实际修改 删除本行或者上一行
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        InfoTrackRecordContentEntity infoTrackRecordContentEntity = new InfoTrackRecordContentEntity();
        InfoTrackUpdateContentEntity infoTrackUpdateContentEntity = new InfoTrackUpdateContentEntity();
        Boolean oldFlag = false;
        InfoTrackEntity oldEntity = new InfoTrackEntity();
        if(entity.getId()==null || entity.getId() == 0){
            //新增跟踪记录 修改记录
            infoTrackUpdateContentEntity.setUpdatePeople(userName);
            infoTrackUpdateContentEntity.setUpdateSummary(entity.getProjectOverview());
            infoTrackUpdateContentEntity.setUpdatePrice(entity.getInvestorAmount());
            infoTrackUpdateContentEntity.setUpdateTime(new Date());

            infoTrackRecordContentEntity.setFollowPeople(userName);
            infoTrackRecordContentEntity.setNewTrackStatus(entity.getRemark());
            infoTrackRecordContentEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
            infoTrackRecordContentEntity.setTrackTime(new Date());
            entity.getRecordList().add(infoTrackRecordContentEntity);
            entity.getUpdateList().add(infoTrackUpdateContentEntity);
        } else {
            oldFlag = true;
            oldEntity = service.selectById(saveorUpdateVO.getId());
            if ((oldEntity.getBillState() == 1 || oldEntity.getBillState() == 3) && (oldEntity.getFollowState().equals(BidStateEnum.GEN_ZONG_ZHONG.getCode()))){
                int  result=oldEntity.getInvestorAmount().compareTo(entity.getInvestorAmount());
                if( result!=0 || !oldEntity.getProjectOverview().equals(entity.getProjectOverview())) {
                    infoTrackUpdateContentEntity.setUpdatePeople(userName);
                    infoTrackUpdateContentEntity.setUpdateSummary(entity.getProjectOverview());
                    infoTrackUpdateContentEntity.setUpdatePrice(entity.getInvestorAmount());
                    infoTrackUpdateContentEntity.setUpdateTime(new Date());
                    entity.getUpdateList().add(infoTrackUpdateContentEntity);
                }
                if(null == oldEntity.getRemark() || !oldEntity.getRemark().equals(entity.getRemark())){
                    infoTrackRecordContentEntity.setFollowPeople(userName);
                    infoTrackRecordContentEntity.setNewTrackStatus(entity.getRemark());
                    infoTrackRecordContentEntity.setCreateUserCode(userName);
                    infoTrackRecordContentEntity.setTrackTime(new Date());
                    entity.getRecordList().add(infoTrackRecordContentEntity);
                }
            }

        }


        List<String> nameItems = new ArrayList<>();
        for(char c : saveorUpdateVO.getEngineeringName().toCharArray()) {
            nameItems.add(String.valueOf(c));
        }
        //计算名称匹配率
        List<String> nameRepeatList = service.countNameRepeatNum(nameItems);
        Integer nameRepeatNum = 0;
        if(CollectionUtils.isNotEmpty(nameRepeatList)) {
            nameRepeatNum = nameRepeatList.stream().map(item -> {
                String tmp = item;
                for(String s : nameItems) {
                    tmp = tmp.replace(s, "");
                }
                return item.length() - tmp.length();
            }).max((v1, v2) -> v1 - v2).get();
        }

        entity.setNameRepeatPercent(ComputeUtil.safeDiv(new BigDecimal(nameRepeatNum+""), new BigDecimal(nameItems.size()+"")));

    	service.saveOrUpdate(entity, false);
        if (oldFlag){
            if (oldEntity.getBillState() == 0){
                int  result=oldEntity.getInvestorAmount().compareTo(entity.getInvestorAmount());
                if(result!=0 || !oldEntity.getProjectOverview().equals(entity.getProjectOverview())) {
                    infoTrackUpdateContentService.update(new UpdateWrapper<InfoTrackUpdateContentEntity>().set("update_people",userName).set("update_summary", entity.getProjectOverview()).set("update_price", entity.getInvestorAmount()).eq("track_id", oldEntity.getId()));
                }
                if(!oldEntity.getRemark().equals(entity.getRemark())){
                    infoTrackRecordContentService.update(new UpdateWrapper<InfoTrackRecordContentEntity>().set("follow_people",userName).set("new_track_status", entity.getRemark()).set("track_time", new Date()).eq("track_id", oldEntity.getId()));
                }
            }
        }
    	InfoTrackVO vo = BeanMapper.map(service.selectById(entity.getId()), InfoTrackVO.class);
        infoTrackStopService.insertInfoTrackStop(vo);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InfoTrackVO> queryDetail(@RequestParam Long id) {
    	InfoTrackEntity entity = service.selectById(id);
    	InfoTrackVO vo = BeanMapper.map(entity, InfoTrackVO.class);
        vo.setRecords(recordService.getRecord(vo.getBillCode()));
        if(vo != null){
            vo.setBiddingFormName(BiddingFormEnum.getNameByCode(vo.getBiddingForm()));
            vo.setFollowStateName(BidStateEnum.getNameByCode(vo.getFollowState()));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InfoTrackVO> vos) {
        service.removeByIds(vos.stream().map(InfoTrackVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询跟踪项目信息展示表")
    @RequestMapping(value = "/queryListForTrack", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InfoTrackVO>> queryListForTrack(@RequestBody QueryParam param) {
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        if (ObjectUtil.isNotEmpty(orderMap)){
            param.getOrderMap().put("billDate", orderMap.get("billDate"));
        }else{
            param.getOrderMap().put("billDate", "desc");
        }
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("followUnitName","engineeringName","engineeringTypeName","area","unitDirectorName"));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<InfoTrackEntity> page = service.queryPage(param,false);
        List<InfoTrackEntity> records = page.getRecords();
        List<InfoTrackVO>result=new ArrayList<>();
        if(CollectionUtils.isNotEmpty(records)){
            Map<Long, InfoTrackRecordContentEntity> map = getLongInfoTrackRecordContentEntityMap(records);
            records.forEach(record -> {
                InfoTrackVO infoTrackVO = BeanMapper.map(record, InfoTrackVO.class);
                InfoTrackRecordContentEntity infoTrackRecordContentEntity = map.get(infoTrackVO.getId());
                if (infoTrackRecordContentEntity!=null){
                    infoTrackVO.setTrackTime(infoTrackRecordContentEntity.getTrackTime());
                    infoTrackVO.setNewTrackStatus(infoTrackRecordContentEntity.getNewTrackStatus());
                }
                result.add(infoTrackVO);
            });
        }


        IPage<InfoTrackVO> resultPage = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        resultPage.setRecords(result);

        return CommonResponse.success("查询列表数据成功！",resultPage);
    }

    private Map<Long, InfoTrackRecordContentEntity> getLongInfoTrackRecordContentEntityMap(List<InfoTrackEntity> records) {
        List<Long>ids = records.stream().map(InfoTrackEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper<InfoTrackRecordContentEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(InfoTrackRecordContentEntity::getTrackId,ids);
        List<InfoTrackRecordContentEntity> list = infoTrackRecordContentService.list(queryWrapper);
        Map<Long, InfoTrackRecordContentEntity> map=new HashMap<>();
        list.forEach(infoTrackRecordContentEntity -> {
            if (map.containsKey(infoTrackRecordContentEntity.getTrackId())){
                if (map.get(infoTrackRecordContentEntity.getTrackId())==null){
                    map.put(infoTrackRecordContentEntity.getTrackId(),infoTrackRecordContentEntity);
                }
                else if (map.get(infoTrackRecordContentEntity.getTrackId()).getTrackTime()==null ||
                        (infoTrackRecordContentEntity.getTrackTime()!=null &&
                        infoTrackRecordContentEntity.getTrackTime().after(map.get(infoTrackRecordContentEntity.getTrackId()).getTrackTime()))){
                    map.put(infoTrackRecordContentEntity.getTrackId(),infoTrackRecordContentEntity);
                }
            }else{
                map.put(infoTrackRecordContentEntity.getTrackId(),infoTrackRecordContentEntity);
            }
        });
        return map;
    }

    @ApiOperation("查询")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InfoTrackVO>> queryList(@RequestBody QueryParam param) {
        Parameter report = param.getParams().get("isReport");
        String isReport = "0";
        if (ObjectUtil.isNotEmpty(report)){
            isReport = param.getParams().get("isReport").getValue().toString();
        }

        List<String> fuzzyFields = param.getFuzzyFields();
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        /** 模糊搜索配置字段示例 */
        param.getParams().remove("isReport");
        if (isReport.equals("1")){
            fuzzyFields.addAll(Arrays.asList("followUnitName","engineeringName","engineeringTypeName","area","investorAmount","constructionUnitName"));
            if (ObjectUtil.isNotEmpty(orderMap)){
                param.getOrderMap().put("billDate",orderMap.get("billDate"));
            }else{
                param.getOrderMap().put("billDate",QueryParam.DESC);
            }
        }else{
            fuzzyFields.add("billCode");
            fuzzyFields.add("engineeringName");
            fuzzyFields.add("followUnitName");
            fuzzyFields.add("employeeName");
        }



        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", QueryParam.DESC);


        IPage<InfoTrackEntity> page = service.queryPage(param,false);
        if (isReport.equals("1")){
            IPage<InfoTrackVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            List<InfoTrackVO> infoTrackVOS=new ArrayList<>();
            page.getRecords().forEach(item -> {
                String engineeringName = dofiter(item.getEngineeringName());
                item.setEngineeringName(engineeringName);
                String constructionUnitName = dofiter(item.getConstructionUnitName());
                item.setConstructionUnitName(constructionUnitName);
                infoTrackVOS.add(BeanMapper.map(item, InfoTrackVO.class));
            });
            pageData.setRecords(infoTrackVOS);
            return CommonResponse.success("查询列表数据成功！",pageData);
        }
        IPage<InfoTrackVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InfoTrackVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    private String dofiter(String name) {
        if (name.length()<=2){
            return name;
        }else{
            String newName=name.substring(0,2);
            int i = name.length() - 2;
            for (int j = 0; j < i; j++){
                newName+="*";
            }
            return newName;
        }

    }

    @ApiOperation("导出跟踪项目信息展示表")
    @RequestMapping(value = "/excelTrackExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelTrackExport(@RequestBody QueryParam param, HttpServletResponse response) {
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        if (ObjectUtil.isNotEmpty(orderMap)){
            param.getOrderMap().put("billDate", orderMap.get("billDate"));
        }else{
            param.getOrderMap().put("billDate", "desc");
        }
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("followUnitName","engineeringName","engineeringTypeName","area","unitDirectorName"));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<InfoTrackEntity> list = service.queryList(param);
        Map<Long, InfoTrackRecordContentEntity> map = getLongInfoTrackRecordContentEntityMap(list);
        List<InfoTrackVO>result=new ArrayList<>();
        list.forEach(record -> {
            InfoTrackVO infoTrackVO = BeanMapper.map(record, InfoTrackVO.class);
            InfoTrackRecordContentEntity infoTrackRecordContentEntity = map.get(infoTrackVO.getId());
            if (infoTrackRecordContentEntity!=null){
                infoTrackVO.setTrackTime(infoTrackRecordContentEntity.getTrackTime());
                infoTrackVO.setNewTrackStatus(infoTrackRecordContentEntity.getNewTrackStatus());
            }
            Integer followState = record.getFollowState();
            if (followState==1){
                infoTrackVO.setFollowStateName("跟踪中");
            } else if (followState==2) {
                infoTrackVO.setFollowStateName("已评审");
            }else{
                infoTrackVO.setFollowStateName("已结束");
            }
            result.add(infoTrackVO);
        });

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", result);
        ExcelExport.getInstance().export("InfoTrackPeopleReport-export.xlsx", beans, response);
    }

    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        Parameter report = param.getParams().get("isReport");
        String isReport = "0";
        if (ObjectUtil.isNotEmpty(report)){
            isReport = param.getParams().get("isReport").getValue().toString();
        }
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().remove("isReport");
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        if (isReport.equals("1")){
            if (ObjectUtil.isNotEmpty(orderMap)){
                param.getOrderMap().put("billDate",orderMap.get("billDate"));
            }else{
                param.getOrderMap().put("billDate",QueryParam.DESC);
            }
            fuzzyFields.addAll(Arrays.asList("followUnitName","engineeringName","engineeringTypeName","area","investorAmount","constructionUnitName"));
        }else{
            fuzzyFields.add("billCode");
            fuzzyFields.add("engineeringName");
            fuzzyFields.add("followUnitName");
            fuzzyFields.add("employeeName");
        }

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        Parameter orgIdValue = param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        List<InfoTrackEntity> list = service.queryList(param);

        List<InfoTrackVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, InfoTrackVO.class);
            voList.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                vo.setFollowStateName(BidStateEnum.getNameByCode(vo.getFollowState()));
            });
        }

        //todo:字段翻译等等
        if (isReport.equals("1")){
            List<InfoTrackVO> Vo = new ArrayList<>();
            Map<String, Object> beans = new HashMap<>();
            voList.forEach(item -> {
                Integer followState = item.getFollowState();
                if (followState==1){
                    item.setFollowStateName("跟踪中");
                } else if (followState==2) {
                    item.setFollowStateName("已评审");
                }else{
                    item.setFollowStateName("已结束");
                }
                String engineeringName = dofiter(item.getEngineeringName());
                item.setEngineeringName(engineeringName);
                String constructionUnitName = dofiter(item.getConstructionUnitName());
                item.setConstructionUnitName(constructionUnitName);
                Vo.add(item);
            });
            beans.put("records", Vo);
            ExcelExport.getInstance().export("InfoTrackReport-export.xlsx", beans, response);
        }else{
            Map<String, Object> beans = new HashMap<>();
            beans.put("records", voList);
            ExcelExport.getInstance().export("InfoTrack-export.xlsx", beans, response);
        }

    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refInfoTrackData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InfoTrackVO>> refInfoTrackData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("unitDirectorName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 查询未中止 */
        param.getParams().put("isStop", new Parameter(QueryParam.EQ , BidCommonConsts.NO));
        /** 数据隔离 本下 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 跟踪中 **/
        param.getParams().put("followState", new Parameter(QueryParam.EQ , BidCommonConsts.YES));
        /** 已通过 **/
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
            if(con.containsKey("type")){
                Integer o = (Integer) con.get("type");
                if(o==1){
                    /**已部署**/
                    param.getParams().put("isDeploy", new Parameter(QueryParam.EQ , BidCommonConsts.YES));
                }
            }
        }

        IPage<InfoTrackEntity> page = service.queryPage(param,false);
        IPage<InfoTrackVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InfoTrackVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }




    /**
     * 项目信息立项跟进七天未修改预警
     * @param
     * @return
     */
    @PostMapping(value = "infoTrackFollowWarn")
    public CommonResponse<String> infoTrackFollowWarn(@RequestBody JSONObject jsonParam) {
        logger.info("接收到Task参数：{}", jsonParam);
        String warnLevel = "";
        List<Long> ignoreTenantIds = new ArrayList<>();
        if(StringUtils.isNotBlank(jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray(jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        logger.info("忽略租户列表：{}", ignoreTenantIds);
        List<JSONObject> billParams = JSONArray.parseArray(jsonParam.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonParam.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);


        CommonResponse<List<Long>> tenantResp = tenantApi.getAllValidTenantId();
        if(!tenantResp.isSuccess()) {
            logger.error("执行证照到期预警失败，获取有效的租户Id列表失败：{}", tenantResp.getMsg());
            return CommonResponse.error("执行设备租赁合同预警失败，获取有效的租户Id列表失败！");
        }

        List<Long> tenantIds = tenantResp.getData();
        if(CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行证照到期预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        //去掉停用的预警对应的租户Id
        tenantIds.removeAll(ignoreTenantIds);
        if(CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行证照到期预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        List<SqlParam> sqlParamList = new ArrayList<>();
        JSONObject warnInfo = null;
        List<SqlParam> warnParamList = null;
        List<Long> customTenantIds = new ArrayList<>();
        for(JSONObject param : billParams) {
            warnParamList = BeanMapper.mapList(param.getJSONArray("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue());
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }
        //
        //去除自定义预警设置的对应的租户Id
        tenantIds.removeAll(customTenantIds);

        for(Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray(defaultWarnInfo.getString("parameters"), SqlParam.class);
            for(SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                warnLevel = p.getWarnLevel();
                p.setTenantId(tenantId);
                p.setValue(p.getValue());
                sqlParamList.add(p);
            }
        }

        List<InfoTrackVO> result = service.queryRecordList();
        logger.info("本次共获取7天未更新跟进情况单据数量{}条",result.size());

        if(CollectionUtils.isEmpty(result)) {
            logger.error("执行证照到期预警完成，未发现有匹配预警规则的合同信息！");
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        return sendWarnToTask(transToWarnVO(result, defaultWarnInfo,0, warnLevel), defaultWarnInfo.getLong("warnSetId"));
    }


    private List<EarlyWarnTransVO> transToWarnVO(List<InfoTrackVO> result, JSONObject defaultWarnInfo, Integer type, String warnLevel) {
        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        for (InfoTrackVO m : result) {
            if (new BigDecimal(DateUtil.getBetweenDays(new Date(), m.getTrackTime()).toString()).compareTo(new BigDecimal(7)) > -1) {
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName((null != defaultWarnInfo.get("categoryName") ? defaultWarnInfo.get("categoryName").toString() + " - " : "")  + m.getBillCode());
                vo.setPcTitle("项目信息立项");
                vo.setPcUrl(PC_A_URL + m.getId());
                vo.setOrgId(Long.valueOf(m.getOrgId()));
                vo.setOrgName(m.getOrgName());
                vo.setSourceId(m.getId().toString());
                vo.setTenantId(m.getTenantId());
                vo.setWarnLevel(warnLevel);
                vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
                vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
                if (type == 0) {
                    tmpContent = "项目立项信息-" + m.getEngineeringName() + "已经7天未修改跟进情况，请更新跟进情况！";
                }
                vo.setEarlywarnContent(tmpContent);
                resp.add(vo);
            }
        }

        logger.info("发送预警参数：{}", JSON.toJSONString(resp));
        return resp;
    }


    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenter(warnList, warnId);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }
        return CommonResponse.success("任务接受处理成功！");
    }
}
