package com.ejianc.business.bid.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPObject;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.bean.SummaryEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.service.ISummaryService;
import com.ejianc.business.bid.utils.DateUtil;
import com.ejianc.business.bid.vo.SummaryVO;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.consts.ProjectBusinessStatusEnum;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 领导门户接口
 *
 * @Author: caojie
 * @CreateTime:2025-05-28 19:12
 * @Version: 1.0
 */
@RestController
@RequestMapping(value = "/leaderPortal/")
public class LeaderPortalController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IEnrollService enrollService;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ISummaryService summaryService;

    @Autowired
    private IDutyApi dutyApi;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @PostMapping(value = "queryEnrollInfo")
    public CommonResponse<JSONObject> queryEnrollInfo(@RequestBody JSONObject params) throws ParseException {
        JSONObject resp = new JSONObject();
        List<EnrollEntity> indexA = new ArrayList<>();
        List<EnrollEntity> indexB = new ArrayList<>();
        List<EnrollEntity> keyList = new ArrayList<>();
        List<EnrollEntity> nearlyTenDaysList = new ArrayList<>();

        BigDecimal keyPointMinAmt = new BigDecimal("10000");//一亿
        Long orgId = InvocationInfoProxy.getOrgId();
        if(params.containsKey("orgId")) {
            orgId = params.getLong("orgId");
        }
        if(params.containsKey("keyPointMinAmt")) {
            keyPointMinAmt = params.getBigDecimal("keyPointMinAmt");
        }

        //查询组织本下“开标日期”≥（今日-14）且“开标日期”≤（今日+15）的【项目评审】
        QueryParam queryParam = new QueryParam();
        queryParam.getOrderMap().put("createTime", "desc");
        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN,
                iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        String period = DateUtil.format(DateUtils.addDays(new Date(), -14), "yyyy-MM-dd")
                + "," +DateUtil.format(DateUtils.addDays(new Date(), 16), "yyyy-MM-dd");
        queryParam.getParams().put("biddingDate", new Parameter(QueryParam.BETWEEN, period));
        queryParam.getParams().put("billState",
                Parameter.getInInstance(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(),
        BillStateEnum.PASSED_STATE.getBillStateCode()}));

        Date today = DateUtils.parseDate(DateUtil.format(new Date(), "yyyy-MM-dd"), "yyyy-MM-dd");

        List<EnrollEntity> dbList = enrollService.queryList(queryParam);
        if(CollectionUtils.isNotEmpty(dbList)) {
            for(EnrollEntity e : dbList) {
                indexA.add(e);

                if(DateUtil.getBetweenDays(today, DateUtils.parseDate(DateUtil.format(e.getBiddingDate(), "yyyy-MM-dd"), "yyyy-MM-dd")) <= 4
                        && DateUtil.getBetweenDays(DateUtils.parseDate(DateUtil.format(e.getBiddingDate(), "yyyy-MM-dd"), "yyyy-MM-dd"), today) <=5) {
                    nearlyTenDaysList.add(e);
                    if(BidStateEnum.YI_JIE_SHU.getCode().equals(e.getBidState()) && BidStageEnum.TOU_BIAO_TING_ZHI_SHEN_QING.getCode().equals(e.getBidStage())) {
                        indexB.add(e);
                    }
                }

                if(ComputeUtil.isGreaterOrEqual(e.getCostTotal(), keyPointMinAmt)) {
                    keyList.add(e);
                }
            }
        }

        resp.put("indexANum", indexA.size());
        resp.put("indexAList", indexA);
        resp.put("indexBNum", indexB.size());
        resp.put("indexBList", indexB);
        resp.put("keyList", keyList);
        resp.put("nearlyTenDaysNum", nearlyTenDaysList.size());
        resp.put("nearlyTenDaysList", nearlyTenDaysList);

        return CommonResponse.success("查询成功！",resp);
    }

    @PostMapping(value = "getIncomeInfo")
    public CommonResponse<JSONObject> getIncomeInfo(@RequestBody JSONObject params) {
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if(params.containsKey("orgId")) {
            orgId = params.getLong("orgId");
        }
        int nearlyDays = -30;
        if(params.containsKey("nearlyDays")) {
            nearlyDays = params.getInteger("nearlyDays");
        }

        QueryParam queryParam = new QueryParam();
        queryParam.getOrderMap().put("createTime", "desc");
        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN,
                iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("bidResult", Parameter.getEqInstance(BidCommonConsts.NO));
        queryParam.getParams().put("openTenderDate", new Parameter(QueryParam.GE, DateUtils.addDays(new Date(), nearlyDays)));
        List<SummaryEntity> dbList = summaryService.queryList(queryParam);

        resp.put("num", dbList.size());
        resp.put("dataList", BeanMapper.mapList(dbList, SummaryVO.class));

        return CommonResponse.success("查询成功！", resp);
    }

    @PostMapping(value = "getBuildDutyInfo")
    public CommonResponse<JSONObject> getBuildDutyInfo(@RequestBody JSONObject params) {
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if(params.containsKey("orgId")) {
            orgId = params.getLong("orgId");
        }
        int nearlyDays = -30;
        if(params.containsKey("nearlyDays")) {
            nearlyDays = params.getInteger("nearlyDays");
        }

        QueryParam queryParam = new QueryParam();
        queryParam.getOrderMap().put("createTime", "desc");
        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN,
                iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("openTenderDate", new Parameter(QueryParam.GE, DateUtils.addDays(new Date(), nearlyDays)));
        List<SummaryEntity> dbList = summaryService.queryList(queryParam);

        if(CollectionUtils.isNotEmpty(dbList)) {
            List<Long> enrollIds = new ArrayList<>(dbList.stream().map(SummaryEntity::getEnrollId).collect(Collectors.toSet()));
            QueryParam enrollQuery = new QueryParam();
            enrollQuery.getParams().put("id", Parameter.getInInstance(enrollIds));
            List<EnrollEntity> entities = enrollService.queryList(enrollQuery);
            List<Long> projectIds = entities.stream().map(EnrollEntity::getSourceId).collect(Collectors.toList());

            //查询 状态为在施项目
            QueryParam prjQuery = new QueryParam();
            prjQuery.getParams().put("id", Parameter.getInInstance(projectIds));
            prjQuery.getParams().put("businessStatus", new Parameter(QueryParam.EQ, ProjectBusinessStatusEnum.正式开工.getBusinessStatus()));
            CommonResponse<JSONArray> prjResp= projectPoolApi.queryArray(prjQuery);
            if(!prjResp.isSuccess()) {
                logger.error("根据项目IDs-查询项目信息失败， {}", JSONObject.toJSON(projectIds), prjResp);
                return CommonResponse.error("查询项目信息失败！");
            }
            JSONArray projectJsonArr = prjResp.getData();
            if(projectJsonArr.size() != 0) {
                List<Long> validProjectIds = new ArrayList<>();
                JSONObject tmp = null;
                for(Object o : projectJsonArr) {
                    tmp = JSONObject.parseObject(JSONObject.toJSONString(o));
                    validProjectIds.add(tmp.getLong("id"));
                }
                resp.put("needNum", validProjectIds.size());
                resp.put("needProjectIds", JSONObject.toJSONString(validProjectIds));

                CommonResponse<List<Long>> extProjectIdsResp = dutyApi.queryDutyByProjectIds(validProjectIds);
                if(!extProjectIdsResp.isSuccess()) {
                    logger.error("根据项目IDs-查询项目策划信息失败， {}", JSONObject.toJSON(validProjectIds), extProjectIdsResp);
                    return CommonResponse.error("查询项目策划信息失败！");
                }
                List<Long> extProjectIds= extProjectIdsResp.getData();
                validProjectIds.removeAll(extProjectIds);

                resp.put("finishNum", extProjectIds.size());
                resp.put("finishProjectIds", extProjectIds);
                resp.put("unFinishNum", projectIds.size());
                resp.put("unFinishProjectIds", projectIds);
                return CommonResponse.success("查询成功！", resp);
            }
        }

        resp.put("needNum", 0);
        resp.put("needProjectIds", 0);
        resp.put("finishNum", 0);
        resp.put("finishProjectIds", new ArrayList<>());
        resp.put("unFinishNum", 0);
        resp.put("unFinishProjectIds", new ArrayList<>());
        return CommonResponse.success("查询成功！", resp);
    }


}
