package com.ejianc.business.bid.service;

import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.vo.RecordVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.bid.bean.RecordEntity;

import java.util.List;

/**
 * 投标记录
 *
 * @author generator
 */
public interface IRecordService extends IBaseService<RecordEntity> {

    /**
     * @param stageEnum       阶段名称
     * @param billId          单据id
     * @param engineeringCode 工程编码
     * @description: 保存记录
     * @return: com.ejianc.business.bid.vo.RecordVO
     * @author songlx
     * @date: 2021/11/17
     */
    RecordVO saveRecord(BidStageEnum stageEnum, Long billId, String engineeringCode);


    /**
     * @param engineeringCode 工程编码
     * @description: 获取记录
     * @return: com.ejianc.business.bid.vo.RecordVO
     * @author songlx
     * @date: 2021/11/18
     */
    List<RecordVO> getRecord(String engineeringCode);
}
