package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bid.bean.DeployContentChangeHisEntity;
import com.ejianc.business.bid.enums.ChangeTypeEnum;
import com.ejianc.business.bid.service.IDeployContentChangeHisService;
import com.ejianc.business.bid.vo.DeployChangeHisVO;
import com.ejianc.business.bid.vo.DeployContentChangeHisVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.DeployChangeHisMapper;
import com.ejianc.business.bid.bean.DeployChangeHisEntity;
import com.ejianc.business.bid.service.IDeployChangeHisService;

import java.util.ArrayList;
import java.util.List;

/**
 * 投标部署-变更历史主表
 * 
 * @author generator
 * 
 */
@Service("deployChangeHisService")
public class DeployChangeHisServiceImpl extends BaseServiceImpl<DeployChangeHisMapper, DeployChangeHisEntity> implements IDeployChangeHisService{
    @Autowired
    private IDeployContentChangeHisService deployContentChangeHisService;

    @Override
    public DeployChangeHisVO queryDetail(Long id) {
        LambdaQueryWrapper<DeployChangeHisEntity> lambda = Wrappers.<DeployChangeHisEntity>lambdaQuery();
        lambda.eq(DeployChangeHisEntity::getChangeDeployId, id);
        DeployChangeHisEntity one = this.getOne(lambda);
        DeployChangeHisVO planChangeHisVO = BeanMapper.map(one, DeployChangeHisVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("deployId", new Parameter(QueryParam.EQ, one.getId()));
//        queryParam.getOrderMap().put("treeIndex", "asc");
        List<DeployContentChangeHisEntity> detailEntityListDb = deployContentChangeHisService.queryList(queryParam, false);
        List<DeployContentChangeHisEntity> detailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止项.getCode() != entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }
        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(DeployContentChangeHisEntity cdEntity : detailEntityList){
                cdEntity.setRowState("add");
            }
            List<DeployContentChangeHisVO> resultMapList = BeanMapper.mapList(detailEntityList, DeployContentChangeHisVO.class);
            planChangeHisVO.setDetailList(resultMapList);
        } else {
            planChangeHisVO.setDetailList(BeanMapper.mapList(detailEntityList, DeployContentChangeHisVO.class));
        }
        return planChangeHisVO;
    }
}
