package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bid.bean.DeployContentChangeEntity;
import com.ejianc.business.bid.bean.DeployEntity;
import com.ejianc.business.bid.service.IDeployService;
import com.ejianc.business.bid.vo.DeployChangeHisVO;
import com.ejianc.business.bid.vo.DeployChangeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.DeployChangeMapper;
import com.ejianc.business.bid.bean.DeployChangeEntity;
import com.ejianc.business.bid.service.IDeployChangeService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 投标部署-变更主表
 * 
 * @author generator
 * 
 */
@Service("deployChangeService")
public class DeployChangeServiceImpl extends BaseServiceImpl<DeployChangeMapper, DeployChangeEntity> implements IDeployChangeService{
    @Autowired
    private IDeployChangeService service;
    @Autowired
    private IDeployService deployService;
    @Autowired
    private DeployChangeMapper planChangeMapper;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "BID_DEPLOY_CHANGE";//此处需要根据实际修改

    @Override
    public List<DeployChangeHisVO> queryDetailRecord(Long id) {

        LambdaQueryWrapper<DeployChangeEntity> lambda = Wrappers.<DeployChangeEntity>lambdaQuery();
        lambda.eq(DeployChangeEntity::getSourceDeployId, id);
        lambda.in(DeployChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.orderByDesc(DeployChangeEntity::getCreateTime);
        List<DeployChangeEntity> entities = super.list(lambda);
        List<DeployChangeHisVO> recordVOList = BeanMapper.mapList(entities, DeployChangeHisVO.class);
        recordVOList.forEach(recordVO -> {
                    if (recordVO.getChangeVersion() < 10) {
                        recordVO.setHistoryCode(recordVO.getPlanCode() + "-0" + recordVO.getChangeVersion());
                    }else {
                        recordVO.setHistoryCode(recordVO.getPlanCode() + "-" + recordVO.getChangeVersion());
                    }
                    recordVO.setChangeCode(recordVO.getPlanCode());
                }
        );
        return recordVOList;
    }

    @Override
    public DeployChangeVO saveOrUpdate(DeployChangeVO planVo) {
        //校验项目是否存在未完成的变更计划单存在
        DeployChangeEntity planChangeEntity = service.getUnFinishedChange(planVo.getSourceDeployId());

        if (null != planChangeEntity && (null == planVo.getId() || !planChangeEntity.getId().equals(planVo.getId()))) {
            throw new BusinessException("保存失败，该项目存在未完成的投标部署变更单！");
        }

        DeployEntity masterPlan = deployService.getById(planVo.getSourceDeployId());
        UserContext userContext = sessionManager.getUserContext();
        DeployChangeEntity saveEntity = null;
        if (null == planVo.getId()) {
            saveEntity = BeanMapper.map(planVo, DeployChangeEntity.class);
            saveEntity.setId(IdWorker.getId());
            //设置为自由态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            saveEntity.setChangeVersion(masterPlan.getChangeVersion() + 1);
            saveEntity.setCommitUserName(userContext.getUserName());
            //设置变更人
            saveEntity.setChangeUserName(userContext.getUserName());
            saveEntity.setProjectName(masterPlan.getProjectName());
            saveEntity.setOrgName(masterPlan.getOrgName());
            saveEntity.setOrgId(masterPlan.getOrgId());
            saveEntity.setCreateTime(new Date());
        }
        else {
            saveEntity = service.getById(planVo.getId());
            saveEntity.setProjectId(planVo.getProjectId());
            saveEntity.setProjectName(planVo.getProjectName());
            saveEntity.setRemark(planVo.getRemark());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setDetailList(BeanMapper.mapList(planVo.getDetailList(), DeployContentChangeEntity.class));
        }

        //保存前清空主键和父主键，重新生成
        List<DeployContentChangeEntity> beforeDetails = saveEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == saveEntity.getId()) {
            for (DeployContentChangeEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
            }
        }

        if(planVo.getId() == null || planVo.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),planVo);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                saveEntity.setDeployCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        service.saveOrUpdate(saveEntity, false);
        DeployEntity planEntity = deployService.selectById(saveEntity.getSourceDeployId());
        if (1 != planEntity.getChangeState()) {
            planEntity.setChangeState(1);
            planEntity.setCurChangingDeployId(saveEntity.getId());
            deployService.saveOrUpdate(planEntity, false);
        }

        DeployChangeVO vo = BeanMapper.map(saveEntity, DeployChangeVO.class);

        return vo;
    }

    @Override
    public DeployChangeEntity getUnFinishedChange(Long sourcePlanId) {
        QueryWrapper<DeployChangeEntity> query = new QueryWrapper<>();
        query.eq("source_deploy_id", sourcePlanId);
        List<Integer> billStates = new ArrayList<>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in("bill_state", billStates);
        return planChangeMapper.selectOne(query);
    }

}
