package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bid.bean.BiddingFileReviewEntity;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.bean.PrequaliFicationEntity;
import com.ejianc.business.bid.bean.RecordEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.service.IBiddingFileReviewService;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.service.IPrequaliFicationService;
import com.ejianc.business.bid.service.IRecordService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("prequaliFication")
public class PrequaliFicationBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IPrequaliFicationService prequaliFicationService;
	@Autowired
	private IRecordService recordService;
	@Autowired
	private IEnrollService enrollService;
	@Autowired
	private IBiddingFileReviewService biddingFileReviewService;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("预审数据提交前回调，开始回写状态,billId:"+billId);
		PrequaliFicationEntity prequaliFicationEntity = prequaliFicationService.selectById(billId);
		if (null != prequaliFicationEntity) {
			LambdaUpdateWrapper<EnrollEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(EnrollEntity::getId, prequaliFicationEntity.getEnrollId());
			updateWrapper.set(EnrollEntity::getBidStage,BidStageEnum.ZI_GE_YU_SHEN.getCode());
			if("通过".equals(prequaliFicationEntity.getEstimatedExamineResultName())){
				updateWrapper.set(EnrollEntity::getIsPreChecked,BidCommonConsts.YES);
			}
			enrollService.update(updateWrapper);
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		logger.info("预审数据提交回调，开始回写状态,billId:"+billId);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		logger.info("资格预审，有审批流的撤回前回调，billId"+billId);

		//是否被投标信息跟踪中止单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		//单据未被下游单据引用
		if (res.isSuccess()) {
			PrequaliFicationEntity prequaliFicationEntity = prequaliFicationService.selectById(billId);
			LambdaUpdateWrapper<EnrollEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(EnrollEntity::getId, prequaliFicationEntity.getEnrollId());
			updateWrapper.set(EnrollEntity::getBidStage,BidStageEnum.TOU_BIAO_BAO_MING.getCode());
			if(BidCommonConsts.YES.equals(prequaliFicationEntity.getEstimatedExamineResult())){
				updateWrapper.set(EnrollEntity::getIsPreChecked, BidCommonConsts.NO);
			}
			enrollService.update(updateWrapper);

			recordService.saveRecord(BidStageEnum.TOU_BIAO_BAO_MING, billId, prequaliFicationEntity.getEngineeringCode());
			LambdaQueryWrapper<RecordEntity> recordUpdateWrapper = new LambdaQueryWrapper<>();
			recordUpdateWrapper.eq(RecordEntity::getBillId,billId);
			recordService.remove(recordUpdateWrapper);
			return CommonResponse.success();
		}else{
			return CommonResponse.error(res.getMsg());
		}
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		logger.info("资格预审，有审批流的撤回后回调");
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("终审完成，开始回写状态，billId:"+billId);
		PrequaliFicationEntity prequaliFicationEntity = prequaliFicationService.selectById(billId);
		if (prequaliFicationEntity != null) {
			recordService.saveRecord(BidStageEnum.ZI_GE_YU_SHEN, billId, prequaliFicationEntity.getEngineeringCode());
			LambdaUpdateWrapper<EnrollEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(EnrollEntity::getId, prequaliFicationEntity.getEnrollId());
			updateWrapper.set(EnrollEntity::getBidStage,BidStageEnum.ZI_GE_YU_SHEN.getCode());
			// 如果结论为通过，才回更是否通过字段
			if(BidCommonConsts.YES.equals(prequaliFicationEntity.getEstimatedExamineResult())){
				updateWrapper.set(EnrollEntity::getIsPreChecked,BidCommonConsts.YES);
			}
			enrollService.update(updateWrapper);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("预审数据，弃审前回调，开始回写状态,billId:"+billId);
		PrequaliFicationEntity prequaliFicationEntity = prequaliFicationService.selectById(billId);
		if (null != prequaliFicationEntity) {
			BiddingFileReviewEntity biddingFileReviewEntity = biddingFileReviewService.selectByEnrollId(prequaliFicationEntity.getEnrollId());
			if(biddingFileReviewEntity != null){
				return CommonResponse.error("该单据已被下游单据（招标文件评审）引用");
			}
			LambdaUpdateWrapper<EnrollEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(EnrollEntity::getId, prequaliFicationEntity.getEnrollId());
			updateWrapper.set(EnrollEntity::getBidStage,BidStageEnum.TOU_BIAO_BAO_MING.getCode());
			if(BidCommonConsts.YES.equals(prequaliFicationEntity.getEstimatedExamineResult())){
				updateWrapper.set(EnrollEntity::getIsPreChecked, BidCommonConsts.NO);
			}
			enrollService.update(updateWrapper);
		}
		if(billId != null){
			recordService.saveRecord(BidStageEnum.TOU_BIAO_BAO_MING, billId, prequaliFicationEntity.getEngineeringCode());
			LambdaQueryWrapper<RecordEntity> updateWrapper = new LambdaQueryWrapper<>();
			updateWrapper.eq(RecordEntity::getBillId,billId);
			recordService.remove(updateWrapper);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("预审数据，弃审回调，开始回写状态,billId:"+billId);
		return CommonResponse.success();
	}

}
