/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.bid.bean.EnrollEntity;
import com.ejianc.business.bid.bean.SummaryEntity;
import com.ejianc.business.bid.consts.BidCommonConsts;
import com.ejianc.business.bid.consts.BidStageEnum;
import com.ejianc.business.bid.consts.BidStateEnum;
import com.ejianc.business.bid.service.IEnrollService;
import com.ejianc.business.bid.service.ISummaryService;
import com.ejianc.business.bid.utils.DateUtil;
import com.ejianc.business.bid.vo.SummaryVO;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.consts.ProjectBusinessStatusEnum;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/leaderPortal/"})
public class LeaderPortalController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IEnrollService enrollService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISummaryService summaryService;
    @Autowired
    private IDutyApi dutyApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;

    @PostMapping(value={"queryEnrollInfo"})
    public CommonResponse<JSONObject> queryEnrollInfo(@RequestBody JSONObject params) throws ParseException {
        JSONObject resp = new JSONObject();
        ArrayList<EnrollEntity> indexA = new ArrayList<EnrollEntity>();
        ArrayList<EnrollEntity> indexB = new ArrayList<EnrollEntity>();
        ArrayList<EnrollEntity> keyList = new ArrayList<EnrollEntity>();
        ArrayList<EnrollEntity> nearlyTenDaysList = new ArrayList<EnrollEntity>();
        BigDecimal keyPointMinAmt = new BigDecimal("10000");
        Long orgId = InvocationInfoProxy.getOrgId();
        if (params.containsKey((Object)"orgId")) {
            orgId = params.getLong("orgId");
        }
        if (params.containsKey((Object)"keyPointMinAmt")) {
            keyPointMinAmt = params.getBigDecimal("keyPointMinAmt");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getOrderMap().put("createTime", "desc");
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        String period = DateUtil.format(DateUtils.addDays((Date)new Date(), (int)-14), "yyyy-MM-dd") + "," + DateUtil.format(DateUtils.addDays((Date)new Date(), (int)16), "yyyy-MM-dd");
        queryParam.getParams().put("biddingDate", new Parameter("between", (Object)period));
        queryParam.getParams().put("billState", Parameter.getInInstance((Object)new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()}));
        Date today = DateUtils.parseDate((String)DateUtil.format(new Date(), "yyyy-MM-dd"), (String[])new String[]{"yyyy-MM-dd"});
        List dbList = this.enrollService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            for (EnrollEntity e : dbList) {
                indexA.add(e);
                if (DateUtil.getBetweenDays(today, DateUtils.parseDate((String)DateUtil.format(e.getBiddingDate(), "yyyy-MM-dd"), (String[])new String[]{"yyyy-MM-dd"})) <= 4 && DateUtil.getBetweenDays(DateUtils.parseDate((String)DateUtil.format(e.getBiddingDate(), "yyyy-MM-dd"), (String[])new String[]{"yyyy-MM-dd"}), today) <= 5) {
                    nearlyTenDaysList.add(e);
                    if (BidStateEnum.YI_JIE_SHU.getCode().equals(e.getBidState()) && BidStageEnum.TOU_BIAO_TING_ZHI_SHEN_QING.getCode().equals(e.getBidStage())) {
                        indexB.add(e);
                    }
                }
                if (!ComputeUtil.isGreaterOrEqual((BigDecimal)e.getCostTotal(), (BigDecimal)keyPointMinAmt)) continue;
                keyList.add(e);
            }
        }
        resp.put("indexANum", (Object)indexA.size());
        resp.put("indexAList", indexA);
        resp.put("indexBNum", (Object)indexB.size());
        resp.put("indexBList", indexB);
        resp.put("keyList", keyList);
        resp.put("nearlyTenDaysNum", (Object)nearlyTenDaysList.size());
        resp.put("nearlyTenDaysList", nearlyTenDaysList);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"getIncomeInfo"})
    public CommonResponse<JSONObject> getIncomeInfo(@RequestBody JSONObject params) {
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if (params.containsKey((Object)"orgId")) {
            orgId = params.getLong("orgId");
        }
        int nearlyDays = -30;
        if (params.containsKey((Object)"nearlyDays")) {
            nearlyDays = params.getInteger("nearlyDays");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getOrderMap().put("createTime", "desc");
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("bidResult", Parameter.getEqInstance((Object)BidCommonConsts.NO));
        queryParam.getParams().put("openTenderDate", new Parameter("ge", (Object)DateUtils.addDays((Date)new Date(), (int)nearlyDays)));
        List dbList = this.summaryService.queryList(queryParam);
        resp.put("num", (Object)dbList.size());
        resp.put("dataList", (Object)BeanMapper.mapList((Iterable)dbList, SummaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"getBuildDutyInfo"})
    public CommonResponse<JSONObject> getBuildDutyInfo(@RequestBody JSONObject params) {
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if (params.containsKey((Object)"orgId")) {
            orgId = params.getLong("orgId");
        }
        int nearlyDays = -30;
        if (params.containsKey((Object)"nearlyDays")) {
            nearlyDays = params.getInteger("nearlyDays");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getOrderMap().put("createTime", "desc");
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("openTenderDate", new Parameter("ge", (Object)DateUtils.addDays((Date)new Date(), (int)nearlyDays)));
        List dbList = this.summaryService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            ArrayList enrollIds = new ArrayList(dbList.stream().map(SummaryEntity::getEnrollId).collect(Collectors.toSet()));
            QueryParam enrollQuery = new QueryParam();
            enrollQuery.getParams().put("id", Parameter.getInInstance(enrollIds));
            List entities = this.enrollService.queryList(enrollQuery);
            List projectIds = entities.stream().map(EnrollEntity::getSourceId).collect(Collectors.toList());
            QueryParam prjQuery = new QueryParam();
            prjQuery.getParams().put("id", Parameter.getInInstance(projectIds));
            prjQuery.getParams().put("businessStatus", new Parameter("eq", (Object)ProjectBusinessStatusEnum.\u6b63\u5f0f\u5f00\u5de5.getBusinessStatus()));
            CommonResponse prjResp = this.projectPoolApi.queryArray(prjQuery);
            if (!prjResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u9879\u76eeIDs-\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c {}", JSONObject.toJSON(projectIds), (Object)prjResp);
                return CommonResponse.error((String)"\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
            JSONArray projectJsonArr = (JSONArray)prjResp.getData();
            if (projectJsonArr.size() != 0) {
                ArrayList<Long> validProjectIds = new ArrayList<Long>();
                JSONObject tmp = null;
                for (Object o : projectJsonArr) {
                    tmp = JSONObject.parseObject((String)JSONObject.toJSONString(o));
                    validProjectIds.add(tmp.getLong("id"));
                }
                resp.put("needNum", (Object)validProjectIds.size());
                resp.put("needProjectIds", (Object)JSONObject.toJSONString(validProjectIds));
                CommonResponse extProjectIdsResp = this.dutyApi.queryDutyByProjectIds(validProjectIds);
                if (!extProjectIdsResp.isSuccess()) {
                    this.logger.error("\u6839\u636e\u9879\u76eeIDs-\u67e5\u8be2\u9879\u76ee\u7b56\u5212\u4fe1\u606f\u5931\u8d25\uff0c {}", JSONObject.toJSON(validProjectIds), (Object)extProjectIdsResp);
                    return CommonResponse.error((String)"\u67e5\u8be2\u9879\u76ee\u7b56\u5212\u4fe1\u606f\u5931\u8d25\uff01");
                }
                List extProjectIds = (List)extProjectIdsResp.getData();
                validProjectIds.removeAll(extProjectIds);
                resp.put("finishNum", (Object)extProjectIds.size());
                resp.put("finishProjectIds", (Object)extProjectIds);
                resp.put("unFinishNum", (Object)projectIds.size());
                resp.put("unFinishProjectIds", projectIds);
                return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
            }
        }
        resp.put("needNum", (Object)0);
        resp.put("needProjectIds", (Object)0);
        resp.put("finishNum", (Object)0);
        resp.put("finishProjectIds", new ArrayList());
        resp.put("unFinishNum", (Object)0);
        resp.put("unFinishProjectIds", new ArrayList());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }
}

