/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.ejianc.business.bid.bean.InfoTrackEntity;
import com.ejianc.business.bid.consts.ProjectTrackSurveyEnum;
import com.ejianc.business.bid.mapper.InfoTrackMapper;
import com.ejianc.business.bid.service.IInfoTrackService;
import com.ejianc.business.bid.utils.EJCDateUtil;
import com.ejianc.business.bid.vo.InfoTrackVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="infoTrackService")
public class InfoTrackServiceImpl
extends BaseServiceImpl<InfoTrackMapper, InfoTrackEntity>
implements IInfoTrackService {
    @Autowired
    private InfoTrackMapper mapper;
    @Value(value="${pro.param.currentProvince:#{NULL}}")
    private String currentProvince;
    @Value(value="${pro.param.province:#{NULL}}")
    private String BASE_PROVINCE;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public List<String> countNameRepeatNum(List<String> nameItems) {
        return this.mapper.countNameRepeatNum(nameItems);
    }

    @Override
    public List<InfoTrackVO> queryRecordList() {
        return this.mapper.queryRecordList();
    }

    @Override
    public List<InfoTrackVO> trackCount(String range, String name, String dateIn, Long orgId) {
        String trackStatus = null;
        if (ProjectTrackSurveyEnum.THISYEAR.getCode().equals(dateIn)) {
            dateIn = EJCDateUtil.getYear() + "";
        }
        if (ProjectTrackSurveyEnum.LASTYEAR.getCode().equals(dateIn)) {
            dateIn = EJCDateUtil.getYear() - 1 + "";
        }
        Long curOrgId = orgId == null ? InvocationInfoProxy.getOrgId() : orgId;
        List orgVOList = (List)this.getRespData(this.orgApi.findChildrenByParentId(curOrgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                orgIds.add(org.getId());
            } else {
                orgIds.add(org.getId());
            }
        });
        List<InfoTrackVO> tractList = this.mapper.trackCount(trackStatus, dateIn, orgIds);
        if (CollectionUtils.isNotEmpty(tractList)) {
            tractList.stream().forEach(track -> {
                if (io.micrometer.core.instrument.util.StringUtils.isNotEmpty((String)track.getArea())) {
                    String areaName = null;
                    areaName = this.currentProvince.contains("shenzhen") ? track.getArea().replace("/", "") : track.getArea().replace(",", "").replaceAll("\\/", "");
                    track.setArea(areaName);
                } else {
                    track.setArea(track.getArea());
                }
            });
        }
        return tractList;
    }

    @Override
    public Long countNum(Map<String, Object> queryParam) {
        return this.mapper.countNum(queryParam);
    }

    @Override
    public List<InfoTrackVO> queryTrackList(Map<String, Object> queryParam) {
        return this.mapper.queryTrackList(queryParam);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }
}

