package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bid.bean.SummaryEntity;
import com.ejianc.business.bid.mapper.SummaryMapper;
import com.ejianc.business.bid.service.ISummaryService;
import com.ejianc.business.bid.vo.WinningBidVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 *   投标总结 
 * 
 * @author generator
 * 
 */
@Service("summaryService")
public class SummaryServiceImpl extends BaseServiceImpl<SummaryMapper, SummaryEntity> implements ISummaryService {
    @Autowired
   private SummaryMapper summaryMapper;

    @Override
    public List<WinningBidVO> queryWinningBidList(QueryWrapper wrapper) {
        return summaryMapper.queryWinningBidList(wrapper);
    }

    @Override
    public WinningBidVO querySumbidNumList(List<Long> orgIds, Long tenantId) {
        return summaryMapper.querySumbidNumList(orgIds,tenantId);
    }

    @Override
    public List<WinningBidVO> queryWinningBidPage(Page<WinningBidVO> page, QueryWrapper wrapper) {
        return baseMapper.queryWinningBidList(page, wrapper);
    }

    @Override
    public List<Map<String,Object>> getWinCaseInfo(Map<String, Object> paramMap) {
        return baseMapper.getWinCaseInfo(paramMap);
    }
}
