package com.ejianc.business.bidprice.material.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 材料询价定标-报价记录
 * 
 * @author generator
 * 
 */
public class MaterialPicketageQuoteVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    private Long picketageId; // 主表id
    private Long inquiryId; // 询价单id
    private Long quoteId; // 报价Id
    private Date quoteTime; // 报价时间
    private Long supplierId; // 供应商Id
    private String supplierName; // 供应商名称
    private String socialCreditCode; // 纳税人识别号
    private String legal; // 联系人
    private String telephone; // 联系电话
    private BigDecimal purchaseMny; // 报价总金额
    private String quoteMemo; // 备注
    private String quotePhone; // 报价手机号（登录的手机号）
    private Integer bidFlag; // 是否中标 0-未定标，1-已定标
    private BigDecimal bidMny; // 中标金额
    private String bidMemo; // 中标说明

    private List<PicketageQuotePurchaseDetailVO> purchaseDetailList = new ArrayList<>(); // 材料定标-采购清单
    private List<PicketageQuoteRentDetailVO> rentDetailList = new ArrayList<>(); // 材料定标-租赁清单

    public Long getPicketageId() {
        return picketageId;
    }

    public void setPicketageId(Long picketageId) {
        this.picketageId = picketageId;
    }

    public Long getInquiryId() {
        return inquiryId;
    }

    public void setInquiryId(Long inquiryId) {
        this.inquiryId = inquiryId;
    }
    public Long getQuoteId() {
        return quoteId;
    }

    public void setQuoteId(Long quoteId) {
        this.quoteId = quoteId;
    }
    public Date getQuoteTime() {
        return quoteTime;
    }

    public void setQuoteTime(Date quoteTime) {
        this.quoteTime = quoteTime;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }
    public String getLegal() {
        return legal;
    }

    public void setLegal(String legal) {
        this.legal = legal;
    }
    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }
    public BigDecimal getPurchaseMny() {
        return purchaseMny;
    }

    public void setPurchaseMny(BigDecimal purchaseMny) {
        this.purchaseMny = purchaseMny;
    }
    public String getQuoteMemo() {
        return quoteMemo;
    }

    public void setQuoteMemo(String quoteMemo) {
        this.quoteMemo = quoteMemo;
    }
    public String getQuotePhone() {
        return quotePhone;
    }

    public void setQuotePhone(String quotePhone) {
        this.quotePhone = quotePhone;
    }
    public Integer getBidFlag() {
        return bidFlag;
    }

    public void setBidFlag(Integer bidFlag) {
        this.bidFlag = bidFlag;
    }
    public BigDecimal getBidMny() {
        return bidMny;
    }

    public void setBidMny(BigDecimal bidMny) {
        this.bidMny = bidMny;
    }
    public String getBidMemo() {
        return bidMemo;
    }

    public void setBidMemo(String bidMemo) {
        this.bidMemo = bidMemo;
    }

    public List<PicketageQuoteRentDetailVO> getRentDetailList() {
        return rentDetailList;
    }

    public void setRentDetailList(List<PicketageQuoteRentDetailVO> rentDetailList) {
        this.rentDetailList = rentDetailList;
    }

    public List<PicketageQuotePurchaseDetailVO> getPurchaseDetailList() {
        return purchaseDetailList;
    }

    public void setPurchaseDetailList(List<PicketageQuotePurchaseDetailVO> purchaseDetailList) {
        this.purchaseDetailList = purchaseDetailList;
    }
}
