package com.ejianc.business.bidprice.material.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 报价记录-采购清单
 *
 * @author baipengyan
 */
@ApiModel(value = "MaterialQuotePurchaseDetailVO", description = "材料报价记录-采购清单")
public class MaterialQuotePurchaseDetailVO extends BaseVO {
	private static final long serialVersionUID = -1660360193572855729L;

	@ApiModelProperty(value = "报价单id")
	private Long quoteId;
	@ApiModelProperty(value = "询价单id")
	private Long inquiryId;
	@ApiModelProperty(value = "来源采购清单id")
	private Long sourceId;
	@ApiModelProperty(value = "物资分类Id")
	private Long materialCategoryId;
	@ApiModelProperty(value = "物资分类名称")
	private String materialCategoryName;
	@ApiModelProperty(value = "物资Id")
	private Long materialId;
	@ApiModelProperty(value = "物资名称")
	private String materialName;
	@ApiModelProperty(value = "规格型号")
	private String spec;
	@ApiModelProperty(value = "计量单位")
	private String unit;
	@ApiModelProperty(value = "计划使用日期")
	private Date planUseDate;
	@ApiModelProperty(value = "数量")
	private BigDecimal num;
	@ApiModelProperty(value = "参考价")
	private BigDecimal referPrice;
	@ApiModelProperty(value = "报价")
	private BigDecimal purchaseQuotePrice;
	@ApiModelProperty(value = "金额（询价单）")
	private BigDecimal purchaseInquiryMny;
	@ApiModelProperty(value = "金额")
	private BigDecimal purchaseMny;
	@ApiModelProperty(value = "备注（询价单）")
	private String purchaseInquiryMemo;
	@ApiModelProperty(value = "备注")
	private String purchaseMemo;


	public Long getQuoteId() {
		return quoteId;
	}

	public void setQuoteId(Long quoteId) {
		this.quoteId = quoteId;
	}

	public Long getInquiryId() {
		return inquiryId;
	}

	public void setInquiryId(Long inquiryId) {
		this.inquiryId = inquiryId;
	}

	public Long getSourceId() {
		return sourceId;
	}

	public void setSourceId(Long sourceId) {
		this.sourceId = sourceId;
	}

	public Long getMaterialCategoryId() {
		return materialCategoryId;
	}

	public void setMaterialCategoryId(Long materialCategoryId) {
		this.materialCategoryId = materialCategoryId;
	}

	public String getMaterialCategoryName() {
		return materialCategoryName;
	}

	public void setMaterialCategoryName(String materialCategoryName) {
		this.materialCategoryName = materialCategoryName;
	}

	public Long getMaterialId() {
		return materialId;
	}

	public void setMaterialId(Long materialId) {
		this.materialId = materialId;
	}

	public String getMaterialName() {
		return materialName;
	}

	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}

	public String getSpec() {
		return spec;
	}

	public void setSpec(String spec) {
		this.spec = spec;
	}

	public String getUnit() {
		return unit;
	}

	public void setUnit(String unit) {
		this.unit = unit;
	}

	public Date getPlanUseDate() {
		return planUseDate;
	}

	public void setPlanUseDate(Date planUseDate) {
		this.planUseDate = planUseDate;
	}

	public BigDecimal getNum() {
		return num;
	}

	public void setNum(BigDecimal num) {
		this.num = num;
	}

	public BigDecimal getReferPrice() {
		return referPrice;
	}

	public void setReferPrice(BigDecimal referPrice) {
		this.referPrice = referPrice;
	}

	public BigDecimal getPurchaseQuotePrice() {
		return purchaseQuotePrice;
	}

	public void setPurchaseQuotePrice(BigDecimal purchaseQuotePrice) {
		this.purchaseQuotePrice = purchaseQuotePrice;
	}

	public BigDecimal getPurchaseInquiryMny() {
		return purchaseInquiryMny;
	}

	public void setPurchaseInquiryMny(BigDecimal purchaseInquiryMny) {
		this.purchaseInquiryMny = purchaseInquiryMny;
	}

	public BigDecimal getPurchaseMny() {
		return purchaseMny;
	}

	public void setPurchaseMny(BigDecimal purchaseMny) {
		this.purchaseMny = purchaseMny;
	}

	public String getPurchaseInquiryMemo() {
		return purchaseInquiryMemo;
	}

	public void setPurchaseInquiryMemo(String purchaseInquiryMemo) {
		this.purchaseInquiryMemo = purchaseInquiryMemo;
	}

	public String getPurchaseMemo() {
		return purchaseMemo;
	}

	public void setPurchaseMemo(String purchaseMemo) {
		this.purchaseMemo = purchaseMemo;
	}

}
