package com.ejianc.business.bidprice.material.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.bidprice.material.vo.MaterialResultPurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialResultRentDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 材料定标结果
 * 
 * @author generator
 * 
 */
public class MaterialResultVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Date quoteTime; // 报价时间
    private Long inquiryId; // 询价单id
    private Long picketageId; // 定标单id
    private Long quoteId; // 供应商报价Id
    private Long supplierId; // 中标供应商Id
    private String supplierName; // 中标供应商名称
    private String socialCreditCode; // 纳税人识别号
    private String legal; // 联系人
    private String telephone; // 联系电话
    private BigDecimal totalMny; // 报价总金额
    private String quoteMemo; // 报价备注
    private Integer bidFlag; // 是否中标 0-未定标，1-已定标
    private BigDecimal bidMny; // 中标金额
    private String bidMemo; // 中标说明
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 组织id
    private String orgName; // 组织id
    private String purchaseSubject; // 采购主题
    private Integer purchaseType; // 采购方式：1-项目自采；2-集中采购
    private String purchaseTypeName; // 采购方式名称
    private Integer pricingType; // 计价方式：1-采购；2-租赁
    private String pricingTypeName; // 计价方式名称
    private BigDecimal inquiryMny; // 询价金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date handleDate; // 办理日期
    
    private List<MaterialResultPurchaseDetailVO> materialResultPurchaseDetailList = new ArrayList<>(); // 材料定标结果-采购清单
    private List<MaterialResultRentDetailVO> materialResultRentDetailList = new ArrayList<>(); // 材料定标结果-租赁清单

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getQuoteTime() {
        return quoteTime;
    }

    public void setQuoteTime(Date quoteTime) {
        this.quoteTime = quoteTime;
    }
    public Long getInquiryId() {
        return inquiryId;
    }

    public void setInquiryId(Long inquiryId) {
        this.inquiryId = inquiryId;
    }
    public Long getPicketageId() {
        return picketageId;
    }

    public void setPicketageId(Long picketageId) {
        this.picketageId = picketageId;
    }
    public Long getQuoteId() {
        return quoteId;
    }

    public void setQuoteId(Long quoteId) {
        this.quoteId = quoteId;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }
    public String getLegal() {
        return legal;
    }

    public void setLegal(String legal) {
        this.legal = legal;
    }
    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }
    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }
    public String getQuoteMemo() {
        return quoteMemo;
    }

    public void setQuoteMemo(String quoteMemo) {
        this.quoteMemo = quoteMemo;
    }
    public Integer getBidFlag() {
        return bidFlag;
    }

    public void setBidFlag(Integer bidFlag) {
        this.bidFlag = bidFlag;
    }
    public BigDecimal getBidMny() {
        return bidMny;
    }

    public void setBidMny(BigDecimal bidMny) {
        this.bidMny = bidMny;
    }
    public String getBidMemo() {
        return bidMemo;
    }

    public void setBidMemo(String bidMemo) {
        this.bidMemo = bidMemo;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getPurchaseSubject() {
        return purchaseSubject;
    }

    public void setPurchaseSubject(String purchaseSubject) {
        this.purchaseSubject = purchaseSubject;
    }
    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }
    public Integer getPricingType() {
        return pricingType;
    }

    public void setPricingType(Integer pricingType) {
        this.pricingType = pricingType;
    }
    public String getPricingTypeName() {
        return pricingTypeName;
    }

    public void setPricingTypeName(String pricingTypeName) {
        this.pricingTypeName = pricingTypeName;
    }
    public BigDecimal getInquiryMny() {
        return inquiryMny;
    }

    public void setInquiryMny(BigDecimal inquiryMny) {
        this.inquiryMny = inquiryMny;
    }
    public Date getHandleDate() {
        return handleDate;
    }

    public void setHandleDate(Date handleDate) {
        this.handleDate = handleDate;
    }
    
     public List<MaterialResultPurchaseDetailVO> getMaterialResultPurchaseDetailList() {
        return materialResultPurchaseDetailList;
     }

     public void setMaterialResultPurchaseDetailList(List<MaterialResultPurchaseDetailVO> materialResultPurchaseDetailList) {
        this.materialResultPurchaseDetailList = materialResultPurchaseDetailList;
     }
     public List<MaterialResultRentDetailVO> getMaterialResultRentDetailList() {
        return materialResultRentDetailList;
     }

     public void setMaterialResultRentDetailList(List<MaterialResultRentDetailVO> materialResultRentDetailList) {
        this.materialResultRentDetailList = materialResultRentDetailList;
     }
}
