package com.ejianc.business.bidprice.material.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 材料询价-采购清单
 * 
 * @author generator
 * 
 */
@ApiModel("材料询价-采购清单")
public class ImportMaterialInquiryDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("询价id")
    private Long inquiryId;
    @ApiModelProperty("物资分类Id")
    private Long materialCategoryId;
    @ApiModelProperty("物资分类名称")
    private String materialCategoryName;
    @ApiModelProperty("物资Id")
    private Long materialId;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("计量单位")
    private String unit;
    @ApiModelProperty("数量")
    private BigDecimal num;
    @ApiModelProperty("参考价")
    private BigDecimal referPrice;
    @ApiModelProperty("金额")
    private BigDecimal mny;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("计划使用日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planUseDate;


    //唯一的key需要使用方自己构建
    public String onlyKey;
    //匹配状态
    public String matchStatus;
    //匹配数量
    public String matchNumber;
    //描述
    public String matchStatusDescription;
    /**
     * 导入失败原因
     */
    private String errorMessage;

    /**
     * 询价id
     */
    public Long getInquiryId() {
        return inquiryId;
    }

    /**
     * 询价id
     */
    public void setInquiryId(Long inquiryId) {
        this.inquiryId = inquiryId;
    }
    /**
     * 物资分类Id
     */
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    /**
     * 物资分类Id
     */
    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    /**
     * 物资分类名称
     */
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    /**
     * 物资分类名称
     */
    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    /**
     * 物资Id
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资Id
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 参考价
     */
    public BigDecimal getReferPrice() {
        return referPrice;
    }

    /**
     * 参考价
     */
    public void setReferPrice(BigDecimal referPrice) {
        this.referPrice = referPrice;
    }
    /**
     * 金额
     */
    public BigDecimal getMny() {
        return mny;
    }

    /**
     * 金额
     */
    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 计划使用日期
     */
    public Date getPlanUseDate() {
        return planUseDate;
    }

    /**
     * 计划使用日期
     */
    public void setPlanUseDate(Date planUseDate) {
        this.planUseDate = planUseDate;
    }

    public String getOnlyKey() {
        return onlyKey;
    }

    public void setOnlyKey(String onlyKey) {
        this.onlyKey = onlyKey;
    }

    public String getMatchStatus() {
        return matchStatus;
    }

    public void setMatchStatus(String matchStatus) {
        this.matchStatus = matchStatus;
    }

    public String getMatchNumber() {
        return matchNumber;
    }

    public void setMatchNumber(String matchNumber) {
        this.matchNumber = matchNumber;
    }

    public String getMatchStatusDescription() {
        return matchStatusDescription;
    }

    public void setMatchStatusDescription(String matchStatusDescription) {
        this.matchStatusDescription = matchStatusDescription;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}
