package com.ejianc.business.bidprice.material.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/***
 * @description:  物资价格VO
 */
public class MaterialPriceVO extends BaseVO {

    private static final long serialVersionUID = 4702040708147731199L;

    BigDecimal settledAmount;
    BigDecimal currentSettlementAmount;
    BigDecimal contractAmount;
    String purchaseMethod;


    public String getPurchaseMethod() {
        return purchaseMethod;
    }

    public void setPurchaseMethod(String purchaseMethod) {
        this.purchaseMethod = purchaseMethod;
    }

    public BigDecimal getSettledAmount() {
        return settledAmount;
    }

    public void setSettledAmount(BigDecimal settledAmount) {
        this.settledAmount = settledAmount;
    }

    public BigDecimal getCurrentSettlementAmount() {
        return currentSettlementAmount;
    }

    public void setCurrentSettlementAmount(BigDecimal currentSettlementAmount) {
        this.currentSettlementAmount = currentSettlementAmount;
    }

    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }


    private Long inquiryId;
    /**
     * 项目Id
     */
    private Long projectId;

    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 物资Id
     */
    private Long materialId;
    /**
     * 物资名称
     */
    private String materialName;

    /**
     * 规则/型号
     */
    private String spec;
    /**
     * 单据数量
     */
    private BigDecimal num = BigDecimal.ZERO;
    /**
     * 单据单价
     */
    private BigDecimal referPrice = BigDecimal.ZERO;


	private BigDecimal minPrice = BigDecimal.ZERO;

	private BigDecimal maxPrice = BigDecimal.ZERO;


    private String priceArea = "0.00~0.00";


    private String unit; // 计量单位

    public MaterialPriceVO() {
    }

    public MaterialPriceVO(Long projectId) {
        this.projectId = projectId;
    }

    private List<MaterialPriceVO> detail = new ArrayList<>();

    public Long getInquiryId() {
        return inquiryId;
    }

    public void setInquiryId(Long inquiryId) {
        this.inquiryId = inquiryId;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getMinPrice() {
        return minPrice;
    }

    public void setMinPrice(BigDecimal minPrice) {
        this.minPrice = minPrice;
    }

    public BigDecimal getMaxPrice() {
        return maxPrice;
    }

    public void setMaxPrice(BigDecimal maxPrice) {
        this.maxPrice = maxPrice;
    }

    public String getPriceArea() {
        return priceArea;
    }

    public void setPriceArea(String priceArea) {
        this.priceArea = priceArea;
    }

    public List<MaterialPriceVO> getDetail() {
        return detail;
    }

    public void setDetail(List<MaterialPriceVO> detail) {
	    this.detail = detail;
    }

	public String getSpec() {
		return spec;
	}

	public void setSpec(String spec) {
        this.spec = spec;
    }

    public BigDecimal getReferPrice() {
        return referPrice;
    }

    public void setReferPrice(BigDecimal referPrice) {
        this.referPrice = referPrice;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
}
