package com.ejianc.business.bidprice.material.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 报价记录-租赁清单
 *
 * @author baipengyan
 */
@ApiModel(value = "MaterialQuoteRentDetailVO", description = "材料报价记录-租赁清单")
public class MaterialQuoteRentDetailVO extends BaseVO {
	private static final long serialVersionUID = 6570812670974490689L;

	@ApiModelProperty(value = "报价单id")
	private Long quoteId;
	@ApiModelProperty(value = "询价单id")
	private Long inquiryId;
	@ApiModelProperty(value = "来源采购清单id")
	private Long sourceId;
	@ApiModelProperty(value = "物资分类Id")
	private Long materialCategoryId;
	@ApiModelProperty(value = "物资分类名称")
	private String materialCategoryName;
	@ApiModelProperty(value = "物资Id")
	private Long materialId;
	@ApiModelProperty(value = "物资名称")
	private String materialName;
	@ApiModelProperty(value = "规格型号")
	private String spec;
	@ApiModelProperty(value = "计量单位")
	private String unit;
	@ApiModelProperty(value = "租赁方式")
	private String rentMode;
	@ApiModelProperty(value = "计划使用日期")
	private Date planUseDate;
	@ApiModelProperty(value = "数量")
	private BigDecimal num;
	@ApiModelProperty(value = "租期")
	private BigDecimal rentTerm;
	@ApiModelProperty(value = "参考价")
	private BigDecimal referPrice;
	@ApiModelProperty(value = "报价")
	private BigDecimal rentQuotePrice;
	@ApiModelProperty(value = "金额（询价单）")
	private BigDecimal rentInquiryMny;
	@ApiModelProperty(value = "金额")
	private BigDecimal rentMny;
	@ApiModelProperty(value = "备注（询价单）")
	private String rentInquiryMemo;
	@ApiModelProperty(value = "备注")
	private String rentMemo;


	//供应商名称 冗余主表便于前端显示
	private String supplierName;

	public String getSupplierName() {
		return supplierName;
	}

	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}


	public Long getQuoteId() {
		return quoteId;
	}

	public void setQuoteId(Long quoteId) {
		this.quoteId = quoteId;
	}

	public Long getInquiryId() {
		return inquiryId;
	}

	public void setInquiryId(Long inquiryId) {
		this.inquiryId = inquiryId;
	}

	public Long getSourceId() {
		return sourceId;
	}

	public void setSourceId(Long sourceId) {
		this.sourceId = sourceId;
	}

	public Long getMaterialCategoryId() {
		return materialCategoryId;
	}

	public void setMaterialCategoryId(Long materialCategoryId) {
		this.materialCategoryId = materialCategoryId;
	}

	public String getMaterialCategoryName() {
		return materialCategoryName;
	}

	public void setMaterialCategoryName(String materialCategoryName) {
		this.materialCategoryName = materialCategoryName;
	}

	public Long getMaterialId() {
		return materialId;
	}

	public void setMaterialId(Long materialId) {
		this.materialId = materialId;
	}

	public String getMaterialName() {
		return materialName;
	}

	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}

	public String getSpec() {
		return spec;
	}

	public void setSpec(String spec) {
		this.spec = spec;
	}

	public String getUnit() {
		return unit;
	}

	public void setUnit(String unit) {
		this.unit = unit;
	}

	public String getRentMode() {
		return rentMode;
	}

	public void setRentMode(String rentMode) {
		this.rentMode = rentMode;
	}

	public Date getPlanUseDate() {
		return planUseDate;
	}

	public void setPlanUseDate(Date planUseDate) {
		this.planUseDate = planUseDate;
	}

	public BigDecimal getNum() {
		return num;
	}

	public void setNum(BigDecimal num) {
		this.num = num;
	}

	public BigDecimal getRentTerm() {
		return rentTerm;
	}

	public void setRentTerm(BigDecimal rentTerm) {
		this.rentTerm = rentTerm;
	}

	public BigDecimal getReferPrice() {
		return referPrice;
	}

	public void setReferPrice(BigDecimal referPrice) {
		this.referPrice = referPrice;
	}

	public BigDecimal getRentQuotePrice() {
		return rentQuotePrice;
	}

	public void setRentQuotePrice(BigDecimal rentQuotePrice) {
		this.rentQuotePrice = rentQuotePrice;
	}

	public BigDecimal getRentInquiryMny() {
		return rentInquiryMny;
	}

	public void setRentInquiryMny(BigDecimal rentInquiryMny) {
		this.rentInquiryMny = rentInquiryMny;
	}

	public BigDecimal getRentMny() {
		return rentMny;
	}

	public void setRentMny(BigDecimal rentMny) {
		this.rentMny = rentMny;
	}

	public String getRentInquiryMemo() {
		return rentInquiryMemo;
	}

	public void setRentInquiryMemo(String rentInquiryMemo) {
		this.rentInquiryMemo = rentInquiryMemo;
	}

	public String getRentMemo() {
		return rentMemo;
	}

	public void setRentMemo(String rentMemo) {
		this.rentMemo = rentMemo;
	}

}
