package com.ejianc.business.bidprice.material.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 材料询价-采购清单
 * 
 * @author generator
 * 
 */
@ApiModel("材料询价-采购清单")
public class MaterialInquiryPurchaseDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("询价id")
    private Long inquiryId;
    @ApiModelProperty("物资分类Id")
    private Long materialCategoryId;
    @ApiModelProperty("物资分类名称")
    private String materialCategoryName;
    @ApiModelProperty("物资Id")
    private Long materialId;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("计量单位")
    private String unit;
    @ApiModelProperty("数量")
    private BigDecimal num;
    @ApiModelProperty("参考价")
    private BigDecimal referPrice;
    @ApiModelProperty("金额")
    private BigDecimal mny;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("计划使用日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planUseDate;
    @ApiModelProperty("来源id")
    private String sourceId; // 来源id
    @ApiModelProperty("来源物资来源类型：1-物料档案，2-用料申请,3-新增")
    private String sourceType; // 物资来源类型：1-物料档案，2-用料申请,3-新增，4-导入
    @ApiModelProperty("价格最小值")
    private BigDecimal minPrice;
    @ApiModelProperty("价格最大值")
    private BigDecimal maxPrice;
    @ApiModelProperty("价格区间")
    private String priceArea;

    //唯一的key需要使用方自己构建
    public String onlyKey;

    //针对于这个材料各个供应商报价数据
    List<MaterialQuotePurchaseDetailVO> materialQuotePurchaseDetailVOList;


    //报价最小值
    private BigDecimal  minBidPrice;

    //报价最大值
    private BigDecimal  maxBidPrice;


    public BigDecimal getMinBidPrice() {
        return minBidPrice;
    }

    public void setMinBidPrice(BigDecimal minBidPrice) {
        this.minBidPrice = minBidPrice;
    }

    public BigDecimal getMaxBidPrice() {
        return maxBidPrice;
    }

    public void setMaxBidPrice(BigDecimal maxBidPrice) {
        this.maxBidPrice = maxBidPrice;
    }

    public List<MaterialQuotePurchaseDetailVO> getMaterialQuotePurchaseDetailVOList() {
        return materialQuotePurchaseDetailVOList;
    }

    public void setMaterialQuotePurchaseDetailVOList(List<MaterialQuotePurchaseDetailVO> materialQuotePurchaseDetailVOList) {
        this.materialQuotePurchaseDetailVOList = materialQuotePurchaseDetailVOList;
    }

    /**
     * 询价id
     */
    public Long getInquiryId() {
        return inquiryId;
    }

    /**
     * 询价id
     */
    public void setInquiryId(Long inquiryId) {
        this.inquiryId = inquiryId;
    }
    /**
     * 物资分类Id
     */
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    /**
     * 物资分类Id
     */
    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    /**
     * 物资分类名称
     */
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    /**
     * 物资分类名称
     */
    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    /**
     * 物资Id
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资Id
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 参考价
     */
    public BigDecimal getReferPrice() {
        return referPrice;
    }

    /**
     * 参考价
     */
    public void setReferPrice(BigDecimal referPrice) {
        this.referPrice = referPrice;
    }
    /**
     * 金额
     */
    public BigDecimal getMny() {
        return mny;
    }

    /**
     * 金额
     */
    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 计划使用日期
     */
    public Date getPlanUseDate() {
        return planUseDate;
    }

    /**
     * 计划使用日期
     */
    public void setPlanUseDate(Date planUseDate) {
        this.planUseDate = planUseDate;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public BigDecimal getMinPrice() {
        return minPrice;
    }

    public void setMinPrice(BigDecimal minPrice) {
        this.minPrice = minPrice;
    }

    public BigDecimal getMaxPrice() {
        return maxPrice;
    }

    public void setMaxPrice(BigDecimal maxPrice) {
        this.maxPrice = maxPrice;
    }

    public String getPriceArea() {
        return priceArea;
    }

    public void setPriceArea(String priceArea) {
        this.priceArea = priceArea;
    }

    public String getOnlyKey() {
        return onlyKey;
    }

    public void setOnlyKey(String onlyKey) {
        this.onlyKey = onlyKey;
    }

}
