package com.ejianc.business.bidprice.material.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 材料定标
 * 
 * @author generator
 * 
 */
@ApiModel("材料定标")
public class MaterialPicketageVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("询比价单号")
    private String billCode;
    @ApiModelProperty("采购主题")
    private String name;
    @ApiModelProperty("采购方式 1、项目自采；2、公司集采；")
    private Integer purchaseType;
    @ApiModelProperty("项目名称参照")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("所属组织名称")
    private String orgName;
    @ApiModelProperty("所属组织参照")
    private Long orgId;
    @ApiModelProperty("计价方式")
    private Integer pricingType;
    @ApiModelProperty("询价金额")
    private BigDecimal inquiryMny;
    @ApiModelProperty("中标单位id")
    private String bidWinnerId;
    @ApiModelProperty("中标单位名称")
    private String bidWinnerName;
    @ApiModelProperty("中标金额")
    private BigDecimal bidWinMny;
    @ApiModelProperty("中标金额,多个供应商使用这个")
    private String bidWinMnyStr; // 中标金额(多个供应商使用这个)
    @ApiModelProperty("经办人id")
    private Long employeeId;
    @ApiModelProperty("经办人")
    private String employeeName;
    @ApiModelProperty("办理日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date handleDate;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("合同签订")
    private Integer contractSign; //合同签订
    @ApiModelProperty("合同签订str")
    private String contractSignStr; //合同签订
    @ApiModelProperty("合同签金额")
    private BigDecimal contractSignMny; //合同签金额
    @ApiModelProperty("是否自制")
    private Integer selfFlag;

    @ApiModelProperty("单据状态名称")
    private String billStateName;
    @ApiModelProperty("采购方式名称 1、项目自采；2、公司集采；")
    private String purchaseTypeName;
    @ApiModelProperty("计价方式名称 1 采购 2 租赁")
    private String pricingTypeName;
    
    @ApiModelProperty("材料定标-采购清单")
    private List<MaterialPicketagePurchaseDetailVO> materialPicketagePurchaseDetailList = new ArrayList<>();
    @ApiModelProperty("材料定标-租赁清单")
    private List<MaterialPicketageRentDetailVO> materialPicketageRentDetailList = new ArrayList<>();

    private Long inquiryId;//采购id
    private Integer quotationAuthority; // 报价权限：1-指定供应商；2-所有供应商
    @ApiModelProperty("材料定标-报价记录")
    private List<MaterialPicketageQuoteVO> materialPicketageQuoteList = new ArrayList<>();
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 询比价单号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 询比价单号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 采购主题
     */
    public String getName() {
        return name;
    }

    /**
     * 采购主题
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 采购方式 1、项目自采；2、公司集采；
     */
    public Integer getPurchaseType() {
        return purchaseType;
    }

    /**
     * 采购方式 1、项目自采；2、公司集采；
     */
    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }
    /**
     * 项目名称参照
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目名称参照
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 所属组织参照
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织参照
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 计价方式


     */
    public Integer getPricingType() {
        return pricingType;
    }

    /**
     * 计价方式


     */
    public void setPricingType(Integer pricingType) {
        this.pricingType = pricingType;
    }
    /**
     * 询价金额
     */
    public BigDecimal getInquiryMny() {
        return inquiryMny;
    }

    /**
     * 询价金额
     */
    public void setInquiryMny(BigDecimal inquiryMny) {
        this.inquiryMny = inquiryMny;
    }
    /**
     * 中标单位id
     */
    public String getBidWinnerId() {
        return bidWinnerId;
    }
    /**
     * 中标单位id
     */
    public void setBidWinnerId(String bidWinnerId) {
        this.bidWinnerId = bidWinnerId;
    }

    /**
     * 中标单位名称
     */
    public String getBidWinnerName() {
        return bidWinnerName;
    }

    /**
     * 中标单位名称
     */
    public void setBidWinnerName(String bidWinnerName) {
        this.bidWinnerName = bidWinnerName;
    }
    /**
     * 中标金额
     */
    public BigDecimal getBidWinMny() {
        return bidWinMny;
    }

    /**
     * 中标金额
     */
    public void setBidWinMny(BigDecimal bidWinMny) {
        this.bidWinMny = bidWinMny;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    /**
     * 经办人id
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }



    /**
     * 办理日期
     */
    public Date getHandleDate() {
        return handleDate;
    }

    /**
     * 办理日期
     */
    public void setHandleDate(Date handleDate) {
        this.handleDate = handleDate;
    }

    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getBidWinMnyStr() {
        return bidWinMnyStr;
    }

    public void setBidWinMnyStr(String bidWinMnyStr) {
        this.bidWinMnyStr = bidWinMnyStr;
    }

    public Integer getContractSign() {
        return contractSign;
    }

    public void setContractSign(Integer contractSign) {
        this.contractSign = contractSign;
    }

    public String getContractSignStr() {
        return contractSignStr;
    }

    public void setContractSignStr(String contractSignStr) {
        this.contractSignStr = contractSignStr;
    }

    public BigDecimal getContractSignMny() {
        return contractSignMny;
    }

    public void setContractSignMny(BigDecimal contractSignMny) {
        this.contractSignMny = contractSignMny;
    }

    public Integer getSelfFlag() {
        return selfFlag;
    }

    public void setSelfFlag(Integer selfFlag) {
        this.selfFlag = selfFlag;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public String getPricingTypeName() {
        return pricingTypeName;
    }

    public void setPricingTypeName(String pricingTypeName) {
        this.pricingTypeName = pricingTypeName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    /**
      * 材料定标-采购清单
      */
      public List<MaterialPicketagePurchaseDetailVO> getMaterialPicketagePurchaseDetailList() {
         return materialPicketagePurchaseDetailList;
      }
     /**
      * 材料定标-采购清单
      */
     public void setMaterialPicketagePurchaseDetailList(List<MaterialPicketagePurchaseDetailVO> materialPicketagePurchaseDetailList) {
         this.materialPicketagePurchaseDetailList = materialPicketagePurchaseDetailList;
     }
     /**
      * 材料定标-租赁清单
      */
      public List<MaterialPicketageRentDetailVO> getMaterialPicketageRentDetailList() {
         return materialPicketageRentDetailList;
      }
     /**
      * 材料定标-租赁清单
      */
     public void setMaterialPicketageRentDetailList(List<MaterialPicketageRentDetailVO> materialPicketageRentDetailList) {
         this.materialPicketageRentDetailList = materialPicketageRentDetailList;
     }
    @ReferSerialTransfer(referCode = "materialInquiry")
    public Long getInquiryId() {
        return inquiryId;
    }
    @ReferDeserialTransfer
    public void setInquiryId(Long inquiryId) {
        this.inquiryId = inquiryId;
    }

    public Integer getQuotationAuthority() {
        return quotationAuthority;
    }

    public void setQuotationAuthority(Integer quotationAuthority) {
        this.quotationAuthority = quotationAuthority;
    }

    public List<MaterialPicketageQuoteVO> getMaterialPicketageQuoteList() {
        return materialPicketageQuoteList;
    }

    public void setMaterialPicketageQuoteList(List<MaterialPicketageQuoteVO> materialPicketageQuoteList) {
        this.materialPicketageQuoteList = materialPicketageQuoteList;
    }
}
