package com.ejianc.business.bidprice.material.api;

import com.ejianc.business.bidprice.material.hystrix.ImaterialPicketageHystrix;
import com.ejianc.business.bidprice.material.vo.MaterialPicketageVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 入库单的rpc服务
 * 
 * @author liyongjia
 *
 */
@FeignClient(name= "ejc-bidprice-web", url="${common.env.feign-client-url}", path="ejc-bidprice-web", fallback = ImaterialPicketageHystrix.class)
public interface ImaterialPicketageApi {



    /**
     * @Description 修改合同签订金额和签订数量
     * @Param vo
     * @Return  String
     */
	@RequestMapping(value = "/api/materialPicketage/updateContractSignMny", method=RequestMethod.POST)
	public CommonResponse<String> updateContractSignMny(@RequestBody MaterialPicketageVO vo);
	
}
