package com.ejianc.business.bidprice.material.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 报价记录
 *
 * @author baipengyan
 */
@ApiModel(value = "MaterialQuoteVO", description = "材料报价记录")
public class MaterialQuoteVO extends BaseVO {
	private static final long serialVersionUID = 2540787910105594828L;

	@ApiModelProperty(value = "单据状态 0-自由态，1-已提交")
	private Integer billState;
	@ApiModelProperty(value = "单据编码")
	private String billCode;
	@ApiModelProperty(value = "报价时间")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date quoteTime;
	@ApiModelProperty(value = "询价单id")
	private Long inquiryId;
	@ApiModelProperty(value = "供应商Id")
	private Long supplierId;
	@ApiModelProperty(value = "供应商名称")
	private String supplierName;
	@ApiModelProperty(value = "纳税人识别号")
	private String socialCreditCode;
	@ApiModelProperty(value = "联系人")
	private String legal;
	@ApiModelProperty(value = "联系电话")
	private String telephone;
	@ApiModelProperty(value = "投标总金额")
	private BigDecimal totalMny;
	@ApiModelProperty(value = "备注")
	private String quoteMemo;
	@ApiModelProperty(value = "报价手机号（登录的手机号）")
	private String quotePhone;

	@ApiModelProperty(value = "材料报价记录-采购清单")
	private List<MaterialQuotePurchaseDetailVO> materialQuotePurchaseDetailList = new ArrayList<>();
	@ApiModelProperty(value = "材料报价记录-租赁清单")
	private List<MaterialQuoteRentDetailVO> materialQuoteRentDetailList = new ArrayList<>();




	//冗余显示
	private Integer bidFlag; // 是否中标 0-未定标，1-已定标
	private BigDecimal bidMny; // 中标金额
	private String bidMemo; // 中标说明

	//报价附件
	private Long quoteFileId;

	private String quoteFileName;

	@ApiModelProperty(value = "供应商名称")
	private String supplierNameView;


	@ApiModelProperty(value = "方案版本号")
	private String viewVersion;

	private BigDecimal totalMnyNoTax; // 投标总金额

	public BigDecimal getTotalMnyNoTax() {
		return totalMnyNoTax;
	}

	public void setTotalMnyNoTax(BigDecimal totalMnyNoTax) {
		this.totalMnyNoTax = totalMnyNoTax;
	}


	public String getViewVersion() {
		return viewVersion;
	}

	public void setViewVersion(String viewVersion) {
		this.viewVersion = viewVersion;
	}

	public String getSupplierNameView() {
		return supplierNameView;
	}

	public void setSupplierNameView(String supplierNameView) {
		this.supplierNameView = supplierNameView;
	}

	public Long getQuoteFileId() {
		return quoteFileId;
	}

	public void setQuoteFileId(Long quoteFileId) {
		this.quoteFileId = quoteFileId;
	}

	public String getQuoteFileName() {
		return quoteFileName;
	}

	public void setQuoteFileName(String quoteFileName) {
		this.quoteFileName = quoteFileName;
	}

	public Integer getBidFlag() {
		return bidFlag;
	}

	public void setBidFlag(Integer bidFlag) {
		this.bidFlag = bidFlag;
	}

	public BigDecimal getBidMny() {
		return bidMny;
	}

	public void setBidMny(BigDecimal bidMny) {
		this.bidMny = bidMny;
	}

	public String getBidMemo() {
		return bidMemo;
	}

	public void setBidMemo(String bidMemo) {
		this.bidMemo = bidMemo;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public Date getQuoteTime() {
		return quoteTime;
	}

	public void setQuoteTime(Date quoteTime) {
		this.quoteTime = quoteTime;
	}

	public Long getInquiryId() {
		return inquiryId;
	}

	public void setInquiryId(Long inquiryId) {
		this.inquiryId = inquiryId;
	}

	public Long getSupplierId() {
		return supplierId;
	}

	public void setSupplierId(Long supplierId) {
		this.supplierId = supplierId;
	}

	public String getSupplierName() {
		return supplierName;
	}

	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}

	public String getSocialCreditCode() {
		return socialCreditCode;
	}

	public void setSocialCreditCode(String socialCreditCode) {
		this.socialCreditCode = socialCreditCode;
	}

	public String getLegal() {
		return legal;
	}

	public void setLegal(String legal) {
		this.legal = legal;
	}

	public String getTelephone() {
		return telephone;
	}

	public void setTelephone(String telephone) {
		this.telephone = telephone;
	}

	public BigDecimal getTotalMny() {
		return totalMny;
	}

	public void setTotalMny(BigDecimal totalMny) {
		this.totalMny = totalMny;
	}

	public String getQuoteMemo() {
		return quoteMemo;
	}

	public void setQuoteMemo(String quoteMemo) {
		this.quoteMemo = quoteMemo;
	}

	public String getQuotePhone() {
		return quotePhone;
	}

	public void setQuotePhone(String quotePhone) {
		this.quotePhone = quotePhone;
	}

	public List<MaterialQuotePurchaseDetailVO> getMaterialQuotePurchaseDetailList() {
		return materialQuotePurchaseDetailList;
	}

	public void setMaterialQuotePurchaseDetailList(List<MaterialQuotePurchaseDetailVO> materialQuotePurchaseDetailList) {
		this.materialQuotePurchaseDetailList = materialQuotePurchaseDetailList;
	}

	public List<MaterialQuoteRentDetailVO> getMaterialQuoteRentDetailList() {
		return materialQuoteRentDetailList;
	}

	public void setMaterialQuoteRentDetailList(List<MaterialQuoteRentDetailVO> materialQuoteRentDetailList) {
		this.materialQuoteRentDetailList = materialQuoteRentDetailList;
	}
}
