package com.ejianc.business.bidprice.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 报价记录-租赁清单
 *
 * @author baipengyan
 */
@TableName("ejc_bidprice_material_quote_rent_detail")
public class MaterialQuoteRentDetailEntity extends BaseEntity {
	private static final long serialVersionUID = 1L;

	@TableField(value = "quote_id")
	private Long quoteId; // 报价单id
	@TableField(value = "inquiry_id")
	private Long inquiryId; // 询价单id
	@TableField(value = "source_id")
	private Long sourceId; // 来源租赁清单id
	@TableField(value = "material_category_id")
	private Long materialCategoryId; // 物资分类Id
	@TableField(value = "material_category_name")
	private String materialCategoryName; // 物资分类名称
	@TableField(value = "material_id")
	private Long materialId; // 物资Id
	@TableField(value = "material_name")
	private String materialName; // 物资名称
	@TableField(value = "spec")
	private String spec; // 规格型号
	@TableField(value = "unit")
	private String unit; // 计量单位
	@TableField(value = "rent_mode")
	private String rentMode; // 租赁方式
	@TableField(value = "plan_use_date")
	private Date planUseDate; // 计划使用日期
	@TableField(value = "num")
	private BigDecimal num; // 数量
	@TableField(value = "rent_term")
	private BigDecimal rentTerm; // 租期
	@TableField(value = "refer_price")
	private BigDecimal referPrice; // 参考价
	@TableField(value = "rent_quote_price")
	private BigDecimal rentQuotePrice; // 报价
	@TableField(value = "rent_inquiry_mny")
	private BigDecimal rentInquiryMny; // 金额（询价单）
	@TableField(value = "rent_mny")
	private BigDecimal rentMny; // 金额
	@TableField(value = "rent_inquiry_memo")
	private String rentInquiryMemo; // 备注（询价单）
	@TableField(value = "rent_memo")
	private String rentMemo; // 备注


	public Long getQuoteId() {
		return quoteId;
	}

	public void setQuoteId(Long quoteId) {
		this.quoteId = quoteId;
	}

	public Long getInquiryId() {
		return inquiryId;
	}

	public void setInquiryId(Long inquiryId) {
		this.inquiryId = inquiryId;
	}

	public Long getSourceId() {
		return sourceId;
	}

	public void setSourceId(Long sourceId) {
		this.sourceId = sourceId;
	}

	public Long getMaterialCategoryId() {
		return materialCategoryId;
	}

	public void setMaterialCategoryId(Long materialCategoryId) {
		this.materialCategoryId = materialCategoryId;
	}

	public String getMaterialCategoryName() {
		return materialCategoryName;
	}

	public void setMaterialCategoryName(String materialCategoryName) {
		this.materialCategoryName = materialCategoryName;
	}

	public Long getMaterialId() {
		return materialId;
	}

	public void setMaterialId(Long materialId) {
		this.materialId = materialId;
	}

	public String getMaterialName() {
		return materialName;
	}

	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}

	public String getSpec() {
		return spec;
	}

	public void setSpec(String spec) {
		this.spec = spec;
	}

	public String getUnit() {
		return unit;
	}

	public void setUnit(String unit) {
		this.unit = unit;
	}

	public String getRentMode() {
		return rentMode;
	}

	public void setRentMode(String rentMode) {
		this.rentMode = rentMode;
	}

	public Date getPlanUseDate() {
		return planUseDate;
	}

	public void setPlanUseDate(Date planUseDate) {
		this.planUseDate = planUseDate;
	}

	public BigDecimal getNum() {
		return num;
	}

	public void setNum(BigDecimal num) {
		this.num = num;
	}

	public BigDecimal getRentTerm() {
		return rentTerm;
	}

	public void setRentTerm(BigDecimal rentTerm) {
		this.rentTerm = rentTerm;
	}

	public BigDecimal getReferPrice() {
		return referPrice;
	}

	public void setReferPrice(BigDecimal referPrice) {
		this.referPrice = referPrice;
	}

	public BigDecimal getRentQuotePrice() {
		return rentQuotePrice;
	}

	public void setRentQuotePrice(BigDecimal rentQuotePrice) {
		this.rentQuotePrice = rentQuotePrice;
	}

	public BigDecimal getRentInquiryMny() {
		return rentInquiryMny;
	}

	public void setRentInquiryMny(BigDecimal rentInquiryMny) {
		this.rentInquiryMny = rentInquiryMny;
	}

	public BigDecimal getRentMny() {
		return rentMny;
	}

	public void setRentMny(BigDecimal rentMny) {
		this.rentMny = rentMny;
	}

	public String getRentInquiryMemo() {
		return rentInquiryMemo;
	}

	public void setRentInquiryMemo(String rentInquiryMemo) {
		this.rentInquiryMemo = rentInquiryMemo;
	}

	public String getRentMemo() {
		return rentMemo;
	}

	public void setRentMemo(String rentMemo) {
		this.rentMemo = rentMemo;
	}

}
