package com.ejianc.business.bidprice.material.controller;

import com.ejianc.business.bidprice.common.vo.InquiryCommonVO;
import com.ejianc.business.bidprice.material.service.InquiryCommonService;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;

/**
 * @description: 询价公共服务
 * @author songlx
 * @date 2023/2/8
 * @version 1.0
 */
@Controller
@RequestMapping("inquiryCommon")
@Api(value = "询价公共服务", tags = {"询价公共服务"})
public class InquiryCommonController implements Serializable {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private InquiryCommonService inquiryCommonService;


    /**
     * @description: 查询各个阶段的询价详情
     *
     * @param id
     * @param inquiryState
     * @param inquiryType
     * @return {@link CommonResponse<InquiryCommonVO>}
     * @author songlx
     * @date: 2023/2/8
     */
    @ApiOperation("查询各个阶段的询价详情")
    @RequestMapping(value = "/queryDetailByInquiry", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InquiryCommonVO> queryDetailByInquiry(@RequestParam Long id, @RequestParam Integer inquiryState, @RequestParam String inquiryType) {
        InquiryCommonVO vo = inquiryCommonService.queryDetailByInquiry(id, inquiryState, inquiryType);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


}
