package com.ejianc.business.bidprice.material.service;

import com.ejianc.business.bidprice.common.vo.InquiryCommonVO;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryEntity;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @description: 询价公共服务
 * @author songlx
 * @date 2023/2/8
 * @version 1.0
 */

@Service("inquiryCommonService")
public class InquiryCommonService {

    @Autowired
    private IMaterialInquiryService materialInquiryService;


    /**
     * @description: 查询各个阶段的询价详情
     *
     * @param inquiryId
     * @param inquiryState
     * @param inquiryType
     * @return {@link InquiryCommonVO}
     * @author songlx
     * @date: 2023/2/8
     */
    public InquiryCommonVO queryDetailByInquiry(Long inquiryId, Integer inquiryState, String inquiryType) {
        MaterialInquiryEntity byId = materialInquiryService.getById(inquiryId);

        return BeanMapper.map(byId, InquiryCommonVO.class);
    }
}
