/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bidprice.material.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.bidprice.common.vo.InquiryCommonVO;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryEntity;
import com.ejianc.business.bidprice.material.bean.MaterialQuoteEntity;
import com.ejianc.business.bidprice.material.bean.MaterialQuotePurchaseDetailEntity;
import com.ejianc.business.bidprice.material.bean.MaterialQuoteRentDetailEntity;
import com.ejianc.business.bidprice.material.service.IMaterialInquiryService;
import com.ejianc.business.bidprice.material.service.IMaterialQuotePurchaseDetailService;
import com.ejianc.business.bidprice.material.service.IMaterialQuoteRentDetailService;
import com.ejianc.business.bidprice.material.service.IMaterialQuoteService;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryPurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryRentDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialQuotePurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialQuoteRentDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialQuoteVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="inquiryCommonService")
public class InquiryCommonService {
    @Autowired
    private IMaterialInquiryService materialInquiryService;
    @Autowired
    private IMaterialQuoteService materialQuoteService;
    @Autowired
    private IMaterialQuotePurchaseDetailService materialQuotePurchaseDetailService;
    @Autowired
    private IMaterialQuoteRentDetailService materialQuoteRentDetailService;

    public InquiryCommonVO queryDetailByInquiry(Long inquiryId, Integer inquiryState, String inquiryType) {
        InquiryCommonVO inquiryCommonVO;
        block6: {
            HashMap<Long, String> supplierNameMap;
            ArrayList quoteIds;
            block7: {
                MaterialInquiryEntity byId = (MaterialInquiryEntity)((Object)this.materialInquiryService.selectById(inquiryId));
                inquiryCommonVO = (InquiryCommonVO)BeanMapper.map((Object)((Object)byId), InquiryCommonVO.class);
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(MaterialQuoteEntity::getInquiryId, (Object)inquiryId);
                List list = this.materialQuoteService.list((Wrapper)queryWrapper);
                List materialQuoteVOS = BeanMapper.mapList((Iterable)list, MaterialQuoteVO.class);
                inquiryCommonVO.setMaterialQuoteVOList(materialQuoteVOS);
                if (!CollectionUtils.isNotEmpty((Collection)materialQuoteVOS)) break block6;
                quoteIds = new ArrayList();
                Map<Long, List<MaterialQuoteVO>> supplierQuoteMap = materialQuoteVOS.stream().collect(Collectors.groupingBy(MaterialQuoteVO::getSupplierId));
                supplierNameMap = new HashMap<Long, String>();
                for (Long key : supplierQuoteMap.keySet()) {
                    List<MaterialQuoteVO> valueList = supplierQuoteMap.get(key);
                    if (valueList.size() > 1) {
                        int i = 1;
                        for (MaterialQuoteVO materialQuoteVO : valueList) {
                            materialQuoteVO.setSupplierName(materialQuoteVO.getSupplierName() + " (\u65b9\u6848" + i++ + ")");
                            supplierNameMap.put(materialQuoteVO.getId(), materialQuoteVO.getSupplierName());
                        }
                        continue;
                    }
                    supplierNameMap.put(valueList.get(0).getId(), valueList.get(0).getSupplierName());
                }
                if (inquiryCommonVO.getPricingType() != 1) break block7;
                LambdaQueryWrapper purchaseDetailEntityLambdaQueryWrapper = new LambdaQueryWrapper();
                purchaseDetailEntityLambdaQueryWrapper.in(MaterialQuotePurchaseDetailEntity::getQuoteId, quoteIds);
                List purchaseDetailEntityList = this.materialQuotePurchaseDetailService.list((Wrapper)purchaseDetailEntityLambdaQueryWrapper);
                List materialQuotePurchaseDetailVOS = BeanMapper.mapList((Iterable)purchaseDetailEntityList, MaterialQuotePurchaseDetailVO.class);
                if (!CollectionUtils.isNotEmpty((Collection)materialQuotePurchaseDetailVOS)) break block6;
                materialQuotePurchaseDetailVOS.forEach(t -> t.setSupplierName((String)supplierNameMap.get(t.getQuoteId())));
                Map<Long, List<MaterialQuotePurchaseDetailVO>> purchaseQuoteMap = materialQuotePurchaseDetailVOS.stream().collect(Collectors.groupingBy(MaterialQuotePurchaseDetailVO::getSourceId));
                List materialInquiryPurchaseDetailList = inquiryCommonVO.getMaterialInquiryPurchaseDetailList();
                for (MaterialInquiryPurchaseDetailVO materialInquiryPurchaseDetailVO : materialInquiryPurchaseDetailList) {
                    materialInquiryPurchaseDetailVO.setMaterialQuotePurchaseDetailVOList(purchaseQuoteMap.get(materialInquiryPurchaseDetailVO.getId()));
                }
                break block6;
            }
            LambdaQueryWrapper rentDetailEntityLambdaQueryWrapper = new LambdaQueryWrapper();
            rentDetailEntityLambdaQueryWrapper.in(MaterialQuoteRentDetailEntity::getQuoteId, quoteIds);
            List rentDetailEntityList = this.materialQuoteRentDetailService.list((Wrapper)rentDetailEntityLambdaQueryWrapper);
            List materialQuoteRentDetailVOS = BeanMapper.mapList((Iterable)rentDetailEntityList, MaterialQuoteRentDetailVO.class);
            if (CollectionUtils.isNotEmpty((Collection)materialQuoteRentDetailVOS)) {
                materialQuoteRentDetailVOS.forEach(t -> t.setSupplierName((String)supplierNameMap.get(t.getQuoteId())));
                Map<Long, List<MaterialQuoteRentDetailVO>> rentQuoteMap = materialQuoteRentDetailVOS.stream().collect(Collectors.groupingBy(MaterialQuoteRentDetailVO::getSourceId));
                List materialInquiryRentDetailList = inquiryCommonVO.getMaterialInquiryRentDetailList();
                for (MaterialInquiryRentDetailVO materialInquiryRentDetailVO : materialInquiryRentDetailList) {
                    materialInquiryRentDetailVO.setMaterialQuoteRentDetailVOList(rentQuoteMap.get(materialInquiryRentDetailVO.getId()));
                }
            }
        }
        return inquiryCommonVO;
    }
}

