/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bidprice.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryEntity;
import com.ejianc.business.bidprice.material.bean.MaterialPicketageEntity;
import com.ejianc.business.bidprice.material.bean.MaterialPicketagePurchaseDetailEntity;
import com.ejianc.business.bidprice.material.bean.MaterialPicketageRentDetailEntity;
import com.ejianc.business.bidprice.material.bean.MaterialPicketageSupplierEntity;
import com.ejianc.business.bidprice.material.bean.MaterialQuoteEntity;
import com.ejianc.business.bidprice.material.bean.MaterialResultEntity;
import com.ejianc.business.bidprice.material.bean.MaterialResultPurchaseDetailEntity;
import com.ejianc.business.bidprice.material.bean.MaterialResultRentDetailEntity;
import com.ejianc.business.bidprice.material.mapper.MaterialPicketageMapper;
import com.ejianc.business.bidprice.material.service.IMaterialInquiryService;
import com.ejianc.business.bidprice.material.service.IMaterialPicketageService;
import com.ejianc.business.bidprice.material.service.IMaterialPicketageSupplierService;
import com.ejianc.business.bidprice.material.service.IMaterialQuoteService;
import com.ejianc.business.bidprice.material.service.IMaterialResultService;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryPurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryRentDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryVO;
import com.ejianc.business.bidprice.material.vo.MaterialQuoteVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialPicketageService")
public class MaterialPicketageServiceImpl
extends BaseServiceImpl<MaterialPicketageMapper, MaterialPicketageEntity>
implements IMaterialPicketageService {
    @Autowired
    private IMaterialPicketageSupplierService supplierService;
    @Autowired
    private IMaterialPicketageService service;
    @Autowired
    private IMaterialResultService materialResultService;
    @Autowired
    private IMaterialInquiryService inquiryService;
    @Autowired
    private IMaterialQuoteService quoteService;

    @Override
    public boolean insertOrUpdate(MaterialPicketageEntity entity) {
        ArrayList supplierEntities = new ArrayList();
        ArrayList supplierList = new ArrayList();
        Boolean success = super.saveOrUpdate((Object)entity, false);
        if (!(!success.booleanValue() || ListUtil.isEmpty(entity.getMaterialPicketagePurchaseDetailList()) && ListUtil.isEmpty(entity.getMaterialPicketageRentDetailList()))) {
            entity.getMaterialPicketagePurchaseDetailList().forEach(sub -> supplierList.addAll(sub.getMaterialPicketageSupplierList()));
            if (entity.getPricingType() == 1) {
                List<MaterialPicketagePurchaseDetailEntity> purchaseList = entity.getMaterialPicketagePurchaseDetailList();
                List ids = purchaseList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(ids)) {
                    QueryParam param = new QueryParam();
                    param.getParams().put("picketageDetailId", new Parameter("in", ids));
                    List suppliers = this.supplierService.queryList(param, false);
                    if (!ListUtil.isEmpty((List)suppliers)) {
                        this.supplierService.removeByIds(suppliers.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
                    }
                    purchaseList.forEach(sub -> sub.getMaterialPicketageSupplierList().forEach(supplier -> {
                        supplier.setPicketageDetailId(sub.getId());
                        supplierEntities.add(supplier);
                    }));
                }
            } else {
                List<MaterialPicketageRentDetailEntity> rentList = entity.getMaterialPicketageRentDetailList();
                List ids = rentList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(ids)) {
                    QueryParam param = new QueryParam();
                    param.getParams().put("picketageDetailId", new Parameter("in", ids));
                    List suppliers = this.supplierService.queryList(param, false);
                    if (!ListUtil.isEmpty((List)suppliers)) {
                        this.supplierService.removeByIds(suppliers.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
                    }
                    rentList.forEach(sub -> sub.getMaterialPicketageSupplierList().forEach(supplier -> {
                        supplier.setPicketageDetailId(sub.getId());
                        supplierEntities.add(supplier);
                    }));
                }
            }
            if (CollectionUtils.isNotEmpty(supplierEntities)) {
                this.supplierService.saveOrUpdateBatch(supplierEntities, supplierEntities.size());
            }
        }
        return true;
    }

    @Override
    public void pushPicketage(Long billId) {
        MaterialPicketageEntity entity = (MaterialPicketageEntity)((Object)this.service.selectById(billId));
        if (entity.getSelfFlag() == 1) {
            MaterialResultEntity materialResultEntity = this.builderResultEntity(entity);
            this.materialResultService.saveOrUpdate((Object)materialResultEntity, false);
        }
    }

    @Override
    public void rollBackPicketage(Long billId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"picketage_id", (Object)billId);
        List list = this.materialResultService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.materialResultService.removeByIds(list.stream().map(BaseEntity::getId).collect(Collectors.toList()), true);
        }
    }

    public MaterialResultEntity builderResultEntity(MaterialPicketageEntity entity) {
        MaterialResultEntity result = new MaterialResultEntity();
        ArrayList<MaterialResultPurchaseDetailEntity> purchaseList = new ArrayList<MaterialResultPurchaseDetailEntity>();
        ArrayList<MaterialResultRentDetailEntity> rentList = new ArrayList<MaterialResultRentDetailEntity>();
        result.setPicketageId(entity.getId());
        if (StringUtils.isNotEmpty((String)entity.getBidWinnerId())) {
            result.setSupplierId(Long.parseLong(entity.getBidWinnerId()));
            result.setSupplierName(entity.getBidWinnerName());
        }
        result.setProjectId(entity.getProjectId());
        result.setProjectName(entity.getProjectName());
        result.setOrgId(entity.getOrgId());
        result.setOrgName(entity.getOrgName());
        result.setPurchaseSubject(entity.getName());
        result.setPricingType(entity.getPricingType());
        result.setPricingTypeName(entity.getPricingType() == 1 ? "\u91c7\u8d2d" : "\u79df\u8d41");
        result.setPurchaseType(entity.getPurchaseType());
        result.setPurchaseTypeName(entity.getPricingType() == 1 ? "\u9879\u76ee\u81ea\u91c7" : "\u516c\u53f8\u96c6\u91c7");
        result.setBillCode(entity.getBillCode());
        result.setInquiryMny(entity.getInquiryMny());
        result.setBidFlag(1);
        result.setHandleDate(entity.getHandleDate());
        result.setBidMny(entity.getBidWinMny());
        if (CollectionUtils.isNotEmpty(entity.getMaterialPicketagePurchaseDetailList()) || CollectionUtils.isNotEmpty(entity.getMaterialPicketageRentDetailList())) {
            MaterialPicketageSupplierEntity materialPicketageSupplierEntity;
            Map<Object, Object> winSupplierMap = new HashMap();
            if (StringUtils.isNotEmpty((String)entity.getBidWinnerId())) {
                QueryParam param = new QueryParam();
                param.getParams().put("supplierId", new Parameter("eq", (Object)Long.parseLong(entity.getBidWinnerId())));
                List supplierEntities = this.supplierService.queryList(param, false);
                winSupplierMap = supplierEntities.stream().collect(Collectors.toMap(k -> k.getPicketageDetailId(), k -> k));
            }
            for (MaterialPicketagePurchaseDetailEntity purchase : entity.getMaterialPicketagePurchaseDetailList()) {
                MaterialResultPurchaseDetailEntity resultPurchase = new MaterialResultPurchaseDetailEntity();
                resultPurchase.setMaterialCategoryId(purchase.getMaterialCategoryId());
                resultPurchase.setMaterialCategoryName(purchase.getMaterialCategoryName());
                resultPurchase.setMaterialId(purchase.getMaterialId());
                resultPurchase.setMaterialName(purchase.getMaterialName());
                resultPurchase.setSpec(purchase.getSpec());
                resultPurchase.setUnit(purchase.getUnit());
                resultPurchase.setResidueNum(purchase.getNum());
                resultPurchase.setReferPrice(purchase.getReferPrice());
                resultPurchase.setSourceId(purchase.getId());
                if (!winSupplierMap.isEmpty()) {
                    materialPicketageSupplierEntity = (MaterialPicketageSupplierEntity)((Object)winSupplierMap.get(purchase.getId()));
                    resultPurchase.setBidNum(purchase.getNum());
                    resultPurchase.setBidPrice(materialPicketageSupplierEntity.getPrice());
                    resultPurchase.setBidMny(materialPicketageSupplierEntity.getMny());
                }
                purchaseList.add(resultPurchase);
            }
            for (MaterialPicketageRentDetailEntity rent : entity.getMaterialPicketageRentDetailList()) {
                MaterialResultRentDetailEntity resultRent = new MaterialResultRentDetailEntity();
                resultRent.setMaterialCategoryId(rent.getMaterialCategoryId());
                resultRent.setMaterialCategoryName(rent.getMaterialCategoryName());
                resultRent.setMaterialId(rent.getMaterialId());
                resultRent.setMaterialName(rent.getMaterialName());
                resultRent.setSpec(rent.getSpec());
                resultRent.setUnit(rent.getUnit());
                resultRent.setResidueNum(rent.getNum());
                resultRent.setReferPrice(rent.getReferPrice());
                resultRent.setRentTerm(rent.getRentTerm());
                resultRent.setRentMode(rent.getRentMode());
                resultRent.setSourceId(rent.getId());
                if (!winSupplierMap.isEmpty()) {
                    materialPicketageSupplierEntity = (MaterialPicketageSupplierEntity)((Object)winSupplierMap.get(rent.getId()));
                    resultRent.setBidNum(rent.getNum());
                    resultRent.setBidPrice(materialPicketageSupplierEntity.getPrice());
                    resultRent.setBidMny(materialPicketageSupplierEntity.getMny());
                }
                rentList.add(resultRent);
            }
        }
        if (CollectionUtils.isNotEmpty(rentList) || CollectionUtils.isNotEmpty(purchaseList)) {
            result.setMaterialResultRentDetailList(rentList);
            result.setMaterialResultPurchaseDetailList(purchaseList);
        }
        return result;
    }

    @Override
    public CommonResponse<JSONObject> queryByInquiryToDetailAndQuote(String inquiryId) {
        JSONObject jsonObject = new JSONObject();
        Map<Object, Object> collect = new HashMap();
        MaterialInquiryEntity materialInquiryEntity = (MaterialInquiryEntity)((Object)this.inquiryService.selectById((Serializable)((Object)inquiryId)));
        MaterialInquiryVO inquiryVO = (MaterialInquiryVO)BeanMapper.map((Object)((Object)materialInquiryEntity), MaterialInquiryVO.class);
        if (inquiryVO.getPricingType().equals(new Integer(1))) {
            collect = inquiryVO.getMaterialInquiryPurchaseDetailList().stream().collect(Collectors.toMap(BaseVO::getId, MaterialInquiryPurchaseDetailVO::getNum));
            jsonObject.put("purchaseList", (Object)inquiryVO.getMaterialInquiryPurchaseDetailList());
        } else {
            collect = inquiryVO.getMaterialInquiryRentDetailList().stream().collect(Collectors.toMap(BaseVO::getId, MaterialInquiryRentDetailVO::getNum));
            jsonObject.put("rentList", (Object)inquiryVO.getMaterialInquiryRentDetailList());
        }
        jsonObject.put("totalMap", collect);
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambdaQueryWrapper.eq(MaterialQuoteEntity::getInquiryId, (Object)inquiryId);
        lambdaQueryWrapper.in(MaterialQuoteEntity::getBillState, (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List list = this.quoteService.list((Wrapper)lambdaQueryWrapper);
        jsonObject.put("quoteList", (Object)BeanMapper.mapList((Iterable)list, MaterialQuoteVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }
}

