package com.ejianc.business.bidprice.material.controller.api;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bidprice.material.bean.MaterialPicketageEntity;
import com.ejianc.business.bidprice.material.service.IMaterialPicketageService;
import com.ejianc.business.bidprice.material.vo.MaterialPicketageVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;


@RestController
@RequestMapping("/api/materialPicketage")
public class ImaterialPicketageApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialPicketageService service;

    /**
     * @Description 修改合同签订金额和签订数量
     * @Param vo
     * @Return String
     */
    @RequestMapping(value = "/updateContractSignMny", method = RequestMethod.POST)
    public CommonResponse<String> updateContractSignMny(@RequestBody MaterialPicketageVO vo) {
        if(vo.getId() != null){
            LambdaUpdateWrapper<MaterialPicketageEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(MaterialPicketageEntity::getId, vo.getId());
            updateWrapper.set(MaterialPicketageEntity::getContractSign, vo.getContractSign());
            updateWrapper.set(MaterialPicketageEntity::getContractSignMny, vo.getContractSignMny());
            service.update(updateWrapper);
        }
        return CommonResponse.success("修改合同签订数成功！");
    }

}
