/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bidprice.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bidprice.consts.InquiryStateEnum;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryEntity;
import com.ejianc.business.bidprice.material.mapper.MaterialInquiryMapper;
import com.ejianc.business.bidprice.material.service.IMaterialInquiryService;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryPurchaseDetailVO;
import com.ejianc.business.bidprice.material.vo.MaterialInquiryVO;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialInquiryService")
public class MaterialInquiryServiceImpl
extends BaseServiceImpl<MaterialInquiryMapper, MaterialInquiryEntity>
implements IMaterialInquiryService {
    @Autowired
    private MaterialInquiryMapper materialInquiryMapper;
    @Autowired
    private IMaterialSettlementApi materialSettlementApi;

    @Override
    public MaterialInquiryVO updateInquiry(MaterialInquiryVO updateVo) {
        Long id = updateVo.getId();
        Date quoteEndDate = updateVo.getQuoteEndDate();
        Boolean quoteEndFlag = updateVo.getQuoteEndFlag();
        MaterialInquiryEntity entity = (MaterialInquiryEntity)((Object)super.selectById((Serializable)id));
        if (entity != null) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)id);
            updateWrapper.set(MaterialInquiryEntity::getQuoteEndDate, (Object)quoteEndDate);
            if (quoteEndFlag.booleanValue()) {
                updateWrapper.set(MaterialInquiryEntity::getInquiryState, (Object)InquiryStateEnum.EXPIRATION_STATE.getCode());
            }
            super.update((Wrapper)updateWrapper);
        }
        return updateVo;
    }

    @Override
    public MaterialInquiryVO queryMaterialPrice(MaterialInquiryVO vo) {
        List purchaseDetailList = vo.getMaterialInquiryPurchaseDetailList();
        if (CollectionUtils.isNotEmpty((Collection)purchaseDetailList)) {
            MaterialPriceVO materialPriceVO;
            List dd;
            MaterialPriceVO priceVO = new MaterialPriceVO();
            ArrayList detail = new ArrayList();
            purchaseDetailList.forEach(item -> {
                MaterialPriceVO materialPriceVO = new MaterialPriceVO();
                materialPriceVO.setMaterialId(Long.valueOf(item.getMaterialId()));
                detail.add(materialPriceVO);
            });
            priceVO.setDetail(detail);
            CommonResponse commonResponse = this.materialSettlementApi.queryPrice(priceVO);
            if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(dd = (materialPriceVO = (MaterialPriceVO)commonResponse.getData()).getDetail()))) {
                Map<Long, MaterialPriceVO> priceVOMap = dd.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                for (MaterialInquiryPurchaseDetailVO v : vo.getMaterialInquiryPurchaseDetailList()) {
                    Long materialId = v.getMaterialId();
                    MaterialPriceVO p = priceVOMap.get(materialId);
                    if (null == p) continue;
                    v.setMinPrice(p.getMinPrice());
                    v.setMaxPrice(p.getMaxPrice());
                    v.setPriceArea(p.getMinPrice().setScale(2, 4) + "~" + p.getMaxPrice().setScale(2, 4));
                }
            }
        }
        return vo;
    }

    @Override
    public void updateInquiry(Long inquiryId, Integer inquiryState) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)inquiryId);
        updateWrapper.set(MaterialInquiryEntity::getInquiryState, (Object)inquiryState);
        super.update((Wrapper)updateWrapper);
    }
}

