package com.ejianc.business.bidprice.material.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 材料定标-采购清单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_bidprice_material_picketage_purchase_detail")
public class MaterialPicketagePurchaseDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="picketage_id")
    private Long picketageId; // 主表id
    @TableField(value="material_category_id")
    private Long materialCategoryId; // 物资分类id
    @TableField(value="material_category_name")
    private String materialCategoryName; // 物资分类名称
    @TableField(value="material_id")
    private Long materialId; // 物资id
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="unit")
    private String unit; // 计量单位
    @TableField(value="refer_price")
    private BigDecimal referPrice; // 参考价
    @TableField(value="num")
    private BigDecimal num; // 数量
    @TableField(value="mny")
    private BigDecimal mny; // 金额
    @TableField(value="quote_area")
    private String quoteArea; // 报价区间

    @TableField(value="source_id")
    private String sourceId; // 来源id
    @TableField(value="source_type")
    private String sourceType; // 物资来源类型：1-物料档案，2-用料申请,3-新增

    @TableField(exist=false)
    @SubEntity(serviceName="materialPicketageSupplierService",pidName = "picketageDetailId")//此处有pid="xxx"，默认值pid="pid"
    private List<MaterialPicketageSupplierEntity> materialPicketageSupplierList = new ArrayList<>(); // 材料定标-供应商
    
    
    

    public Long getPicketageId() {
        return picketageId;
    }

    public void setPicketageId(Long picketageId) {
        this.picketageId = picketageId;
    }
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public BigDecimal getReferPrice() {
        return referPrice;
    }

    public void setReferPrice(BigDecimal referPrice) {
        this.referPrice = referPrice;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public String getQuoteArea() {
        return quoteArea;
    }

    public void setQuoteArea(String quoteArea) {
        this.quoteArea = quoteArea;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public List<MaterialPicketageSupplierEntity> getMaterialPicketageSupplierList() {
        return materialPicketageSupplierList;
    }

    public void setMaterialPicketageSupplierList(List<MaterialPicketageSupplierEntity> materialPicketageSupplierList) {
        this.materialPicketageSupplierList = materialPicketageSupplierList;
    }
}
