package com.ejianc.business.bidprice.material.controller.api;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bidprice.consts.InquiryStateEnum;
import com.ejianc.business.bidprice.material.bean.MaterialInquiryEntity;
import com.ejianc.business.bidprice.material.bean.MaterialPicketageEntity;
import com.ejianc.business.bidprice.material.bean.MaterialResultEntity;
import com.ejianc.business.bidprice.material.service.IMaterialInquiryService;
import com.ejianc.business.bidprice.material.service.IMaterialPicketageService;
import com.ejianc.business.bidprice.material.service.IMaterialResultService;
import com.ejianc.business.bidprice.material.vo.MaterialPicketageVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;


@RestController
@RequestMapping("/api/materialPicketage")
public class ImaterialPicketageApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialPicketageService service;


    @Autowired
    private IMaterialResultService materialResultService;

    @Autowired
    private IMaterialInquiryService materialInquiryService;

    /**
     * @Description 修改合同签订金额和签订数量
     * @Param vo
     * @Return String
     */
    @RequestMapping(value = "/updateContractSignMny", method = RequestMethod.POST)
    public CommonResponse<String> updateContractSignMny(@RequestBody MaterialPicketageVO vo) {
        //定标结果id
        Long resultId = vo.getId();
        if (resultId != null) {
            MaterialResultEntity materialResultEntity = materialResultService.getById(resultId);
            // 通过定标结果更新定标合同签订数量和金额
            if (materialResultEntity != null) {
                LambdaUpdateWrapper<MaterialPicketageEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(MaterialPicketageEntity::getId, materialResultEntity.getPicketageId());
                updateWrapper.set(MaterialPicketageEntity::getContractSign, vo.getContractSign());
                updateWrapper.set(MaterialPicketageEntity::getContractSignMny, vo.getContractSignMny());
                service.update(updateWrapper);
                //合同签订后回写询价单状态,合同签订数量大于0为已签订，否则改为已定标
                LambdaUpdateWrapper<MaterialInquiryEntity> inquiryUpdateWrapper = new LambdaUpdateWrapper<>();
                inquiryUpdateWrapper.eq(MaterialInquiryEntity::getId,materialResultEntity.getInquiryId());
                logger.info("定标申请id----------------------------------："+materialResultEntity.getInquiryId());
                logger.info("合同签订数量----------------------------------："+vo.getContractSign());
                if(vo.getContractSign() != null && vo.getContractSign() > 0){
                    inquiryUpdateWrapper.set(MaterialInquiryEntity::getInquiryState, InquiryStateEnum.SIGN_STATE.getCode());
                }else{
                    inquiryUpdateWrapper.set(MaterialInquiryEntity::getInquiryState, InquiryStateEnum.WIN_STATE.getCode());
                }
                materialInquiryService.update(inquiryUpdateWrapper);
            }
        }
        return CommonResponse.success("修改合同签订数成功！");
    }

}
