package com.ejianc.business.bidprice.material.service;

import com.ejianc.business.bidprice.material.bean.MaterialQuoteEntity;
import com.ejianc.business.bidprice.material.vo.MaterialQuoteVO;
import com.ejianc.framework.skeleton.template.IBaseService;

/**
 * 报价记录
 *
 * @author baipengyan
 */
public interface IMaterialQuoteService extends IBaseService<MaterialQuoteEntity> {

	/**
	 * 指定供应商登录、所有供应商登录校验查看权限
	 *
	 * @param inquiryId   询价单id
	 * @param phoneNumber 电话号码
	 */
	void checkViewAuthority(Long inquiryId, String phoneNumber);

	/**
	 * 指定供应商报价校验报价权限
	 *
	 * @param inquiryId   询价单id
	 * @param phoneNumber 电话号码
	 */
	void checkQuotationAuthority(Long inquiryId, String phoneNumber);

	/**
	 * 获取验证码
	 *
	 * @param inquiryId   询价单id
	 * @param phoneNumber 电话号码
	 */
	void fetchVerifyCode(Long inquiryId, String phoneNumber) throws Exception;

	/**
	 * 登录
	 *
	 * @param phoneNumber 电话号码
	 * @param validate    验证码
	 */
	void login(String phoneNumber, String validate);


	/**
	 * 收回
	 *
	 * @param id 报价单id
	 */
	void withdraw(Long id);

	/**
	 * 修改单据状态
	 *
	 * @param id        id
	 * @param billState 单据状态
	 */
	void changeStatus(Long id, Integer billState);

	/**
	 * 最近一次的报价记录
	 *
	 * @param phoneNumber 报价手机号码（当前登录的手机号码）
	 *
	 * @return {@link MaterialQuoteVO}
	 */
	MaterialQuoteVO recentQuote(String phoneNumber);
}
