package com.ejianc.business.bidprice.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 报价记录-采购清单
 *
 * @author baipengyan
 */
@TableName("ejc_bidprice_material_quote_purchase_detail")
public class MaterialQuotePurchaseDetailEntity extends BaseEntity {
	private static final long serialVersionUID = -2934846829440675825L;

	@TableField(value = "quote_id")
	private Long quoteId; // 报价单id
	@TableField(value = "inquiry_id")
	private Long inquiryId; // 询价单id
	@TableField(value = "source_id")
	private Long sourceId; // 来源采购清单id
	@TableField(value = "material_category_id")
	private Long materialCategoryId; // 物资分类Id
	@TableField(value = "material_category_name")
	private String materialCategoryName; // 物资分类名称
	@TableField(value = "material_id")
	private Long materialId; // 物资Id
	@TableField(value = "material_name")
	private String materialName; // 物资名称
	@TableField(value = "spec")
	private String spec; // 规格型号
	@TableField(value = "unit")
	private String unit; // 计量单位
	@TableField(value = "plan_use_date")
	private Date planUseDate; // 计划使用日期
	@TableField(value = "num")
	private BigDecimal num; // 数量
	@TableField(value = "refer_price")
	private BigDecimal referPrice; // 参考价
	@TableField(value = "purchase_quote_price")
	private BigDecimal purchaseQuotePrice; // 报价
	@TableField(value = "purchase_inquiry_mny")
	private BigDecimal purchaseInquiryMny; // 金额（询价单）
	@TableField(value = "purchase_mny")
	private BigDecimal purchaseMny; // 金额
	@TableField(value = "purchase_inquiry_memo")
	private String purchaseInquiryMemo; // 备注（询价单）
	@TableField(value = "purchase_memo")
	private String purchaseMemo; // 备注

	@TableField(value = "purchase_quote_price_no_tax")
	private BigDecimal purchaseQuotePriceNoTax; // 报价

	@TableField(value = "purchase_mny_no_tax")
	private BigDecimal purchaseMnyNoTax; // 金额



	@TableField(value = "purchase_rate")
	private BigDecimal purchaseRate; // 报价税率


	public BigDecimal getPurchaseRate() {
		return purchaseRate;
	}

	public void setPurchaseRate(BigDecimal purchaseRate) {
		this.purchaseRate = purchaseRate;
	}

	public BigDecimal getPurchaseQuotePriceNoTax() {
		return purchaseQuotePriceNoTax;
	}

	public void setPurchaseQuotePriceNoTax(BigDecimal purchaseQuotePriceNoTax) {
		this.purchaseQuotePriceNoTax = purchaseQuotePriceNoTax;
	}

	public BigDecimal getPurchaseMnyNoTax() {
		return purchaseMnyNoTax;
	}

	public void setPurchaseMnyNoTax(BigDecimal purchaseMnyNoTax) {
		this.purchaseMnyNoTax = purchaseMnyNoTax;
	}

	public Long getQuoteId() {
		return quoteId;
	}

	public void setQuoteId(Long quoteId) {
		this.quoteId = quoteId;
	}

	public Long getInquiryId() {
		return inquiryId;
	}

	public void setInquiryId(Long inquiryId) {
		this.inquiryId = inquiryId;
	}

	public Long getSourceId() {
		return sourceId;
	}

	public void setSourceId(Long sourceId) {
		this.sourceId = sourceId;
	}

	public Long getMaterialCategoryId() {
		return materialCategoryId;
	}

	public void setMaterialCategoryId(Long materialCategoryId) {
		this.materialCategoryId = materialCategoryId;
	}

	public String getMaterialCategoryName() {
		return materialCategoryName;
	}

	public void setMaterialCategoryName(String materialCategoryName) {
		this.materialCategoryName = materialCategoryName;
	}

	public Long getMaterialId() {
		return materialId;
	}

	public void setMaterialId(Long materialId) {
		this.materialId = materialId;
	}

	public String getMaterialName() {
		return materialName;
	}

	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}

	public String getSpec() {
		return spec;
	}

	public void setSpec(String spec) {
		this.spec = spec;
	}

	public String getUnit() {
		return unit;
	}

	public void setUnit(String unit) {
		this.unit = unit;
	}

	public Date getPlanUseDate() {
		return planUseDate;
	}

	public void setPlanUseDate(Date planUseDate) {
		this.planUseDate = planUseDate;
	}

	public BigDecimal getNum() {
		return num;
	}

	public void setNum(BigDecimal num) {
		this.num = num;
	}

	public BigDecimal getReferPrice() {
		return referPrice;
	}

	public void setReferPrice(BigDecimal referPrice) {
		this.referPrice = referPrice;
	}

	public BigDecimal getPurchaseQuotePrice() {
		return purchaseQuotePrice;
	}

	public void setPurchaseQuotePrice(BigDecimal purchaseQuotePrice) {
		this.purchaseQuotePrice = purchaseQuotePrice;
	}

	public BigDecimal getPurchaseInquiryMny() {
		return purchaseInquiryMny;
	}

	public void setPurchaseInquiryMny(BigDecimal purchaseInquiryMny) {
		this.purchaseInquiryMny = purchaseInquiryMny;
	}

	public BigDecimal getPurchaseMny() {
		return purchaseMny;
	}

	public void setPurchaseMny(BigDecimal purchaseMny) {
		this.purchaseMny = purchaseMny;
	}

	public String getPurchaseInquiryMemo() {
		return purchaseInquiryMemo;
	}

	public void setPurchaseInquiryMemo(String purchaseInquiryMemo) {
		this.purchaseInquiryMemo = purchaseInquiryMemo;
	}

	public String getPurchaseMemo() {
		return purchaseMemo;
	}

	public void setPurchaseMemo(String purchaseMemo) {
		this.purchaseMemo = purchaseMemo;
	}

}
