package com.ejianc.business.desktop.api;

import com.ejianc.business.desktop.hystrix.ShareCategoryHystrix;
import com.ejianc.business.desktop.vo.CategoryVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 *
 *
 * @author yqls
 *
 */
@FeignClient(name= "ejc-tender-web", url="${common.env.feign-client-url}", path="ejc-tender-web", fallback = ShareCategoryHystrix.class)
public interface IShareCategoryApi {

	/**
	 *新增或修改
	 * @return
	 */
	@GetMapping(value = "/api/category/query")
    CommonResponse<List<CategoryVO>> query(@RequestBody List<String> query);

}
