package com.ejianc.business.desktop.api;

import com.ejianc.business.desktop.hystrix.ShareCategoryHystrix;
import com.ejianc.business.desktop.vo.CategoryVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 *
 *
 * @author
 *
 */
@FeignClient(name= "ejc-bpmdesktop-web", url="${common.env.feign-client-url}", path="ejc-bpmdesktop-web", fallback = ShareCategoryHystrix.class)
public interface IShareCategoryApi {

	/**
	 *新增或修改
	 * @return
	 */
	@GetMapping(value = "/api/category/query")
    CommonResponse<List<CategoryVO>> query(@RequestParam String[] codes);

	/**
	 *根据身份证号获取用户id
	 * @return
	 */
	@GetMapping(value = "/api/idm/queryUserIdByCard")
	CommonResponse<Long> queryUserIdByCard(@RequestParam String card);

}
