package com.ejianc.business.desktop.service.impl;


import com.ejianc.business.desktop.mapper.BpmMessageMapper;
import com.ejianc.business.desktop.service.IBpmMessageService;
import com.ejianc.business.desktop.vo.BpmSendMessageVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("bpmMessage")
public class BpmMessageServiceImpl extends BaseServiceImpl<BpmMessageMapper, BpmSendMessageVO> implements IBpmMessageService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private BpmMessageMapper bpmMessageMapper;

    @Override
    public List<BpmSendMessageVO> queryBpmMessage(String billCode, String billTypeName) {
        return bpmMessageMapper.queryBpmMessage(billCode,billTypeName);
    }

    @Override
    public List<String> selectGroupRoleUserRef(Long docId) {
        return bpmMessageMapper.selectGroupRoleUserRef(docId);
    }
}
