package com.ejianc.business.desktop.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.bean.ProjectSetPoolEntity;
import com.ejianc.business.desktop.bean.TaskinstEntity;
import com.ejianc.business.desktop.mapper.UserMapper;
import com.ejianc.business.desktop.mapper.WarnMapper;
import com.ejianc.business.desktop.service.IUserInfoService;
import com.ejianc.business.desktop.service.IWarnService;
import com.ejianc.business.desktop.vo.TaskVO;
import com.ejianc.business.desktop.vo.idmUser.SalaryUserVO;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.usercenter.vo.UserRefVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 *
 * 
 * @author generator
 * 
 */
@Service("userInfoService")
public class UserInfoServiceImpl extends BaseServiceImpl<UserMapper, ProjectSetPoolEntity> implements IUserInfoService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UserMapper mapper;
    @Autowired
    private UserMapper userMapper;
    @Override
    public List<SalaryUserVO> syncUserDataByTime(String time) {
        logger.info("接口接收时间：{}",time);
        return mapper.syncUserDataByTime(time);
    }

    @Override
    public List<String> getOrgCodeList(Long orgId) {
        return mapper.getOrgCodeList(orgId);

    }

    @Override
    public OrgVO queryDetail(Long orgId) {
        return baseMapper.queryDetail(orgId);
    }
    @Override
    public IPage<UserRefVO> pageList(Map<String, Object> params) {
        List<UserRefVO> voList = new ArrayList<>();
        IPage<UserRefVO> page = new Page<>();
        if(params.get("pageNumber")!=null){
            Integer pn = Integer.parseInt(params.get("pageNumber").toString());
            pn = pn - 1 < 0 ? 1 : pn;
            long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
            params.put("startLine", startLine);
        }
        long total = userMapper.countRef(params);
        page.setTotal(total);
        if(total == 0) {
            page.setRecords(voList);
            return page;
        }
        voList = userMapper.queryListRef(params);

        page.setRecords(voList);
        return page;
    }

    @Override
    public List<UserVO> getWeixineeIdList() {
        List<UserVO> list = mapper.getWeixineeIdList();
       return list;
    }

    @Override
    public UserVO getUserByWeixineeId(String weixineeId) {
        return baseMapper.getUserByWeixineeId(weixineeId);
    }
}
