package com.ejianc.business.desktop.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.desktop.service.IProjectSetService;
import com.ejianc.business.desktop.service.IUserInfoService;
import com.ejianc.business.desktop.vo.BpmSendMessageVO;
import com.ejianc.business.desktop.vo.CategoryVO;
import com.ejianc.business.desktop.vo.idmUser.SalaryUserVO;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.usercenter.vo.UserRefVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.*;

/**
 *
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("api/idm")
public class UserInfoController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IProjectSetService projectSetService;

    @Autowired
    private IUserInfoService service;

    /**
     * @Description
     * @param
     */
    @RequestMapping(value = "/queryUserIdByCard", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Long> queryUserIdByCard(@RequestParam String card) {
        //获取用户的id
        return CommonResponse.success("查询详情数据成功！",projectSetService.queryUserIdByCard(card));
    }


    /**
     * @Description 对比人力数据是否同步
     * @param
     */
    @RequestMapping(value = "/queryUserSyncState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> queryUserSyncState(@RequestParam(required = true) Integer property,
                                                    @RequestParam(required = true) String idCard,
                                                   @RequestParam(required = false) String orgCode,
                                                   @RequestParam(required = false) String deptCode,
                                                   @RequestParam(required = false) String postCode,
                                                   @RequestParam(required = false) String jobStartTime) {

        List<Long> longs =  projectSetService.queryUserSyncState(property,idCard, orgCode, deptCode, postCode, jobStartTime);


        if(CollectionUtils.isNotEmpty(longs)){
            return CommonResponse.success("查询详情数据成功！",true);
        }
        return CommonResponse.success("查询详情数据成功！",false);

    }


    /**
     * @Description
     * @param
     */
    @RequestMapping(value = "/syncUserDataByTime", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SalaryUserVO>> syncUserDataByTime(@RequestParam(value = "time") String time){
        //
        return CommonResponse.success("查询详情数据成功！",service.syncUserDataByTime(time));
    }


    /**
     * 根据orgId获取下面的部门Code
     *
     * @param
     * @return
     */
    @GetMapping("getOrgCodeList")
    public CommonResponse<List<String>> getOrgCodeList(@RequestParam(value = "orgId")  Long orgId) {
        List<String> orgCodeList = service.getOrgCodeList(orgId);
        return CommonResponse.success("查询成功！",orgCodeList);
    }



    //查询用户+人员+任职（condition中若包含roleId则过滤该角色下的数据）
    @RequestMapping(value = "refUserPage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<UserRefVO>> refUserPage(
            @RequestParam(defaultValue = "1") int pageNumber,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestParam(required=false) String relyCondition,
            @RequestParam(required=false) String relyNode,
            @RequestParam(required=false) String searchText,
            @RequestParam(required=false) String condition,
            @RequestParam(required=false) String searchObject
    ) {
        Map<String,Object> params = new HashMap<>();
        if(StringUtils.isNotBlank(relyCondition)){
            Long orgId = Long.parseLong(relyCondition.split("=")[1]);
            OrgVO orgVo = service.queryDetail(orgId);
            if(orgVo != null) {
                params.put("innerCode", orgVo.getInnerCode());
            }else{
                params.put("deptId", orgId);
            }
        }
        if(StringUtils.isNotBlank(condition)){
            JSONObject conditionJson = JSONObject.parseObject(condition);
            if(!params.containsKey("innerCode") && !params.containsKey("deptId") && conditionJson.get("deptOrOrgId") != null) {
                Long orgId = Long.parseLong(conditionJson.get("deptOrOrgId").toString());
                OrgVO orgVo = service.queryDetail(orgId);
                if(orgVo != null) {
                    params.put("innerCode", orgVo.getInnerCode());
                }else{
                    params.put("deptId", orgId);
                }
            }
            if(conditionJson.get("roleId")!=null){
                params.put("roleId", Long.parseLong(conditionJson.get("roleId").toString()));
            }else{
                params.put("allProperty", "allProperty");
            }
            if(conditionJson.get("property")!=null){
                params.put("property", Long.parseLong(conditionJson.get("property").toString()));
                if(params.get("allProperty")!=null){
                    params.remove("allProperty");
                }
            }
            if(conditionJson.get("empState")!=null){
                params.put("empState", Integer.parseInt(conditionJson.get("empState").toString()));
            }
            if(conditionJson.get("userType")!=null){
                params.put("userType", Integer.parseInt(conditionJson.get("userType").toString()));
            }
            if(conditionJson.get("postNull")!=null){
                params.put("postNull", "true");
            }
        }else{
            params.put("allProperty", "allProperty");
        }
        if(StringUtils.isNotBlank(searchText)) {
            params.put("searchText", searchText);
        }
        params.put("pageNumber", pageNumber);
        params.put("pageSize", pageSize);
        params.put("tenantId", InvocationInfoProxy.getTenantid());

        if(StringUtils.isNotBlank(searchObject)){
            JSONObject search = JSONObject.parseObject(searchObject);
            if(search.get("mobilePhone")!=null){
                params.put("mobilePhone", search.get("mobilePhone").toString());
            }
            if(search.get("userName")!=null){
                params.put("userName", search.get("userName").toString());
            }
            if(search.get("jobType")!=null&&params.get("property")==null){
                if("直属".equals(search.get("jobType").toString())){
                    params.put("property", 1l);
                    if(params.get("allProperty")!=null){
                        params.remove("allProperty");
                    }
                }
                if("隶属".equals(search.get("jobType").toString())){
                    params.put("property", 0l);
                    if(params.get("allProperty")!=null){
                        params.remove("allProperty");
                    }
                }
            }
            if(search.get("orgName")!=null){
                params.put("orgName", search.get("orgName").toString());
            }

        }

        IPage<UserRefVO> dataList =  service.pageList(params);
        dataList.setCurrent(pageNumber);
        dataList.setSize(pageSize);

        return CommonResponse.success("查询成功！", dataList);
    }



    @RequestMapping(value = "/getWeixineeIdList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<UserVO>> getWeixineeIdList(){
        logger.info("getWeixineeIdList");
        List<UserVO> stringList = service.getWeixineeIdList();
        logger.info("getWeixineeIdList获取的个数"+stringList.size());
        return CommonResponse.success("查询成功！",stringList);
    }


    @RequestMapping(value = "/getUserByWeixineeId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UserVO> getUserByWeixineeId(@RequestParam(value = "weixineeId") String weixineeId){
        logger.info("getWeixineeIdList");
        UserVO stringList = service.getUserByWeixineeId(weixineeId);
        return CommonResponse.success("查询成功！",stringList);
    }
    @RequestMapping(value = "/getUserByWeixineeCode", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UserVO> getUserByWeixineeCode(@RequestParam(value = "weixineeCode") String weixineeCode){
        return CommonResponse.success("查询详情数据成功！",service.getUserByWeixineeId(weixineeCode));
    }


}

