package com.ejianc.business.desktop.controller;

import java.io.Serializable;

import com.ejianc.business.desktop.mapper.TaskinstMapper;
import com.ejianc.business.desktop.vo.BpmVariableVO;
import com.ejianc.business.desktop.vo.UserInfoVO;
import com.ejianc.business.promaterial.contract.api.IPromaterialContractApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.desktop.bean.TaskinstEntity;
import com.ejianc.business.desktop.service.ITaskinstService;
import com.ejianc.business.desktop.vo.TaskinstVO;

/**
 * 流程主题门户接口
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("taskinst")
public class TaskinstController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ITaskinstService service;
    @Autowired
    private IPromaterialContractApi contractApi;

    @Autowired
    private TaskinstMapper mapper;
    @Autowired
    private SessionManager sessionManager;

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 年度个人绩效
     * @param
     */
    @RequestMapping(value = "/queryYearUser", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryYearUser(@RequestBody QueryParam param) {

        /**
         * 处理今年或去年
         */
        Calendar date = Calendar.getInstance();
        Integer integer = Integer.valueOf(date.get(Calendar.YEAR));//本年
        String yearFlag = String.valueOf(param.getParams().get("yearFlag").getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
             integer = Integer.valueOf(date.get(Calendar.YEAR)) - 1;//上一年
        }
        String yearStart = integer+"-01-01 00:00:00";
        String yearEnd = integer+"-12-31 23:59:59";


        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(param.getParams().get("createTime").getValue()).split(",");
            yearStart = createTimes[0]+" 00:00:00";
            yearEnd = createTimes[1]+" 23:59:59";
        }

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
             start = format.parse(yearStart);
             end = format.parse(yearEnd);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        //排序
        String timeSort = null;
        if (null != param.getOrderMap().get("timeSort") ) {
            timeSort = param.getOrderMap().get("timeSort");
        }
        String count = null;
        if (null != param.getOrderMap().get("count") ) {
            count = param.getOrderMap().get("count");
        }
        String sumTime = null;
        if (null != param.getOrderMap().get("sumTime") ) {
            sumTime = param.getOrderMap().get("sumTime");
        }
        String orgCode = null;
        if (null != param.getOrderMap().get("orgCode") ) {
            orgCode = param.getOrderMap().get("orgCode");
        }

        //模糊搜索
        String searchText = param.getSearchText();
        if (searchText != null){
            searchText = "%"+searchText+"%";
        }

        //获取当前用户的id
        UserContext userContextCache =sessionManager.getUserContext();
        Long userId = userContextCache.getUserId();

        Long orgId = null;
        if (null != param.getParams().get("orgId") ) {
            orgId = Long.parseLong(String.valueOf(param.getParams().get("orgId").getValue()));//
            userId = null;//存在orgId表示从组织列表跳转，则需要显示所有的用户
        }
        Long deptId = null;
        if (null != param.getParams().get("deptId") ) {
            deptId = Long.parseLong(String.valueOf(param.getParams().get("deptId").getValue()));//
        }


        //deptId为经营管理层可以查看全部
        //为某一个部门的，可以查看本部门的
        if (null != param.getParams().get("isAllFlag")) {
            //orgId = userContextCache.getOrgId();
            Long deptId1 = userContextCache.getDeptId();
            logger.info("orgId:{},deptId1:{}",orgId,deptId1);
            if (deptId1 != null) {
                if (deptId1 == 1502571152969568257L) {
                    userId = null;
                } else {
                    deptId = deptId1;
                    userId = null;
                }
            }
        }

        //自定义查询，拼接查询语句
        Page<TaskinstVO> page = new Page<>(param.getPageIndex(), param.getPageSize());


        List<TaskinstVO> vo = service.queryLastYearUser(page,userId,orgId,deptId,start,end,
                timeSort,count,sumTime,orgCode,searchText);

        vo.stream().forEach(taskinstVO -> {
            if (taskinstVO.getAvgTime() != null) {
                taskinstVO.setAvgTime(taskinstVO.getAvgTime() / (1000 * 60 * 60));
            }else {
                taskinstVO.setAvgTime(0.00);
            }
            if (taskinstVO.getSumTime() != null) {
                taskinstVO.setSumTime(taskinstVO.getSumTime() / (1000 * 60 * 60));
            }else {
                taskinstVO.setSumTime(0.00);
            }
        });
        IPage<TaskinstVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);

        //List<TaskinstVO> vo = BeanMapper.mapList(entity, TaskinstVO.class);
        return CommonResponse.success("查询详情数据成功！",pageData);
    }

    /**
     * @Description 个人流程详情
     * @param
     */
    @RequestMapping(value = "/queryUserDetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryUserDetail(@RequestBody QueryParam param) {

        /**
         * 处理今年或去年
         */
        Calendar date = Calendar.getInstance();
        Integer integer = Integer.valueOf(date.get(Calendar.YEAR));//本年
        String yearFlag = String.valueOf(param.getParams().get("yearFlag").getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
            integer = Integer.valueOf(date.get(Calendar.YEAR)) - 1;//上一年
        }
        String yearStart = integer+"-01-01 00:00:00";
        String yearEnd = integer+"-12-31 23:59:59";


        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(param.getParams().get("createTime").getValue()).split(",");
            yearStart = createTimes[0]+" 00:00:00";
            yearEnd = createTimes[1]+" 23:59:59";
        }

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = format.parse(yearStart);
            end = format.parse(yearEnd);
        } catch (ParseException e) {
            e.printStackTrace();
        }


        //自定义查询，拼接查询语句
        Page<TaskinstVO> page = new Page<>(param.getPageIndex(), param.getPageSize());

        //获取当前用户的id
        //UserContext userContextCache =sessionManager.getUserContext();
        Long userId = 0L;
        if (null != param.getParams().get("userId") ) {
            userId = Long.parseLong(String.valueOf(param.getParams().get("userId").getValue()));//上一年
        }

        String stateFlag = null;
        if (null != param.getParams().get("stateFlag") ) {
            stateFlag = String.valueOf(param.getParams().get("stateFlag").getValue());//流程类型
        }
        List<TaskinstVO> vo = service.queryUserDetail(page,userId,start,end,stateFlag);
        //List<TaskinstVO> vo = BeanMapper.mapList(entity, TaskinstVO.class);
        vo.stream().forEach(taskinstVO -> {
            if(taskinstVO.getDuration() != null) {
                taskinstVO.setDurationTime(((double) taskinstVO.getDuration()) / (1000 * 60 * 60));
            }else {
                taskinstVO.setDurationTime(0.00);
            }
        });
        IPage<TaskinstVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);
        return CommonResponse.success("查询详情数据成功！",pageData);
    }


    /**
     * @Description 年度组织绩效
     * @param
     */
    @RequestMapping(value = "/queryYearOrgUnder", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryYearOrgUnder(@RequestBody QueryParam param) {

        /**
         * 处理今年或去年
         */
        Calendar date = Calendar.getInstance();
        Integer integer = Integer.valueOf(date.get(Calendar.YEAR));//本年
        String yearFlag = String.valueOf(param.getParams().get("yearFlag").getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
            integer = Integer.valueOf(date.get(Calendar.YEAR)) - 1;//上一年
        }
        String yearStart = integer+"-01-01 00:00:00";
        String yearEnd = integer+"-12-31 23:59:59";

        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(param.getParams().get("createTime").getValue()).split(",");
            yearStart = createTimes[0]+" 00:00:00";
            yearEnd = createTimes[1]+" 23:59:59";
        }

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = format.parse(yearStart);
            end = format.parse(yearEnd);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        //获取当前用户的id
        UserContext userContextCache =sessionManager.getUserContext();
        //排序
        String timeSort = null;
        if (null != param.getOrderMap().get("timeSort") ) {
            timeSort = param.getOrderMap().get("timeSort");
        }
        String count = null;
        if (null != param.getOrderMap().get("count") ) {
            count = param.getOrderMap().get("count");
        }
        String sumTime = null;
        if (null != param.getOrderMap().get("sumTime") ) {
            sumTime = param.getOrderMap().get("sumTime");
        }
        String orgCode = null;
        if (null != param.getOrderMap().get("orgCode") ) {
            orgCode = param.getOrderMap().get("orgCode");
        }

        //模糊搜索
        String searchText = param.getSearchText();
        if (searchText != null){
            searchText = "%"+searchText+"%";
        }

        //deptId为经营管理层可以查看全部
        //为某一个部门的，可以查看本部门的
        Long deptId = userContextCache.getDeptId();
        String glcFlag = null;
        if (deptId != null){
            if (deptId == 1502571152969568257L){
                deptId = null;
                glcFlag = "true";
            }
        }
        List<TaskinstVO> vo = new ArrayList<>();
        //自定义查询，拼接查询语句
        Page<TaskinstVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        Long orgId = InvocationInfoProxy.getOrgId();

        String groupFlag = "true";
        if (null != param.getParams().get("orgId")) {//获取门户的数据
             groupFlag = null;
        }
            //获取报表的数据

            List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
            List<Long> collect = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
            vo = service.queryYearOrgUnder(page, collect, start, end, timeSort, deptId,
                    groupFlag,count,sumTime,orgCode,searchText,glcFlag);


        vo.stream().forEach(taskinstVO -> {
            taskinstVO.setAvgTime(taskinstVO.getAvgTime()/(1000*60*60));
            taskinstVO.setSumTime(taskinstVO.getSumTime()/(1000*60*60));
        });

        IPage<TaskinstVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);

        //List<TaskinstVO> vo = BeanMapper.mapList(entity, TaskinstVO.class);
        return CommonResponse.success("查询详情数据成功！",pageData);
    }

    /**
     * @Description 年度组织绩效
     * @param
     */
    @RequestMapping(value = "/queryYearOrg", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryYearOrg(@RequestBody QueryParam param) {

        /**
         * 处理今年或去年
         */
        Calendar date = Calendar.getInstance();
        Integer integer = Integer.valueOf(date.get(Calendar.YEAR));//本年
        String yearFlag = String.valueOf(param.getParams().get("yearFlag").getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
            integer = Integer.valueOf(date.get(Calendar.YEAR)) - 1;//上一年
        }
        String yearStart = integer+"-01-01 00:00:00";
        String yearEnd = integer+"-12-31 23:59:59";

        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(param.getParams().get("createTime").getValue()).split(",");
            yearStart = createTimes[0]+" 00:00:00";
            yearEnd = createTimes[1]+" 23:59:59";
        }

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = format.parse(yearStart);
            end = format.parse(yearEnd);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        //获取当前用户的id
        UserContext userContextCache =sessionManager.getUserContext();
        //排序
        String timeSort = null;
        if (null != param.getOrderMap().get("timeSort") ) {
            timeSort = param.getOrderMap().get("timeSort");
        }
        String count = null;
        if (null != param.getOrderMap().get("count") ) {
            count = param.getOrderMap().get("count");
        }
        String sumTime = null;
        if (null != param.getOrderMap().get("sumTime") ) {
            sumTime = param.getOrderMap().get("sumTime");
        }
        String orgCode = null;
        if (null != param.getOrderMap().get("orgCode") ) {
            orgCode = param.getOrderMap().get("orgCode");
        }

        //模糊搜索
        String searchText = param.getSearchText();
        if (searchText != null){
            searchText = "%"+searchText+"%";
        }

        //deptId为经营管理层可以查看全部
        //为某一个部门的，可以查看本部门的
        Long deptId = userContextCache.getDeptId();
        if (deptId != null){
            if (deptId == 1502571152969568257L){
                deptId = null;
            }
        }
        List<TaskinstVO> vo = new ArrayList<>();
        //自定义查询，拼接查询语句
        Page<TaskinstVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        Long orgId = InvocationInfoProxy.getOrgId();

        String groupFlag = "true";
        if (null != param.getParams().get("orgId")) {//获取门户的数据
            groupFlag = null;
        }

        if (null != param.getParams().get("org")) {//穿透的数据
            orgId = Long.parseLong(String.valueOf(param.getParams().get("org").getValue()));
            deptId = null;
        }
        //获取报表的数据

        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        List<Long> collect = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
        vo = service.queryYearOrg(page, collect, start, end, timeSort, deptId,
                groupFlag,count,sumTime,orgCode,searchText);





        vo.stream().forEach(taskinstVO -> {
            taskinstVO.setAvgTime(taskinstVO.getAvgTime()/(1000*60*60));
            taskinstVO.setSumTime(taskinstVO.getSumTime()/(1000*60*60));
        });
        IPage<TaskinstVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);

        //List<TaskinstVO> vo = BeanMapper.mapList(entity, TaskinstVO.class);
        return CommonResponse.success("查询详情数据成功！",pageData);
    }


    /**
     * @Description 年度组织绩效
     * @param
     */
    @RequestMapping(value = "/queryTolalInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryTolalInfo(@RequestBody QueryParam param) {

        /**
         * 处理今年或去年
         */
        Calendar date = Calendar.getInstance();
        Integer integer = Integer.valueOf(date.get(Calendar.YEAR));//本年
        String yearFlag = String.valueOf(param.getParams().get("yearFlag").getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
            integer = Integer.valueOf(date.get(Calendar.YEAR)) - 1;//上一年
        }
        String yearStart = integer+"-01-01 00:00:00";
        String yearEnd = integer+"-12-31 23:59:59";

        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(param.getParams().get("createTime").getValue()).split(",");
            yearStart = createTimes[0]+" 00:00:00";
            yearEnd = createTimes[1]+" 23:59:59";
        }


        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = format.parse(yearStart);
            end = format.parse(yearEnd);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        Long orgId = null;
        if (null != param.getParams().get("orgId") ) {
            orgId = Long.parseLong(String.valueOf(param.getParams().get("orgId").getValue()));//
        }
        Long deptId = null;
        if (null != param.getParams().get("deptId") ) {
            deptId = Long.parseLong(String.valueOf(param.getParams().get("deptId").getValue()));//
        }

        List<TaskinstVO> vo = service.queryTolalInfo(orgId,deptId,start,end);



        JSONObject res = new JSONObject();
        if (vo != null && vo.size()>0){
            String avgTimeTotal = String.format("%.2f",vo.get(0).getAvgTime() / (1000 * 60 * 60));
            String sumTimeTotal  = String.format("%.2f",vo.get(0).getSumTime() / (1000 * 60 * 60));
            res.put("sumTimeTotal",sumTimeTotal);
            res.put("countTotal",vo.get(0).getCount());
            res.put("avgTimeTotal",avgTimeTotal);
        }else {
            res.put("sumTimeTotal",0);
            res.put("countTotal",0);
            res.put("avgTimeTotal",0);
        }
        //List<TaskinstVO> vo = BeanMapper.mapList(entity, TaskinstVO.class);
        return CommonResponse.success("查询详情数据成功！",res);
    }



    /**
     * @Description 单据维度
     * @param
     */
    @RequestMapping(value = "/queryYearBill", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryYearBill(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billName");
        /**
         * 处理今年或去年
         */
        Calendar date = Calendar.getInstance();
        Integer integer = Integer.valueOf(date.get(Calendar.YEAR));//本年
        String yearFlag = String.valueOf(param.getParams().get("yearFlag").getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
            integer = Integer.valueOf(date.get(Calendar.YEAR)) - 1;//上一年
        }
        String yearStart = integer+"-01-01 00:00:00";
        String yearEnd = integer+"-12-31 23:59:59";

        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(param.getParams().get("createTime").getValue()).split(",");
            yearStart = createTimes[0]+" 00:00:00";
            yearEnd = createTimes[1]+" 23:59:59";
        }

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = format.parse(yearStart);
            end = format.parse(yearEnd);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        //获取当前用户的id
        UserContext userContextCache =sessionManager.getUserContext();

        //排序
        String timeSort = null;
        if (null != param.getOrderMap().get("timeSort") ) {
            timeSort = param.getOrderMap().get("timeSort");
        }
        String count = null;
        if (null != param.getOrderMap().get("count") ) {
            count = param.getOrderMap().get("count");
        }
        String sumTime = null;
        if (null != param.getOrderMap().get("sumTime") ) {
            sumTime = param.getOrderMap().get("sumTime");
        }
        String orgCode = null;
        if (null != param.getOrderMap().get("orgCode") ) {
            orgCode = param.getOrderMap().get("orgCode");
        }

        //模糊搜索
        String searchText = param.getSearchText();
        if (searchText != null){
            searchText = "'%"+searchText+"%'";
        }


        String stateFlag = null;
        if (null != param.getParams().get("stateFlag") ) {
            stateFlag = String.valueOf(param.getParams().get("stateFlag").getValue());//流程类型
        }
        //自定义查询，拼接查询语句
        Page<TaskinstVO> page = new Page<>(param.getPageIndex(), param.getPageSize());

        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        List<Long> collect = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());

        List<TaskinstVO> vo = service.queryYearBill(page,"",start,end,timeSort,stateFlag,collect,searchText);
        vo.stream().forEach(taskinstVO -> {
            if (taskinstVO.getAvgTime() != null) {
                taskinstVO.setAvgTime(taskinstVO.getAvgTime() / (1000 * 60 * 60));
            }else {
                taskinstVO.setAvgTime(0.00);
            }
        });



        IPage<TaskinstVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);

        //List<TaskinstVO> vo = BeanMapper.mapList(entity, TaskinstVO.class);
        return CommonResponse.success("查询详情数据成功！",pageData);
    }


    /**
     * @Description 单据维度穿透->所有单据
     * @param
     */
    @RequestMapping(value = "/queryYearBillDetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryYearBillDetail(@RequestBody QueryParam param) {

        /**
         * 处理今年或去年
         */
        Calendar date = Calendar.getInstance();
        Integer integer = Integer.valueOf(date.get(Calendar.YEAR));//本年
        String yearFlag = String.valueOf(param.getParams().get("yearFlag").getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
            integer = Integer.valueOf(date.get(Calendar.YEAR)) - 1;//上一年
        }
        String yearStart = integer+"-01-01 00:00:00";
        String yearEnd = integer+"-12-31 23:59:59";

        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(param.getParams().get("createTime").getValue()).split(",");
            yearStart = createTimes[0]+" 00:00:00";
            yearEnd = createTimes[1]+" 23:59:59";
        }

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = format.parse(yearStart);
            end = format.parse(yearEnd);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        String timeSort =null;
        if (null != param.getOrderMap().get("timeSort") ) {
            timeSort = param.getOrderMap().get("timeSort");
        }


        String billType = null;
        if (null != param.getParams().get("billType") ) {
            billType = String.valueOf(param.getParams().get("billType").getValue());//流程类型
        }
        //自定义查询，拼接查询语句
        Page<TaskinstVO> page = new Page<>(param.getPageIndex(), param.getPageSize());


        List<TaskinstVO> vo = service.queryYearBillDetail(page,"",start,end,timeSort,billType);
        vo.stream().forEach(taskinstVO -> {
            if (taskinstVO.getDurationTime() != null) {
                taskinstVO.setDurationTime(taskinstVO.getDurationTime() / (1000 * 60 * 60));
            }else {
                taskinstVO.setDurationTime(0.00);
            }
//            if (taskinstVO.getSumTime() != null) {
//                taskinstVO.setSumTime(taskinstVO.getSumTime() / (1000 * 60 * 60));
//            }else {
//                taskinstVO.setSumTime(0.00);
//            }
        });



        IPage<TaskinstVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);

        //List<TaskinstVO> vo = BeanMapper.mapList(entity, TaskinstVO.class);
        return CommonResponse.success("查询详情数据成功！",pageData);
    }
    /**
     * @Description 单据维度穿透->单据的审批人
     * @param
     */
    @RequestMapping(value = "/queryYearBillUserDetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryYearBillUserDetail(@RequestBody QueryParam param) {

        /**
         * 处理今年或去年
         */
        Calendar date = Calendar.getInstance();
        Integer integer = Integer.valueOf(date.get(Calendar.YEAR));//本年
        String yearFlag = String.valueOf(param.getParams().get("yearFlag").getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
            integer = Integer.valueOf(date.get(Calendar.YEAR)) - 1;//上一年
        }
        String yearStart = integer+"-01-01 00:00:00";
        String yearEnd = integer+"-12-31 23:59:59";

        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(param.getParams().get("createTime").getValue()).split(",");
            yearStart = createTimes[0]+" 00:00:00";
            yearEnd = createTimes[1]+" 23:59:59";
        }

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = format.parse(yearStart);
            end = format.parse(yearEnd);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        String timeSort =null;
        if (null != param.getOrderMap().get("timeSort") ) {
            timeSort = param.getOrderMap().get("timeSort");
        }


        String billType = null;
        if (null != param.getParams().get("billType") ) {
            billType = String.valueOf(param.getParams().get("billType").getValue());//流程类型
        }
        //自定义查询，拼接查询语句
        Page<TaskinstVO> page = new Page<>(param.getPageIndex(), param.getPageSize());


        List<TaskinstVO> vo = service.queryYearBillUserDetail(page,"",start,end,timeSort,billType);
        vo.stream().forEach(taskinstVO -> {
            if (taskinstVO.getAvgTime() != null) {
                taskinstVO.setAvgTime(taskinstVO.getAvgTime() / (1000 * 60 * 60));
            }else {
                taskinstVO.setAvgTime(0.00);
            }
            if (taskinstVO.getSumTime() != null) {
                taskinstVO.setSumTime(taskinstVO.getSumTime() / (1000 * 60 * 60));
            }else {
                taskinstVO.setSumTime(0.00);
            }
        });



        IPage<TaskinstVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);

        //List<TaskinstVO> vo = BeanMapper.mapList(entity, TaskinstVO.class);
        return CommonResponse.success("查询详情数据成功！",pageData);
    }
    /**
     * @Description 年度组织绩效
     * @param
     */
    @RequestMapping(value = "/queryYearOrgLimit5", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryYearOrgLimit5(@RequestBody QueryParam param) {

        /**
         * 处理今年或去年
         */
        Calendar date = Calendar.getInstance();
        Integer integer = Integer.valueOf(date.get(Calendar.YEAR));//本年
        String yearFlag = String.valueOf(param.getParams().get("yearFlag").getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
            integer = Integer.valueOf(date.get(Calendar.YEAR)) - 1;//上一年
        }
        String yearStart = integer+"-01-01 00:00:00";
        String yearEnd = integer+"-12-31 23:59:59";

        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(param.getParams().get("createTime").getValue()).split(",");
            yearStart = createTimes[0]+" 00:00:00";
            yearEnd = createTimes[1]+" 23:59:59";
        }

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = format.parse(yearStart);
            end = format.parse(yearEnd);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        String timeSort =null;
        if (null != param.getOrderMap().get("timeSort") ) {
            timeSort = param.getOrderMap().get("timeSort");
        }
        //自定义查询，拼接查询语句
        Page<TaskinstVO> page = new Page<>(param.getPageIndex(), param.getPageSize());

        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        List<Long> collect = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());

        List<TaskinstVO> vo = service.queryYearOrgLimit5(page,collect,start,end,timeSort);





        vo.stream().forEach(taskinstVO -> {
            taskinstVO.setAvgTime(taskinstVO.getAvgTime()/(1000*60*60));
            taskinstVO.setSumTime(taskinstVO.getSumTime()/(1000*60*60));
        });
        IPage<TaskinstVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);

        //List<TaskinstVO> vo = BeanMapper.mapList(entity, TaskinstVO.class);
        return CommonResponse.success("查询详情数据成功！",pageData);
    }



    /**
     * @Description 年度个人绩效
     * @param
     */
    @RequestMapping(value = "/queryYearUserInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<UserInfoVO>> queryYearUserInfo(@RequestBody QueryParam param) {

        /**
         * 处理今年或去年
         */
        Calendar date = Calendar.getInstance();
        Integer integer = Integer.valueOf(date.get(Calendar.YEAR));//本年
        String yearFlag = String.valueOf(param.getParams().get("yearFlag").getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
            integer = Integer.valueOf(date.get(Calendar.YEAR)) - 1;//上一年
        }
        String yearStart = integer+"-01-01 00:00:00";
        String yearEnd = integer+"-12-31 23:59:59";


        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(param.getParams().get("createTime").getValue()).split(",");
            yearStart = createTimes[0]+" 00:00:00";
            yearEnd = createTimes[1]+" 23:59:59";
        }

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = format.parse(yearStart);
            end = format.parse(yearEnd);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        String timeSort = "desc";
        if (null != param.getOrderMap().get("timeSort") ) {
            timeSort = param.getOrderMap().get("timeSort");
        }

        //获取当前用户的id
        UserContext userContextCache =sessionManager.getUserContext();
        Long userId = userContextCache.getUserId();

        Long orgId = null;
        if (null != param.getParams().get("orgId") ) {
            orgId = Long.parseLong(String.valueOf(param.getParams().get("orgId").getValue()));//
            userId = null;//存在orgId表示从组织列表跳转，则需要显示所有的用户
        }
        Long deptId = null;
        if (null != param.getParams().get("deptId") ) {
            deptId = Long.parseLong(String.valueOf(param.getParams().get("deptId").getValue()));//
        }


        //deptId为经营管理层可以查看全部
        //为某一个部门的，可以查看本部门的
        if (null != param.getParams().get("isAllFlag")) {
            //orgId = userContextCache.getOrgId();
            Long deptId1 = userContextCache.getDeptId();
            logger.info("orgId:{},deptId1:{}",orgId,deptId1);
            if (deptId1 != null) {
                if (deptId1 == 1502571152969568257L) {
                    userId = null;
                } else {
                    deptId = deptId1;
                    userId = null;
                }
            }
        }

        //自定义查询，拼接查询语句
        Page<TaskinstVO> page = new Page<>(param.getPageIndex(), param.getPageSize());


        List<TaskinstVO> vo = service.queryLastYearUser(page,userId,orgId,deptId,start,end,timeSort,
                null,null,null,null);

        vo.stream().forEach(taskinstVO -> {
            taskinstVO.setAvgTime(taskinstVO.getAvgTime()/(1000*60*60));
            taskinstVO.setSumTime(taskinstVO.getSumTime()/(1000*60*60));
        });

        ArrayList<UserInfoVO> userInfoVOS = new ArrayList<>();
        TaskinstVO taskinstVO = vo.get(0);
        UserInfoVO userInfoVO = new UserInfoVO();

        UserInfoVO userInfoVO4 = new UserInfoVO();
        userInfoVO4.setNum(taskinstVO.getCompleted());
        userInfoVO4.setMaterialCategoryName("完成");
        userInfoVO4.setAmount(taskinstVO.getCompleted());
        userInfoVO4.setWeight(String.format("%.2f",(double)taskinstVO.getCompleted()/taskinstVO.getCount()*100));
        userInfoVO4.setMaterialUnitName("个");
        userInfoVO4.setUserId(userId);
        userInfoVOS.add(userInfoVO4);

        userInfoVO.setNum(taskinstVO.getCallback());
        userInfoVO.setMaterialCategoryName("召回");
        userInfoVO.setAmount(taskinstVO.getCallback());
        userInfoVO.setWeight(String.format("%.2f",(double)taskinstVO.getCallback()/taskinstVO.getCount()*100));
        userInfoVO.setMaterialUnitName("个");
        userInfoVO.setUserId(userId);
        userInfoVOS.add(userInfoVO);

        UserInfoVO userInfoVO1 = new UserInfoVO();
        userInfoVO1.setNum(taskinstVO.getReject());
        userInfoVO1.setMaterialCategoryName("驳回");
        userInfoVO1.setAmount(taskinstVO.getReject());
        userInfoVO1.setWeight(String.format("%.2f",(double)taskinstVO.getReject()/taskinstVO.getCount()*100));
        userInfoVO1.setMaterialUnitName("个");
        userInfoVO1.setUserId(userId);
        userInfoVOS.add(userInfoVO1);

        UserInfoVO userInfoVO2 = new UserInfoVO();
        userInfoVO2.setNum(taskinstVO.getSuspend());
        userInfoVO2.setMaterialCategoryName("驳回不中止");
        userInfoVO2.setAmount(taskinstVO.getSuspend());
        userInfoVO2.setWeight(String.format("%.2f",(double)taskinstVO.getSuspend()/taskinstVO.getCount()*100));
        userInfoVO2.setMaterialUnitName("个");
        userInfoVO2.setUserId(userId);
        userInfoVOS.add(userInfoVO2);

        UserInfoVO userInfoVO3 = new UserInfoVO();
        userInfoVO3.setNum(taskinstVO.getTotalStop());
        userInfoVO3.setMaterialCategoryName("终止");
        userInfoVO3.setAmount(taskinstVO.getTotalStop());
        userInfoVO3.setWeight(String.format("%.2f",(double)taskinstVO.getTotalStop()/taskinstVO.getCount()*100));
        userInfoVO3.setMaterialUnitName("个");
        userInfoVO3.setUserId(userId);
        userInfoVOS.add(userInfoVO3);



        UserInfoVO userInfoVO5 = new UserInfoVO();
        userInfoVO5.setNum(taskinstVO.getWithdraw());
        userInfoVO5.setMaterialCategoryName("弃审");
        userInfoVO5.setAmount(taskinstVO.getWithdraw());
        userInfoVO5.setWeight(String.format("%.2f",(double)taskinstVO.getWithdraw()/taskinstVO.getCount()*100));
        userInfoVO5.setMaterialUnitName("个");
        userInfoVO5.setUserId(userId);
        userInfoVOS.add(userInfoVO5);


        //String avgTimeTotal = String.format("%.2f",vo.get(0).getAvgTime() / (1000 * 60 * 60));
        //List<TaskinstVO> vo = BeanMapper.mapList(entity, TaskinstVO.class);
        return CommonResponse.success("查询详情数据成功！",userInfoVOS);
    }




    /**
     * @Description 超时人员列表
     * @param
     */
    @RequestMapping(value = "/queryTimeOut", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryTimeOut(@RequestBody QueryParam param) {



        //自定义查询，拼接查询语句
        Page<TaskinstVO> page = new Page<>(param.getPageIndex(), param.getPageSize());


        //获取当前用户的id
        UserContext userContextCache =sessionManager.getUserContext();
        Long userId = userContextCache.getUserId();

        Long orgId = userContextCache.getOrgId();
        if (null != param.getParams().get("orgId") ) {
            orgId = Long.parseLong(String.valueOf(param.getParams().get("orgId").getValue()));//
        }

        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        List<Long> collect = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());


        List<TaskinstVO> vo = service.queryTimeOut(page,userId,null,null,"",collect);


        IPage<TaskinstVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);

        //List<TaskinstVO> vo = BeanMapper.mapList(entity, TaskinstVO.class);
        return CommonResponse.success("查询详情数据成功！",pageData);
    }
    /**
     * @Description 超时单据列表
     * @param
     */
    @RequestMapping(value = "/queryTimeOutDetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryTimeOutDetail(@RequestBody QueryParam param) {

        //自定义查询，拼接查询语句
        Page<TaskinstVO> page = new Page<>(param.getPageIndex(), param.getPageSize());

        //获取当前用户的id
        UserContext userContextCache =sessionManager.getUserContext();
        Long userId = userContextCache.getUserId();

        if (null != param.getParams().get("userId") ) {
            userId = Long.parseLong(String.valueOf(param.getParams().get("userId").getValue()));//
        }

        List<TaskinstVO> vo = service.queryTimeOutDetail(page,userId);


        IPage<TaskinstVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);

        //List<TaskinstVO> vo = BeanMapper.mapList(entity, TaskinstVO.class);
        return CommonResponse.success("查询详情数据成功！",pageData);
    }



    /**
     * @Description 年度组织绩效
     * @param
     */
    @RequestMapping(value = "/queryRejectException", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TaskinstVO>> queryRejectException(@RequestBody QueryParam param) {

        /**
         * 处理今年或去年
         */
        Calendar date = Calendar.getInstance();
        Integer integer = Integer.valueOf(date.get(Calendar.YEAR));//本年
        String yearFlag = String.valueOf(param.getParams().get("yearFlag").getValue());
        if (null != param.getParams().get("yearFlag") && "last".equals(yearFlag)) {
            integer = Integer.valueOf(date.get(Calendar.YEAR)) - 1;//上一年
        }
        String yearStart = integer+"-01-01 00:00:00";
        String yearEnd = integer+"-12-31 23:59:59";

        if (null != param.getParams().get("createTime")) {
            String[] createTimes = String.valueOf(param.getParams().get("createTime").getValue()).split(",");
            yearStart = createTimes[0]+" 00:00:00";
            yearEnd = createTimes[1]+" 23:59:59";
        }

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Date end = new Date();
        try {
            start = format.parse(yearStart);
            end = format.parse(yearEnd);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        //自定义查询，拼接查询语句
        Page<TaskinstVO> page = new Page<>(param.getPageIndex(), param.getPageSize());


        //获取当前用户的id
        UserContext userContextCache =sessionManager.getUserContext();
        Long userId = userContextCache.getUserId();

        List<TaskinstVO> vo = service.queryRejectException(page,userId,start,end,"");


        IPage<TaskinstVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(vo);

        //List<TaskinstVO> vo = BeanMapper.mapList(entity, TaskinstVO.class);
        return CommonResponse.success("查询详情数据成功！",pageData);
    }



    /**
     * @Description 审批平均时长变化
     * @param
     */
    @RequestMapping(value = "/queryYearOrgList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<UserInfoVO> queryYearOrgList(@RequestBody QueryParam param) {
        List<Long> lastMonthStartTime = getLastMonthStartTime();
        List<Long> lastMonthEndTime = getLastMonthEndTime();

        DateTimeFormatter ftf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        DateTimeFormatter ftf1 = DateTimeFormatter.ofPattern("MM-dd");

        ArrayList<String> strings = new ArrayList<>();
        ArrayList<Double> doubles = new ArrayList<>();
        for (int i = lastMonthStartTime.size()-1; i >= 0 ; i--) {

            String startTimeStr = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(lastMonthStartTime.get(i)), ZoneId.systemDefault()));
            String endTimeStr = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(lastMonthEndTime.get(i)), ZoneId.systemDefault()));
            String startTimeStr1 = ftf1.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(lastMonthStartTime.get(i)), ZoneId.systemDefault()));
            String endTimeStr1 = ftf1.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(lastMonthEndTime.get(i)), ZoneId.systemDefault()));

            strings.add(startTimeStr1+"-"+endTimeStr1);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date start = new Date();
            Date end = new Date();
            try {
                start = format.parse(startTimeStr);
                end = format.parse(endTimeStr);
            } catch (ParseException e) {
                e.printStackTrace();
            }

            String timeSort = "desc";
            if (null != param.getOrderMap().get("timeSort") ) {
                timeSort = param.getOrderMap().get("timeSort");
            }

            //自定义查询，拼接查询语句
            Page<TaskinstVO> page = new Page<>(param.getPageIndex(), param.getPageSize());

            List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            List<Long> collect = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
            List<TaskinstVO> vo = service.queryYearOrgList(page,collect,start,end,timeSort,null);
            doubles.add(vo.get(0).getAvgTime());

        }
        String[] array = new String[strings.size()];

        //使用for循环得到数组
        for(int i = 0; i < strings.size();i++){
            array[i] = strings.get(i);
        }
        Double[] array1 = new Double[doubles.size()];

        //使用for循环得到数组
        for(int i = 0; i < doubles.size();i++){
            array1[i] = doubles.get(i);
        }

        UserInfoVO userInfoVO = new UserInfoVO();
        userInfoVO.setStrings1(array);
        userInfoVO.setDoubles1(array1);
        return  CommonResponse.success("查询详情数据成功！",userInfoVO);
    }



    /**
     * @Description 年度个人绩效（门户专用）
     * @param
     */
    @RequestMapping(value = "/queryYearUserDesktop", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TaskinstVO> queryYearUserDesktop() {
        //获取当前用户的id
        UserContext userContextCache =sessionManager.getUserContext();
        Long userId = userContextCache.getUserId();

        TaskinstVO taskinstVO = mapper.queryYearUserDesktop(userId);
        return CommonResponse.success("查询详情数据成功！",taskinstVO);
    }



    public static List<Long> getLastMonthStartTime()  {
        Long currentTime = System.currentTimeMillis();

        String timeZone = "GMT+8:00";
        Calendar calendar = Calendar.getInstance();// 获取当前日期
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        calendar.setTimeInMillis(currentTime);
        calendar.add(Calendar.YEAR, 0);
        calendar.add(Calendar.MONTH, 0);
        calendar.set(Calendar.DAY_OF_MONTH, 1);// 设置为1号,当前日期既为本月第一天
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);

        ArrayList<Long> longs = new ArrayList<>();
        longs.add( calendar.getTimeInMillis());
        calendar.add(Calendar.MONTH, -1);
        longs.add( calendar.getTimeInMillis());
        calendar.add(Calendar.MONTH, -1);
        longs.add( calendar.getTimeInMillis());
        calendar.add(Calendar.MONTH, -1);
        longs.add( calendar.getTimeInMillis());
        calendar.add(Calendar.MONTH, -1);
        longs.add( calendar.getTimeInMillis());
        calendar.add(Calendar.MONTH, -1);
        longs.add( calendar.getTimeInMillis());;
        return longs;
    }


    public static List<Long> getLastMonthEndTime() {
        Long currentTime = System.currentTimeMillis();

        String timeZone = "GMT+8:00";
        Calendar calendar = Calendar.getInstance();// 获取当前日期
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        calendar.setTimeInMillis(currentTime);
        calendar.add(Calendar.YEAR, 0);
        calendar.add(Calendar.MONTH, 0);
        calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DAY_OF_MONTH));// 获取当前月最后一天
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        calendar.set(Calendar.MILLISECOND, 999);

        ArrayList<Long> longs = new ArrayList<>();
        longs.add( calendar.getTimeInMillis());
        calendar.add(Calendar.MONTH, -1);
        longs.add( calendar.getTimeInMillis());
        calendar.add(Calendar.MONTH, -1);
        longs.add( calendar.getTimeInMillis());
        calendar.add(Calendar.MONTH, -1);
        longs.add( calendar.getTimeInMillis());
        calendar.add(Calendar.MONTH, -1);
        longs.add( calendar.getTimeInMillis());
        calendar.add(Calendar.MONTH, -1);
        longs.add( calendar.getTimeInMillis());;

        return longs;
    }




    /**
     * @Description 年度个人绩效（门户专用）
     * @param
     */
    @RequestMapping(value = "/queryBpmdtailByBillcode", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BpmVariableVO> queryBpmdtailByBillcode(@RequestParam Long billcode) {
        BpmVariableVO taskinstVO = mapper.queryBpmdtailByBillcode(billcode);
        return CommonResponse.success("查询详情数据成功！",taskinstVO);
    }
    /**
     * @Description 物资门户-项目流程驳回次数
     * @param
     */
    @RequestMapping(value = "/queryBpmNumByProjetId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Integer> queryBpmNumByProjetId(@RequestParam Long projectId) {
        CommonResponse<List<Long>> listCommonResponse = contractApi.queryContractByProjectId(projectId);
        if(!listCommonResponse.isSuccess()){
            return CommonResponse.error("查询失败！");
        }
        List<Long> list = listCommonResponse.getData();
        if (CollectionUtils.isNotEmpty(list)) {
            Integer i = mapper.queryBpmNumByProjetId(list);
            return CommonResponse.success("查询详情数据成功！",i);
        }else {
            return CommonResponse.success("查询详情数据成功！",0);
        }

    }


}
