package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.ProjoverviewEntity;
import com.ejianc.business.busniessplan.service.IProjoverviewService;
import com.ejianc.business.change.bean.ChangeProjoverviewEntity;
import com.ejianc.business.change.service.IChangeProjoverviewService;
import com.ejianc.business.record.bean.RecordProjoverviewEntity;
import com.ejianc.business.record.service.IRecordProjoverviewService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("changeProjoverview") 
public class ChangeProjoverviewBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	//业务类型
	private static final String Projoverview = "zjkj-projoverview";//工程概述
	private static final String Projoverview_CHANGE = "zjkj-projoverviewChange";//工程概述变更
	private static final String Projoverview_RECORD = "zjkj-projoverviewRecord";//工程概述变更记录

	//单据类型
	private static final String Projoverview_BILLTYPE_CODE = "BT202202000009";//工程概述
	private static final String Projoverview_CHANGE_BILLTYPE_CODE = "BT202202000050";//工程概述变更
	private static final String Projoverview_RECORD_BILLTYPE_CODE = "BT202202000051";//工程概述变更记录

	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangeProjoverviewService changeProjoverviewService;
	@Autowired
	private IProjoverviewService projoverviewService;
	@Autowired
	private IRecordProjoverviewService recordProjoverviewService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//TODO
		//1、获取目前单据信息、变更信息
		ChangeProjoverviewEntity changeEntity = changeProjoverviewService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getOriginalId());
		ProjoverviewEntity projoverviewEntity = projoverviewService.selectById(changeEntity.getOriginalId());
		logger.info("主单据id=" + changeEntity.getId() + "主单据创建人" + changeEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecordProjoverviewEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("quotaanalysis_id", projoverviewEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordProjoverviewService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordProjoverviewEntity recordProjoverviewEntity = BeanMapper.map(projoverviewEntity, RecordProjoverviewEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordProjoverviewEntity);
		recordProjoverviewEntity.setBillState(null);
		recordProjoverviewEntity.setOriginalId(projoverviewEntity.getId());
		recordProjoverviewEntity.setProjoverviewCode(projoverviewEntity.getBillCode()+"-"+(count+1));
		recordProjoverviewEntity.setId(recordId);
		recordProjoverviewEntity.setBillCode(projoverviewEntity.getBillCode());
		recordProjoverviewEntity.setChangeReason(changeEntity.getChangeReason());
		recordProjoverviewEntity.setEffectDate(changeEntity.getEffectDate());

		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		sourceBillType = Projoverview_BILLTYPE_CODE;
		String targetBillType = "";
		targetBillType = Projoverview_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(projoverviewEntity.getId().toString(), sourceBillType, Projoverview , recordId.toString(), targetBillType, Projoverview_RECORD);
		recordProjoverviewService.saveOrUpdate(recordProjoverviewEntity, false);

		//3、修改当前单据状态
		ProjoverviewEntity newQuotaanalysisEntity = BeanMapper.map(changeEntity, ProjoverviewEntity.class);
		newQuotaanalysisEntity.setChangeState("3");//状态改为已变更
		newQuotaanalysisEntity.setChangeId(null);
		newQuotaanalysisEntity.setBillState(projoverviewEntity.getBillState());
		newQuotaanalysisEntity.setId(projoverviewEntity.getId());
		newQuotaanalysisEntity.setCreateTime(projoverviewEntity.getCreateTime());
		newQuotaanalysisEntity.setCreateUserCode(projoverviewEntity.getCreateUserCode());
		newQuotaanalysisEntity.setTenantId(projoverviewEntity.getTenantId());
		newQuotaanalysisEntity.setVersion(projoverviewEntity.getVersion());

		projoverviewService.saveOrUpdate(newQuotaanalysisEntity, false);

		sourceBillType = Projoverview_CHANGE_BILLTYPE_CODE;
		targetBillType = Projoverview_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Projoverview_CHANGE, projoverviewEntity.getId().toString(), targetBillType, Projoverview);
		recordProjoverviewService.saveOrUpdate(recordProjoverviewEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
