package com.ejianc.business.busniessplan.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.MaintargetEntity;
import com.ejianc.business.busniessplan.vo.PlanprojectdetailVO;
import com.ejianc.business.busniessplan.vo.PlanprojectVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.business.record.bean.RecordPlanprojectEntity;
import com.ejianc.business.record.service.IRecordPlanprojectService;
import com.ejianc.business.record.vo.RecordPlanprojectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.busniessplan.bean.PlanprojectEntity;
import com.ejianc.business.busniessplan.service.IPlanprojectService;

/**
 * 项目商务策划立项
<<<<<<< HEAD
 *
 * @author generator
 *
=======
 * 
 * @author generator
 * 
>>>>>>> 1b81f3096cf965aa8c8281333778aa85fc7a5a3d
 */
@Controller
@RequestMapping("planproject")
public class PlanprojectController implements Serializable {
	private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "businessplan_planproject";//此处需要根据实际修改


    @Autowired
    private IPlanprojectService service;
    @Autowired
    private IRecordPlanprojectService recordPlanprojectService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanprojectVO> saveOrUpdate(@RequestBody PlanprojectVO saveorUpdateVO) {
    	PlanprojectEntity entity = BeanMapper.map(saveorUpdateVO, PlanprojectEntity.class);
        QueryWrapper<PlanprojectEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", entity.getProjectId());
        queryWrapper.eq("dr", "0");
        List<PlanprojectEntity> pro = service.list(queryWrapper);
        if( pro.size() > 0){
            throw new BusinessException("该项目已经创建一个项目商务策划立项，不允许重复创建!");
        }
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setChangeState("1");//未变更
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	PlanprojectVO vo = BeanMapper.map(entity, PlanprojectVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanprojectVO> queryDetail(Long id) {
    	PlanprojectEntity entity = service.selectById(id);
    	PlanprojectVO vo = BeanMapper.map(entity, PlanprojectVO.class);

        //构建树形结构
        List<PlanprojectdetailVO> planprojectdetailVO = vo.getPlanprojectdetailEntities();
        List<PlanprojectdetailVO> resPlanprojectdetailVO = createTreeData(planprojectdetailVO);
        vo.setPlanprojectdetailEntities(resPlanprojectdetailVO);

        //当前单据变更过则显示变更记录
        if(!"1".equals(vo.getChangeState())){
            QueryWrapper<RecordPlanprojectEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("planproject_id", vo.getId());
            List<RecordPlanprojectEntity> records = recordPlanprojectService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                vo.setRecordPlanprojectList(BeanMapper.mapList(records, RecordPlanprojectVO.class));
            }
        }

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanprojectVO> vos) {
        service.removeByIds(vos.stream().map(PlanprojectVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlanprojectVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<PlanprojectEntity> page = service.queryPage(param,false);
        IPage<PlanprojectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanprojectVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PlanprojectEntity> list = service.queryList(param);
        //时间转换
        List<PlanprojectVO> planprojectVOList = BeanMapper.mapList(list, PlanprojectVO.class);
        for (int i = 0; i < planprojectVOList.size(); i++) {
            PlanprojectVO planprojectVO = planprojectVOList.get(i);
            planprojectVO.setSort(String.valueOf(i+1));
            if (planprojectVO.getCreateTime()!=null){
                planprojectVO.setCreateTimeShow(DateUtils.dateSimple2(planprojectVO.getCreateTime()));
            }

            String billStateStr = planprojectVO.getBillState().toString();
            String changeState = planprojectVO.getChangeState();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                planprojectVO.setBillStateStr(billStateStr);
            }

            if (changeState != null){
                if("1".equals(changeState)){//1:未变更
                    changeState = "未变更";
                }else if("2".equals(changeState)){//2:变更中
                    changeState = "变更中";
                }else if("3".equals(changeState)){//3:已变更
                    changeState = "已变更";
                }

                planprojectVO.setChangeState(changeState);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", planprojectVOList);
        ExcelExport.getInstance().export("PlanprojectMain-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refPlanprojectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PlanprojectVO>> refPlanprojectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PlanprojectEntity> page = service.queryPage(param,false);
        IPage<PlanprojectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanprojectVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    public static List<PlanprojectdetailVO> createTreeData(List<PlanprojectdetailVO> list) {
        List<PlanprojectdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, PlanprojectdetailVO> listMap = new HashMap<>();
        for(PlanprojectdetailVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            PlanprojectdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            PlanprojectdetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<PlanprojectdetailVO> child = (List<PlanprojectdetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<PlanprojectdetailVO> children = new ArrayList<PlanprojectdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetailList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanprojectVO> queryDetailList(@RequestBody String porjectId) {
        QueryWrapper<PlanprojectEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("id", "552114909467398229");
        queryWrapper.eq("project_id", porjectId);
        List<PlanprojectEntity> records = service.list(queryWrapper);
        PlanprojectVO vo = new PlanprojectVO();
        for(PlanprojectEntity entity : records){
            PlanprojectEntity list = service.selectById(entity.getId());
            vo = BeanMapper.map(list, PlanprojectVO.class);
        }

        //构建树形结构
        List<PlanprojectdetailVO> planprojectdetailVO = vo.getPlanprojectdetailEntities();
        List<PlanprojectdetailVO> resPlanprojectdetailVO = createTreeData(planprojectdetailVO);
        vo.setPlanprojectdetailEntities(resPlanprojectdetailVO);

        return CommonResponse.success("查询详情数据成功！",vo);
    }

}
