package com.ejianc.business.busniessplan.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.PlanprojectdetailEntity;
import com.ejianc.business.busniessplan.service.IPlanprojectdetailService;
import com.ejianc.business.busniessplan.vo.PlanprojectVO;
import com.ejianc.business.busniessplan.vo.PlanprojectdetailVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 项目商务策划立项导入导出
 */
@Controller
@RequestMapping("planprojectExport")
public class ExcelPlanprojectController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPlanprojectdetailService planprojectdetailService;

    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadPlanproject")
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "planproject-import.xlsx", "项目商务策划立项清单导入模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportPlanproject", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<PlanprojectdetailVO> successList = new ArrayList<>();
        List<PlanprojectdetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=2;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    PlanprojectdetailVO planprojectdetailVO = new PlanprojectdetailVO();
                    planprojectdetailVO.setId(IdWorker.getId());//id
                    planprojectdetailVO.setSort(datas.get(0));//id
                    planprojectdetailVO.setCategoryAndName(StringUtils.isNotBlank(datas.get(1))?datas.get(1):null); // 类别及项目名称
                    planprojectdetailVO.setInitiateReason(StringUtils.isNotBlank(datas.get(2))?datas.get(2):null); // 立项理由及依据
                    planprojectdetailVO.setInitiateDate(StringUtils.isNotBlank(datas.get(3))? DateUtils.Date(datas.get(3)):null); // 立项时间
                    //System.out.println("时间打印："+datas.get(3));
                    planprojectdetailVO.setCostEstimate(StringUtils.isNotBlank(datas.get(4))?new BigDecimal(datas.get(4)):null); // 成本估算(成本分析)(元)
                    planprojectdetailVO.setReportAmount(StringUtils.isNotBlank(datas.get(5))?new BigDecimal(datas.get(5)):null); // 上报金额(元)
                    planprojectdetailVO.setTargetAmount(StringUtils.isNotBlank(datas.get(6))?new BigDecimal(datas.get(6)):null); // 策划目标金额(元)
                    planprojectdetailVO.setCompleteAmount(StringUtils.isNotBlank(datas.get(7))?new BigDecimal(datas.get(7)):null); // 已完成目标金额(元)
                    planprojectdetailVO.setEstimateProfits(StringUtils.isNotBlank(datas.get(8))?new BigDecimal(datas.get(8)):null); // 预计利润(元)
                    planprojectdetailVO.setProposedCompleteTime(StringUtils.isNotBlank(datas.get(9))?DateUtils.Date(datas.get(9)):null); // 拟完成时间节点
                    planprojectdetailVO.setCompleteTime(StringUtils.isNotBlank(datas.get(10))?DateUtils.Date(datas.get(10)):null); // 完成时间
                    planprojectdetailVO.setSupportingDetails(StringUtils.isNotBlank(datas.get(11))?datas.get(11):null); // 证明资料明细
                    planprojectdetailVO.setReportToThismonthProgress(StringUtils.isNotBlank(datas.get(12))?new BigDecimal(datas.get(12)):null); // 报公司截至本月进度(元)
                    planprojectdetailVO.setFirstResponsiblePerson(StringUtils.isNotBlank(datas.get(13))?datas.get(13):null); // 第一责任人
                    planprojectdetailVO.setMainResponsiblePerson(StringUtils.isNotBlank(datas.get(14))?datas.get(14):null); // 主要负责人
                    planprojectdetailVO.setFinalCompleteTime(StringUtils.isNotBlank(datas.get(15))?DateUtils.Date(datas.get(15)):null); // (最后)完成时间
                    planprojectdetailVO.setAttention(StringUtils.isNotBlank(datas.get(16))?datas.get(16):null); // 推荐情况、存在问题、注意事项
                    /*if(StringUtils.isEmpty(datas.get(0))) {
                        maintargetdetailVO.setErrorMsg("序号不能为空！");
                        errorList.add(maintargetdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(1))) {
                        maintargetdetailVO.setErrorMsg("名称不能为空！");
                        errorList.add(maintargetdetailVO);
                        continue;
                    }*/

                    successList.add(planprojectdetailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportPlanprojectFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportbusinessplanningeffectFromDatabase(@RequestBody PlanprojectVO planprojectVO, HttpServletResponse response) {
        QueryWrapper<PlanprojectdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", planprojectVO.getId());
        queryWrapper.eq("dr", 0);
        List<PlanprojectdetailEntity> list = planprojectdetailService.list(queryWrapper);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("planproject-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportPlanprojectFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportbusinessplanningeffectFromPage(@RequestBody List<PlanprojectdetailVO> list, HttpServletResponse response) {
        for (int i = 0; i < list.size(); i++) {
            PlanprojectdetailVO planprojectdetailVO = list.get(i);
            if (planprojectdetailVO.getCompleteTime()!=null){
                planprojectdetailVO.setCompleteTimeShow(DateUtils.dateSimple(planprojectdetailVO.getCompleteTime()));
            }
            if (planprojectdetailVO.getInitiateDate()!=null){
                planprojectdetailVO.setInitiateDateShow(DateUtils.dateSimple(planprojectdetailVO.getInitiateDate()));
            }
            if (planprojectdetailVO.getProposedCompleteTime()!=null){
                planprojectdetailVO.setProposedCompleteTimeShow(DateUtils.dateSimple(planprojectdetailVO.getProposedCompleteTime()));
            }
            if (planprojectdetailVO.getFinalCompleteTime()!=null){
                planprojectdetailVO.setFinalCompleteTimeShow(DateUtils.dateSimple(planprojectdetailVO.getFinalCompleteTime()));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("planproject-export.xlsx", beans, response);
    }

}
