package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.CountersignatureEntity;
import com.ejianc.business.busniessplan.service.ICountersignatureService;
import com.ejianc.business.change.bean.ChangecountersignatureEntity;
import com.ejianc.business.change.mapper.ChangecountersignatureMapper;
import com.ejianc.business.change.service.IChangecountersignatureService;
import com.ejianc.business.change.vo.ChangecountersignatureVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;


/**
 * 商务会签变更
 * 
 * @author generator
 * 
 */
@Service("changecountersignatureService")
public class ChangecountersignatureServiceImpl extends BaseServiceImpl<ChangecountersignatureMapper, ChangecountersignatureEntity> implements IChangecountersignatureService {

    @Autowired
    private ICountersignatureService countersignatureService;
    @Override
    public CommonResponse<ChangecountersignatureVO> saveChange(ChangecountersignatureVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangecountersignatureEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangecountersignatureEntity entity = BeanMapper.map(saveOrUpdateVO, ChangecountersignatureEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangecountersignatureEntity> queryWrapper = new QueryWrapper<ChangecountersignatureEntity>();
        queryWrapper.eq("countersignature_id", saveOrUpdateVO.getCountersignatureId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", "[0,4]");
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangecountersignatureEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //限额设计指标分析子表
        this.saveOrUpdate(entity, false);

        ChangecountersignatureVO vo = BeanMapper.map(entity, ChangecountersignatureVO.class);
        vo.setRecordcountersignatureList(saveOrUpdateVO.getRecordcountersignatureList());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            CountersignatureEntity countersignatureEntity = countersignatureService.selectById(vo.getCountersignatureId());
            countersignatureEntity.setChangeState("2");//状态改为变更中
            countersignatureEntity.setChangeId(vo.getId());
            countersignatureService.saveOrUpdate(countersignatureEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
}
