/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.busniessplan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.busniessplan.bean.CompanyReviewEntity;
import com.ejianc.business.busniessplan.service.ICompanyReviewService;
import com.ejianc.business.busniessplan.vo.CompanyReviewVO;
import com.ejianc.business.record.service.IRecordcompanyreviewService;
import com.ejianc.business.record.vo.RecordcompanyreviewVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"companyReview"})
public class CompanyReviewController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "busniessplan-companyreview";
    @Autowired
    private ICompanyReviewService service;
    @Autowired
    private IRecordcompanyreviewService recordcompanyreviewService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CompanyReviewVO> saveOrUpdate(@RequestBody CompanyReviewVO saveorUpdateVO) {
        CompanyReviewEntity entity = (CompanyReviewEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), CompanyReviewEntity.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
        queryWrapper.eq((Object)"dr ", (Object)"0");
        List pro = this.service.list((Wrapper)queryWrapper);
        if (entity.getId() == null || entity.getId() == 0L) {
            if (pro.size() > 0) {
                throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u7ecf\u521b\u5efa\u4e00\u4e2a\u516c\u53f8\u533a\u57df\u8bc4\u5ba1\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa!");
            }
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setChangeState("1");
            entity.setBillCode((String)billCode.getData());
        } else if (pro.size() > 0) {
            for (int i = 0; i < pro.size(); ++i) {
                if (entity.getId().equals(((CompanyReviewEntity)((Object)pro.get(i))).getId())) continue;
                throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u7ecf\u521b\u5efa\u4e00\u4e2a\u516c\u53f8\u533a\u57df\u8bc4\u5ba1\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa!");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        CompanyReviewVO vo = (CompanyReviewVO)((Object)BeanMapper.map((Object)((Object)entity), CompanyReviewVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CompanyReviewVO> queryDetail(Long id) {
        CompanyReviewEntity entity = (CompanyReviewEntity)((Object)this.service.selectById(id));
        CompanyReviewVO vo = (CompanyReviewVO)((Object)BeanMapper.map((Object)((Object)entity), CompanyReviewVO.class));
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"company_review_id", (Object)vo.getId());
            List records = this.recordcompanyreviewService.list((Wrapper)queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordcompanyreviewList(BeanMapper.mapList((Iterable)records, RecordcompanyreviewVO.class));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CompanyReviewVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CompanyReviewVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        fuzzyFields.add("project_name");
        fuzzyFields.add("bill_code");
        fuzzyFields.add("agent_name");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CompanyReviewVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List CompanyReviewVOList = BeanMapper.mapList((Iterable)list, CompanyReviewVO.class);
        for (int i = 0; i < CompanyReviewVOList.size(); ++i) {
            CompanyReviewVO CompanyReviewVO2 = (CompanyReviewVO)((Object)CompanyReviewVOList.get(i));
            CompanyReviewVO2.setSort(String.valueOf(i + 1));
            if (CompanyReviewVO2.getCreateTime() != null) {
                CompanyReviewVO2.setCreateTimeShow(DateUtils.dateSimple2(CompanyReviewVO2.getCreateTime()));
            }
            String billStateStr = CompanyReviewVO2.getBillState().toString();
            String changeState = CompanyReviewVO2.getChangeState();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {
                    billStateStr = "\u81ea\u7531\u6001";
                } else if ("1".equals(billStateStr)) {
                    billStateStr = "\u5df2\u63d0\u4ea4";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u4e2d";
                } else if ("3".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u901a\u8fc7";
                } else if ("4".equals(billStateStr)) {
                    billStateStr = "\u9a73\u56de";
                }
                CompanyReviewVO2.setBillStateStr(billStateStr);
            }
            if (changeState == null) continue;
            if ("1".equals(changeState)) {
                changeState = "\u672a\u53d8\u66f4";
            } else if ("2".equals(changeState)) {
                changeState = "\u53d8\u66f4\u4e2d";
            } else if ("3".equals(changeState)) {
                changeState = "\u5df2\u53d8\u66f4";
            }
            CompanyReviewVO2.setChangeState(changeState);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", CompanyReviewVOList);
        ExcelExport.getInstance().export("CompanyReviewMain-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCompanyReviewData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CompanyReviewVO>> refCompanyReviewData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CompanyReviewVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

