/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.busniessplan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.busniessplan.bean.SubpackageEntity;
import com.ejianc.business.busniessplan.service.ISubpackageService;
import com.ejianc.business.busniessplan.vo.SubpackageVO;
import com.ejianc.business.busniessplan.vo.SubpackagepackgedetailVO;
import com.ejianc.business.busniessplan.vo.SubpackagesupplydetailVO;
import com.ejianc.business.record.service.IRecordsubpackageService;
import com.ejianc.business.record.vo.RecordsubpackageVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"subpackage"})
public class SubpackageController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "businessplan_subpackage";
    @Autowired
    private ISubpackageService service;
    @Autowired
    private IRecordsubpackageService recordsubpackageService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubpackageVO> saveOrUpdate(@RequestBody SubpackageVO saveorUpdateVO) {
        SubpackageEntity entity = (SubpackageEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), SubpackageEntity.class));
        if (saveorUpdateVO.getId() == null || saveorUpdateVO.getId() == 0L) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
            queryWrapper.eq((Object)"dr", (Object)"0");
            queryWrapper.notIn((Object)"bill_state", new Object[]{1, 3});
            List pro = this.service.list((Wrapper)queryWrapper);
            if (pro.size() > 0) {
                throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u5b58\u5728\u4e00\u4e2a\u975e\u5ba1\u6279\u901a\u8fc7\u7684\u5206\u5305\u5206\u4f9b\u7ba1\u7406\u7b56\u5212\u5355\u636e!");
            }
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setChangeState("1");
            entity.setBillCode((String)billCode.getData());
            List<SubpackagepackgedetailVO> handleData = saveorUpdateVO.getSubpackagepackagedetailEntities();
            if (handleData != null) {
                for (int i = 0; i < handleData.size(); ++i) {
                    SubpackagepackgedetailVO subpackagepackgedetailVO = handleData.get(i);
                    subpackagepackgedetailVO.setId(null);
                    handleData.set(i, subpackagepackgedetailVO);
                }
                saveorUpdateVO.setSubpackagepackagedetailEntities(handleData);
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        SubpackageVO vo = (SubpackageVO)((Object)BeanMapper.map((Object)((Object)entity), SubpackageVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubpackageVO> queryDetail(Long id) {
        SubpackageEntity entity = (SubpackageEntity)((Object)this.service.selectById(id));
        SubpackageVO vo = (SubpackageVO)((Object)BeanMapper.map((Object)((Object)entity), SubpackageVO.class));
        List<SubpackagesupplydetailVO> subpackagesupplydetailVO = vo.getSubpackagesupplydetailEntities();
        List<SubpackagesupplydetailVO> resSubpackagesupplydetailVO = SubpackageController.createTreeData(subpackagesupplydetailVO);
        vo.setSubpackagesupplydetailEntities(resSubpackagesupplydetailVO);
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"subpackage_id", (Object)vo.getId());
            List records = this.recordsubpackageService.list((Wrapper)queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordsubpackageList(BeanMapper.mapList((Iterable)records, RecordsubpackageVO.class));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubpackageVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubpackageVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubpackageVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List subpackageVOList = BeanMapper.mapList((Iterable)list, SubpackageVO.class);
        for (int i = 0; i < subpackageVOList.size(); ++i) {
            SubpackageVO subpackageVO = (SubpackageVO)((Object)subpackageVOList.get(i));
            subpackageVO.setSort(String.valueOf(i + 1));
            if (subpackageVO.getCreateTime() != null) {
                subpackageVO.setCreateTimeShow(DateUtils.dateSimple2(subpackageVO.getCreateTime()));
            }
            String billStateStr = subpackageVO.getBillState().toString();
            String changeState = subpackageVO.getChangeState();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {
                    billStateStr = "\u81ea\u7531\u6001";
                } else if ("1".equals(billStateStr)) {
                    billStateStr = "\u5df2\u63d0\u4ea4";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u4e2d";
                } else if ("3".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u901a\u8fc7";
                } else if ("4".equals(billStateStr)) {
                    billStateStr = "\u9a73\u56de";
                }
                subpackageVO.setBillStateStr(billStateStr);
            }
            if (changeState == null) continue;
            if ("1".equals(changeState)) {
                changeState = "\u672a\u53d8\u66f4";
            } else if ("2".equals(changeState)) {
                changeState = "\u53d8\u66f4\u4e2d";
            } else if ("3".equals(changeState)) {
                changeState = "\u5df2\u53d8\u66f4";
            }
            subpackageVO.setChangeState(changeState);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", subpackageVOList);
        ExcelExport.getInstance().export("SubpackageMain-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSubpackageData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubpackageVO>> refSubpackageData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubpackageVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public static List<SubpackagesupplydetailVO> createTreeData(List<SubpackagesupplydetailVO> list) {
        ArrayList<SubpackagesupplydetailVO> resp = new ArrayList<SubpackagesupplydetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, SubpackagesupplydetailVO> listMap = new HashMap<String, SubpackagesupplydetailVO>();
        for (SubpackagesupplydetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            SubpackagesupplydetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            SubpackagesupplydetailVO parent = (SubpackagesupplydetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<SubpackagesupplydetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<SubpackagesupplydetailVO> children = new ArrayList<SubpackagesupplydetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((SubpackagesupplydetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }
}

