/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.busniessplan.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.MaintargetdetailEntity;
import com.ejianc.business.busniessplan.service.IMaintargetdetailService;
import com.ejianc.business.busniessplan.vo.MaintargetVO;
import com.ejianc.business.busniessplan.vo.MaintargetdetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"maintargetExport"})
public class ExcelMaintargetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaintargetdetailService maintargetdetailService;

    @RequestMapping(value={"/downloadMaintarget"})
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"maintarget-import.xlsx", (String)"\u5546\u52a1\u7b56\u5212\u4e66\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportMaintarget"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<MaintargetdetailVO> successList = new ArrayList<MaintargetdetailVO>();
        ArrayList errorList = new ArrayList();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        TreeSet<String> sortSet = new TreeSet<String>();
        if (result != null && result.size() > 0) {
            List datas;
            List repeat = null;
            for (int j = 0; j < result.size(); ++j) {
                datas = (List)result.get(j);
                QueryWrapper wrapper = new QueryWrapper();
                List maintargetdetailEntityList = this.maintargetdetailService.list((Wrapper)wrapper);
                for (MaintargetdetailEntity entity : maintargetdetailEntityList) {
                    if (((String)datas.get(0)).equals("\u5e8f\u53f7")) continue;
                    sortSet.add(entity.getSort());
                }
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(0))) || datas.get(0) == null) continue;
                repeat = sortSet.stream().filter(item -> item.equals(datas.get(0))).collect(Collectors.toList());
            }
            if (repeat.size() > 1) {
                throw new BusinessException("\u5b58\u5728\u975e\u6cd5\u5e8f\u53f7,\u8bf7\u68c0\u67e5\u5bfc\u5165\u6570\u636e");
            }
            for (int i = 1; i < result.size(); ++i) {
                datas = (List)result.get(i);
                MaintargetdetailVO maintargetdetailVO = new MaintargetdetailVO();
                maintargetdetailVO.setId(IdWorker.getId());
                maintargetdetailVO.setSort(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(0))) ? (String)datas.get(0) : null);
                maintargetdetailVO.setProjectName(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) ? (String)datas.get(1) : null);
                maintargetdetailVO.setTarget(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                maintargetdetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? (String)datas.get(3) : null);
                successList.add(maintargetdetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportMaintargetFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportbusinessplanningeffectFromDatabase(@RequestBody MaintargetVO maintargetVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)maintargetVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.maintargetdetailService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("maintarget-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportMaintargetFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportbusinessplanningeffectFromPage(@RequestBody List<MaintargetdetailVO> list, HttpServletResponse response) {
        HashMap<String, List<MaintargetdetailVO>> beans = new HashMap<String, List<MaintargetdetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("maintarget-export.xlsx", beans, response);
    }
}

