/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.busniessplan.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.service.ISubpackagesupplydetailService;
import com.ejianc.business.busniessplan.vo.SubpackageVO;
import com.ejianc.business.busniessplan.vo.SubpackagesupplydetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"subpackageExport"})
public class ExcelSubpackagesupplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISubpackagesupplydetailService subpackagesupplydetailService;

    @RequestMapping(value={"/downloadSubsupply"})
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"subsupply-import.xlsx", (String)"\u4f9b\u5e94\u5546\u7ba1\u7406\u7b56\u5212\u8868\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportSubsupply"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<SubpackagesupplydetailVO> successList = new ArrayList<SubpackagesupplydetailVO>();
        ArrayList<SubpackagesupplydetailVO> errorList = new ArrayList<SubpackagesupplydetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                SubpackagesupplydetailVO subpackagesupplydetailVO = new SubpackagesupplydetailVO();
                subpackagesupplydetailVO.setId(IdWorker.getId());
                subpackagesupplydetailVO.setSort((String)datas.get(0));
                subpackagesupplydetailVO.setManagerContent(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) ? (String)datas.get(1) : null);
                subpackagesupplydetailVO.setManagerAim(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                subpackagesupplydetailVO.setManagerMeasures(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? (String)datas.get(3) : null);
                subpackagesupplydetailVO.setPersonLiable(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? (String)datas.get(4) : null);
                subpackagesupplydetailVO.setPlanCompleteTime(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? (String)datas.get(5) : null);
                subpackagesupplydetailVO.setImplementationEffect(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? (String)datas.get(6) : null);
                if (datas.get(0) == null || StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    subpackagesupplydetailVO.setErrorMsg("\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(subpackagesupplydetailVO);
                    continue;
                }
                subpackagesupplydetailVO.setSort((String)datas.get(0));
                successList.add(subpackagesupplydetailVO);
            }
        }
        List<SubpackagesupplydetailVO> resList = this.setTidAndTpid(successList);
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    private List<SubpackagesupplydetailVO> setTidAndTpid(List<SubpackagesupplydetailVO> originalList) {
        ArrayList<SubpackagesupplydetailVO> treeList = new ArrayList<SubpackagesupplydetailVO>();
        String currentTime = String.valueOf(System.currentTimeMillis());
        if (originalList != null && originalList.size() > 0) {
            for (int i = 0; i < originalList.size(); ++i) {
                SubpackagesupplydetailVO subpackagesupplydetailVO = originalList.get(i);
                String sort = subpackagesupplydetailVO.getSort();
                String[] arr = sort.split("\\.");
                if (arr.length == 1) {
                    subpackagesupplydetailVO.setTid(currentTime + "_" + sort);
                    subpackagesupplydetailVO.setTpid("");
                    treeList.add(subpackagesupplydetailVO);
                    continue;
                }
                if (arr.length <= 1) continue;
                subpackagesupplydetailVO.setTid(currentTime + "_" + sort);
                subpackagesupplydetailVO.setTpid(currentTime + "_" + sort.substring(0, sort.length() - 2));
                treeList.add(subpackagesupplydetailVO);
            }
        }
        return ExcelSubpackagesupplyController.createTreeData(treeList);
    }

    public static List<SubpackagesupplydetailVO> createTreeData(List<SubpackagesupplydetailVO> list) {
        ArrayList<SubpackagesupplydetailVO> resp = new ArrayList<SubpackagesupplydetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, SubpackagesupplydetailVO> listMap = new HashMap<String, SubpackagesupplydetailVO>();
        for (SubpackagesupplydetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            SubpackagesupplydetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            SubpackagesupplydetailVO parent = (SubpackagesupplydetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<SubpackagesupplydetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<SubpackagesupplydetailVO> children = new ArrayList<SubpackagesupplydetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((SubpackagesupplydetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    @RequestMapping(value={"/excelExportSubsupplyFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportSubsupplyFromDatabase(@RequestBody SubpackageVO subpackageVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)subpackageVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.subpackagesupplydetailService.list((Wrapper)queryWrapper);
        List resList = BeanMapper.mapList((Iterable)list, SubpackagesupplydetailVO.class);
        HashMap<String, List<SubpackagesupplydetailVO>> beans = new HashMap<String, List<SubpackagesupplydetailVO>>();
        beans.put("records", this.handleSpecialField(resList));
        ExcelExport.getInstance().export("subsupply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportSubsupplyFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportSubsupplyFromPage(@RequestBody List<SubpackagesupplydetailVO> list, HttpServletResponse response) {
        ArrayList<SubpackagesupplydetailVO> concatList = new ArrayList<SubpackagesupplydetailVO>();
        for (int i = 0; i < list.size(); ++i) {
            SubpackagesupplydetailVO subpackagesupplydetailVO = list.get(i);
            concatList.add(subpackagesupplydetailVO);
        }
        List<SubpackagesupplydetailVO> allList = this.handleList(list, concatList);
        Collections.sort(allList, new Comparator<SubpackagesupplydetailVO>(){

            @Override
            public int compare(SubpackagesupplydetailVO o1, SubpackagesupplydetailVO o2) {
                return o1.getSort().compareTo(o2.getSort());
            }
        });
        HashMap<String, List<SubpackagesupplydetailVO>> beans = new HashMap<String, List<SubpackagesupplydetailVO>>();
        beans.put("records", this.handleSpecialField(allList));
        ExcelExport.getInstance().export("subsupply-export.xlsx", beans, response);
    }

    private List<SubpackagesupplydetailVO> handleSpecialField(List<SubpackagesupplydetailVO> allList) {
        for (int i = 0; i < allList.size(); ++i) {
            SubpackagesupplydetailVO subpackagesupplydetailVO = allList.get(i);
            if (subpackagesupplydetailVO.getPlanCompleteTime() == null) continue;
            subpackagesupplydetailVO.setPlanCompleteTimeShow(subpackagesupplydetailVO.getPlanCompleteTime());
        }
        return allList;
    }

    private List<SubpackagesupplydetailVO> handleList(List<SubpackagesupplydetailVO> list, List<SubpackagesupplydetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }
        for (int i = 0; i < list.size(); ++i) {
            SubpackagesupplydetailVO subpackagesupplydetailVO = list.get(i);
            List<SubpackagesupplydetailVO> children = subpackagesupplydetailVO.getChildren();
            if (children == null || children.size() <= 0) continue;
            concatList.addAll(children);
            this.handleList(children, concatList);
        }
        return concatList;
    }
}

