/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.busniessplan.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.service.IBusinessplanningeffectdetailService;
import com.ejianc.business.busniessplan.vo.BusinessplanningeffectVO;
import com.ejianc.business.busniessplan.vo.BusinessplanningeffectdetailVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"businessplanningeffectExport"})
public class ExcelBusinessplaneffectController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBusinessplanningeffectdetailService businessplanningeffectdetailService;
    @Autowired(required=false)
    private RestHighLevelClient client;

    @RequestMapping(value={"/downloadBusinessplanningeffect"})
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"businessplanningeffect-import.xlsx", (String)"\u9879\u76ee\u5546\u52a1\u7b56\u5212\u7acb\u9879\u6e05\u5355\u6a21\u677f");
    }

    private List<BusinessplanningeffectdetailVO> openList(List<BusinessplanningeffectdetailVO> list) {
        ArrayList<BusinessplanningeffectdetailVO> succesList = new ArrayList<BusinessplanningeffectdetailVO>();
        for (BusinessplanningeffectdetailVO vo : list) {
            if (CollectionUtils.isNotEmpty(vo.getChildren())) {
                succesList.addAll(this.openList(vo.getChildren()));
            }
            succesList.add(vo);
        }
        return succesList;
    }

    @RequestMapping(value={"/excelImportBusinessplanningeffect"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response, String detailList) throws ParseException {
        List list = JSONArray.parseArray((String)detailList, BusinessplanningeffectdetailVO.class);
        List<BusinessplanningeffectdetailVO> pcList = this.openList(list);
        ArrayList<String> pcStrList = new ArrayList<String>();
        for (BusinessplanningeffectdetailVO vo : pcList) {
            pcStrList.add(vo.getSort() + vo.getCategoryAndName());
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<BusinessplanningeffectdetailVO> successList = new ArrayList<BusinessplanningeffectdetailVO>();
        ArrayList<BusinessplanningeffectdetailVO> errorList = new ArrayList<BusinessplanningeffectdetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 3; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                if (pcStrList.contains((String)datas.get(0) + (String)datas.get(1))) {
                    // empty if block
                }
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String initiateDate = (String)datas.get(6);
                String incomeBeforePlan = (String)datas.get(7);
                String costBeforePlan = (String)datas.get(8);
                String benefitBeforePlan = (String)datas.get(9);
                String estimatedRevenueAfterPlan = (String)datas.get(10);
                String estimatedCostAfterPlan = (String)datas.get(11);
                String estimatedBenefitsAfterPlan = (String)datas.get(12);
                String planExpectAchieveResults = (String)datas.get(13);
                String proposedCompleteTime = (String)datas.get(14);
                String revenueAfterPlan = (String)datas.get(15);
                String actualCost = (String)datas.get(16);
                String benefitAfterPlan = (String)datas.get(17);
                String includePlannedActualEffect = (String)datas.get(18);
                String supervisionNotReportedMoney = (String)datas.get(20);
                String supervisionNotReportedTime = (String)datas.get(21);
                String supervisionReportedMoney = (String)datas.get(22);
                String supervisionReportedTime = (String)datas.get(23);
                String supervisionApprovedMoney = (String)datas.get(24);
                String supervisionApprovedTime = (String)datas.get(25);
                String ownerNotReportedMoney = (String)datas.get(26);
                String ownerNotReportedTime = (String)datas.get(27);
                String ownerReportedMoney = (String)datas.get(28);
                String ownerReportedTime = (String)datas.get(29);
                String ownerApprovedMoney = (String)datas.get(30);
                String ownerApprovedTime = (String)datas.get(31);
                BusinessplanningeffectdetailVO businessplanningeffectdetailVO = new BusinessplanningeffectdetailVO();
                businessplanningeffectdetailVO.setId(IdWorker.getId());
                businessplanningeffectdetailVO.setSort((String)datas.get(0));
                businessplanningeffectdetailVO.setCategoryAndName(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) ? (String)datas.get(1) : null);
                businessplanningeffectdetailVO.setInitiateReason(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                businessplanningeffectdetailVO.setPlanCategory(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? (String)datas.get(3) : null);
                businessplanningeffectdetailVO.setPlanType(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? (String)datas.get(4) : null);
                businessplanningeffectdetailVO.setPlanStatus(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? (String)datas.get(5) : null);
                businessplanningeffectdetailVO.setAttention(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(19))) ? (String)datas.get(19) : null);
                businessplanningeffectdetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(32))) ? (String)datas.get(32) : null);
                if (datas.get(0) == null || datas.get(0) == "") {
                    businessplanningeffectdetailVO.setErrorMsg("\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    businessplanningeffectdetailVO.setSort((String)datas.get(0));
                }
                if (datas.get(1) == null || StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    businessplanningeffectdetailVO.setErrorMsg("\u7c7b\u522b\u53ca\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u7c7b\u522b\u53ca\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    businessplanningeffectdetailVO.setCategoryAndName((String)datas.get(1));
                }
                if (datas.get(5) == null || StringUtils.isBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    businessplanningeffectdetailVO.setErrorMsg("\u7b56\u5212\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u7b56\u5212\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
                } else if ("\u8ba1\u5212".equals(datas.get(5)) || "\u5b9e\u65bd\u4e2d".equals(datas.get(5)) || "\u5df2\u5b8c\u6210".equals(datas.get(5))) {
                    businessplanningeffectdetailVO.setPlanStatus((String)datas.get(5));
                } else {
                    businessplanningeffectdetailVO.setErrorMsg("\u7b56\u5212\u72b6\u6001\u4e0d\u5bf9,\u53ea\u80fd\u662f \u8ba1\u5212,\u5b9e\u65bd\u4e2d,\u5df2\u5b8c\u6210");
                    errorsMsgBuilder.append("\u7b56\u5212\u72b6\u6001\u4e0d\u5bf9,\u53ea\u80fd\u662f \u8ba1\u5212,\u5b9e\u65bd\u4e2d,\u5df2\u5b8c\u6210");
                }
                if (datas.get(3) == null || StringUtils.isBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    businessplanningeffectdetailVO.setErrorMsg("\u7b56\u5212\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
                    errorsMsgBuilder.append("\u7b56\u5212\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
                } else if ("\u5f00\u6e90".equals(datas.get(3)) || "\u8282\u6d41".equals(datas.get(3))) {
                    businessplanningeffectdetailVO.setPlanCategory((String)datas.get(3));
                } else {
                    businessplanningeffectdetailVO.setErrorMsg("\u7b56\u5212\u7c7b\u522b\u4e0d\u5bf9,\u53ea\u80fd\u662f \u5f00\u6e90,\u8282\u6d41");
                    errorsMsgBuilder.append("\u7b56\u5212\u7c7b\u522b\u4e0d\u5bf9,\u53ea\u80fd\u662f \u5f00\u6e90,\u8282\u6d41");
                }
                if (StringUtils.isNotBlank((CharSequence)initiateDate)) {
                    if (DateUtils.grepDate(initiateDate)) {
                        businessplanningeffectdetailVO.setInitiateDate(DateUtils.Date(initiateDate));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\u7acb\u9879\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u7acb\u9879\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)incomeBeforePlan)) {
                    if (NumberUtil.isNumber((String)incomeBeforePlan)) {
                        businessplanningeffectdetailVO.setIncomeBeforePlan(new BigDecimal(incomeBeforePlan));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\u7b56\u5212\u524d\u6536\u5165 \uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u7b56\u5212\u524d\u6536\u5165 \uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)costBeforePlan)) {
                    if (NumberUtil.isNumber((String)costBeforePlan)) {
                        businessplanningeffectdetailVO.setCostBeforePlan(new BigDecimal(costBeforePlan));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\u7b56\u5212\u524d\u6210\u672c\uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u7b56\u5212\u524d\u6210\u672c\uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)benefitBeforePlan)) {
                    if (NumberUtil.isNumber((String)benefitBeforePlan)) {
                        businessplanningeffectdetailVO.setBenefitBeforePlan(new BigDecimal(benefitBeforePlan));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\u7b56\u5212\u524d\u6548\u76ca\uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u7b56\u5212\u524d\u6548\u76ca\uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                } else {
                    BigDecimal benefitBeforePlanB = new BigDecimal(0);
                    BigDecimal incomeBeforePlanB = businessplanningeffectdetailVO.getIncomeBeforePlan();
                    BigDecimal costBeforePlanB = businessplanningeffectdetailVO.getCostBeforePlan();
                    if (incomeBeforePlanB != null && costBeforePlanB != null) {
                        benefitBeforePlanB = incomeBeforePlanB.subtract(costBeforePlanB);
                        businessplanningeffectdetailVO.setBenefitBeforePlan(benefitBeforePlanB);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)estimatedRevenueAfterPlan)) {
                    if (NumberUtil.isNumber((String)estimatedRevenueAfterPlan)) {
                        businessplanningeffectdetailVO.setEstimatedRevenueAfterPlan(new BigDecimal(estimatedRevenueAfterPlan));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\u7b56\u5212\u540e\u9884\u8ba1\u6536\u5165\uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u7b56\u5212\u540e\u9884\u8ba1\u6536\u5165\uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)estimatedCostAfterPlan)) {
                    if (NumberUtil.isNumber((String)estimatedCostAfterPlan)) {
                        businessplanningeffectdetailVO.setEstimatedCostAfterPlan(new BigDecimal(estimatedCostAfterPlan));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\u7b56\u5212\u540e\u9884\u8ba1\u6210\u672c\uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u7b56\u5212\u540e\u9884\u8ba1\u6210\u672c\uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)estimatedBenefitsAfterPlan)) {
                    if (NumberUtil.isNumber((String)estimatedBenefitsAfterPlan)) {
                        businessplanningeffectdetailVO.setEstimatedBenefitsAfterPlan(new BigDecimal(estimatedBenefitsAfterPlan));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\u7b56\u5212\u540e\u9884\u8ba1\u6548\u76ca\uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u7b56\u5212\u540e\u9884\u8ba1\u6548\u76ca\uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                } else {
                    BigDecimal estimatedBenefitsAfterPlanB = new BigDecimal(0);
                    BigDecimal estimatedRevenueAfterPlanB = businessplanningeffectdetailVO.getEstimatedRevenueAfterPlan();
                    BigDecimal estimatedCostAfterPlanB = businessplanningeffectdetailVO.getEstimatedCostAfterPlan();
                    if (estimatedRevenueAfterPlanB != null && estimatedCostAfterPlanB != null) {
                        estimatedBenefitsAfterPlanB = estimatedRevenueAfterPlanB.subtract(estimatedCostAfterPlanB);
                        businessplanningeffectdetailVO.setEstimatedBenefitsAfterPlan(estimatedBenefitsAfterPlanB);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)planExpectAchieveResults)) {
                    if (NumberUtil.isNumber((String)planExpectAchieveResults)) {
                        businessplanningeffectdetailVO.setPlanExpectAchieveResults(new BigDecimal(planExpectAchieveResults));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\u7b56\u5212\u9884\u8ba1\u521b\u6548\uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u7b56\u5212\u9884\u8ba1\u521b\u6548\uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)proposedCompleteTime)) {
                    if (DateUtils.grepDate(proposedCompleteTime)) {
                        businessplanningeffectdetailVO.setProposedCompleteTime(DateUtils.Date(proposedCompleteTime));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\u62df\u5b8c\u6210\u65f6\u95f4\u8282\u70b9\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u62df\u5b8c\u6210\u65f6\u95f4\u8282\u70b9\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)supervisionNotReportedMoney)) {
                    if (NumberUtil.isNumber((String)supervisionNotReportedMoney)) {
                        businessplanningeffectdetailVO.setSupervisionNotReportedMoney(new BigDecimal(supervisionNotReportedMoney));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\uff08\u76d1\u7406\u5355\u4f4d\u672a\u4e0a\u62a5\uff09\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\uff08\u76d1\u7406\u5355\u4f4d\u672a\u4e0a\u62a5\uff09\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)supervisionNotReportedTime)) {
                    if (DateUtils.grepDate(supervisionNotReportedTime)) {
                        businessplanningeffectdetailVO.setSupervisionNotReportedTime(DateUtils.Date(supervisionNotReportedTime));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\uff08\u76d1\u7406\u5355\u4f4d\u672a\u4e0a\u62a5\uff09\u9884\u8ba1\u4e0a\u62a5\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\uff08\u76d1\u7406\u5355\u4f4d\u672a\u4e0a\u62a5\uff09\u9884\u8ba1\u4e0a\u62a5\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)supervisionReportedMoney)) {
                    if (NumberUtil.isNumber((String)supervisionReportedMoney)) {
                        businessplanningeffectdetailVO.setSupervisionReportedMoney(new BigDecimal(supervisionReportedMoney));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\uff08\u76d1\u7406\u5355\u4f4d\u5df2\u4e0a\u62a5\u672a\u6279\u590d\uff09\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\uff08\u76d1\u7406\u5355\u4f4d\u5df2\u4e0a\u62a5\u672a\u6279\u590d\uff09\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)supervisionReportedTime)) {
                    if (DateUtils.grepDate(supervisionReportedTime)) {
                        businessplanningeffectdetailVO.setSupervisionReportedTime(DateUtils.Date(supervisionReportedTime));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\uff08\u76d1\u7406\u5355\u4f4d\u5df2\u4e0a\u62a5\u672a\u6279\u590d\uff09\u4e0a\u62a5\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\uff08\u76d1\u7406\u5355\u4f4d\u5df2\u4e0a\u62a5\u672a\u6279\u590d\uff09\u4e0a\u62a5\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)supervisionApprovedMoney)) {
                    if (NumberUtil.isNumber((String)supervisionApprovedMoney)) {
                        businessplanningeffectdetailVO.setSupervisionApprovedMoney(new BigDecimal(supervisionApprovedMoney));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\uff08\u76d1\u7406\u5355\u4f4d\u5df2\u6279\u590d\uff09\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\uff08\u76d1\u7406\u5355\u4f4d\u5df2\u6279\u590d\uff09\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)supervisionApprovedTime)) {
                    if (DateUtils.grepDate(supervisionApprovedTime)) {
                        businessplanningeffectdetailVO.setSupervisionApprovedTime(DateUtils.Date(supervisionApprovedTime));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\uff08\u76d1\u7406\u5355\u4f4d\u5df2\u6279\u590d\uff09\u4e0a\u62a5\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\uff08\u76d1\u7406\u5355\u4f4d\u5df2\u6279\u590d\uff09\u4e0a\u62a5\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)ownerNotReportedMoney)) {
                    if (NumberUtil.isNumber((String)ownerNotReportedMoney)) {
                        businessplanningeffectdetailVO.setOwnerNotReportedMoney(new BigDecimal(ownerNotReportedMoney));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\uff08\u4e1a\u4e3b\u5355\u4f4d\u672a\u4e0a\u62a5\uff09\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\uff08\u4e1a\u4e3b\u5355\u4f4d\u672a\u4e0a\u62a5\uff09\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)ownerNotReportedTime)) {
                    if (DateUtils.grepDate(ownerNotReportedTime)) {
                        businessplanningeffectdetailVO.setOwnerNotReportedTime(DateUtils.Date(ownerNotReportedTime));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\uff08\u4e1a\u4e3b\u5355\u4f4d\u672a\u4e0a\u62a5\uff09\u9884\u8ba1\u4e0a\u62a5\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\uff08\u4e1a\u4e3b\u5355\u4f4d\u672a\u4e0a\u62a5\uff09\u9884\u8ba1\u4e0a\u62a5\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)ownerReportedMoney)) {
                    if (NumberUtil.isNumber((String)ownerReportedMoney)) {
                        businessplanningeffectdetailVO.setOwnerReportedMoney(new BigDecimal(ownerReportedMoney));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\uff08\u4e1a\u4e3b\u5355\u4f4d\u5df2\u4e0a\u62a5\u672a\u6279\u590d\uff09\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\uff08\u4e1a\u4e3b\u5355\u4f4d\u5df2\u4e0a\u62a5\u672a\u6279\u590d\uff09\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)ownerReportedTime)) {
                    if (DateUtils.grepDate(ownerReportedTime)) {
                        businessplanningeffectdetailVO.setOwnerReportedTime(DateUtils.Date(ownerReportedTime));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\u4e1a\u4e3b\u5355\u4f4d\u5df2\u4e0a\u62a5\u672a\u6279\u590d\uff09\u4e0a\u62a5\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u4e1a\u4e3b\u5355\u4f4d\u5df2\u4e0a\u62a5\u672a\u6279\u590d\uff09\u4e0a\u62a5\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)ownerApprovedMoney)) {
                    if (NumberUtil.isNumber((String)ownerApprovedMoney)) {
                        businessplanningeffectdetailVO.setOwnerApprovedMoney(new BigDecimal(ownerApprovedMoney));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\uff08\u4e1a\u4e3b\u5355\u4f4d\u5df2\u6279\u590d\uff09\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\uff08\u4e1a\u4e3b\u5355\u4f4d\u5df2\u6279\u590d\uff09\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)ownerApprovedTime)) {
                    if (DateUtils.grepDate(ownerApprovedTime)) {
                        businessplanningeffectdetailVO.setOwnerApprovedTime(DateUtils.Date(ownerApprovedTime));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\uff08\u4e1a\u4e3b\u5355\u4f4d\u5df2\u6279\u590d\uff09\u4e0a\u62a5\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\uff08\u4e1a\u4e3b\u5355\u4f4d\u5df2\u6279\u590d\uff09\u4e0a\u62a5\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)revenueAfterPlan)) {
                    if (NumberUtil.isNumber((String)revenueAfterPlan)) {
                        businessplanningeffectdetailVO.setRevenueAfterPlan(new BigDecimal(revenueAfterPlan));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\u7b56\u5212\u540e\u6536\u5165\uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u7b56\u5212\u540e\u6536\u5165\uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)actualCost)) {
                    if (NumberUtil.isNumber((String)actualCost)) {
                        businessplanningeffectdetailVO.setActualCost(new BigDecimal(actualCost));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\u5b9e\u9645\u6210\u672c\uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u5b9e\u9645\u6210\u672c\uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)benefitAfterPlan)) {
                    if (NumberUtil.isNumber((String)benefitAfterPlan)) {
                        businessplanningeffectdetailVO.setBenefitAfterPlan(new BigDecimal(benefitAfterPlan));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\u7b56\u5212\u540e\u6548\u76ca\uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u7b56\u5212\u540e\u6548\u76ca\uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                } else {
                    BigDecimal benefitAfterPlanB = new BigDecimal(0);
                    BigDecimal revenueAfterPlanB = businessplanningeffectdetailVO.getRevenueAfterPlan();
                    BigDecimal actualCostB = businessplanningeffectdetailVO.getActualCost();
                    if (revenueAfterPlanB != null && actualCostB != null) {
                        benefitAfterPlanB = revenueAfterPlanB.subtract(actualCostB);
                        businessplanningeffectdetailVO.setBenefitAfterPlan(benefitAfterPlanB);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)includePlannedActualEffect)) {
                    if (NumberUtil.isNumber((String)includePlannedActualEffect)) {
                        businessplanningeffectdetailVO.setIncludePlannedActualEffect(new BigDecimal(includePlannedActualEffect));
                    } else {
                        businessplanningeffectdetailVO.setErrorMsg("\u5176\u4e2d\uff1a\u7b56\u5212\u5b9e\u9645\u521b\u6548\uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u5176\u4e2d\uff1a\u7b56\u5212\u5b9e\u9645\u521b\u6548\uff08\u4e07\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                } else {
                    BigDecimal includePlannedActualEffectB = new BigDecimal(0);
                    BigDecimal benefitAfterPlanC = businessplanningeffectdetailVO.getBenefitAfterPlan();
                    BigDecimal benefitBeforePlanC = businessplanningeffectdetailVO.getBenefitBeforePlan();
                    if (benefitAfterPlanC != null && benefitBeforePlanC != null) {
                        includePlannedActualEffectB = benefitAfterPlanC.subtract(benefitBeforePlanC);
                        businessplanningeffectdetailVO.setIncludePlannedActualEffect(includePlannedActualEffectB);
                    }
                }
                if (!pcStrList.contains(businessplanningeffectdetailVO.getSort().toString() + businessplanningeffectdetailVO.getCategoryAndName().toString())) {
                    businessplanningeffectdetailVO.setErrorMsg("\u672a\u5728\u8868\u4f53\u4e2d\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff01");
                    errorsMsgBuilder.append("\u672a\u5728\u8868\u4f53\u4e2d\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff01");
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(businessplanningeffectdetailVO);
                    continue;
                }
                successList.add(businessplanningeffectdetailVO);
            }
        }
        List<BusinessplanningeffectdetailVO> resList = this.setTidAndTpid(successList);
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    private List<BusinessplanningeffectdetailVO> setTidAndTpid(List<BusinessplanningeffectdetailVO> originalList) {
        ArrayList<BusinessplanningeffectdetailVO> treeList = new ArrayList<BusinessplanningeffectdetailVO>();
        String currentTime = String.valueOf(System.currentTimeMillis());
        if (originalList != null && originalList.size() > 0) {
            for (int i = 0; i < originalList.size(); ++i) {
                BusinessplanningeffectdetailVO businessplanningeffectdetailVO = originalList.get(i);
                String sort = businessplanningeffectdetailVO.getSort();
                String[] arr = sort.split("\\.");
                if (arr.length == 1) {
                    businessplanningeffectdetailVO.setTid(currentTime + "_" + sort);
                    businessplanningeffectdetailVO.setTpid("");
                    treeList.add(businessplanningeffectdetailVO);
                    continue;
                }
                if (arr.length <= 1) continue;
                businessplanningeffectdetailVO.setTid(currentTime + "_" + sort);
                businessplanningeffectdetailVO.setTpid(currentTime + "_" + sort.substring(0, sort.length() - 2));
                treeList.add(businessplanningeffectdetailVO);
            }
        }
        return ExcelBusinessplaneffectController.createTreeData(treeList);
    }

    public static List<BusinessplanningeffectdetailVO> createTreeData(List<BusinessplanningeffectdetailVO> list) {
        ArrayList<BusinessplanningeffectdetailVO> resp = new ArrayList<BusinessplanningeffectdetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, BusinessplanningeffectdetailVO> listMap = new HashMap<String, BusinessplanningeffectdetailVO>();
        for (BusinessplanningeffectdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            BusinessplanningeffectdetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            BusinessplanningeffectdetailVO parent = (BusinessplanningeffectdetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<BusinessplanningeffectdetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<BusinessplanningeffectdetailVO> children = new ArrayList<BusinessplanningeffectdetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((BusinessplanningeffectdetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    @RequestMapping(value={"/excelExportBusinessplanningeffectFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportbusinessplanningeffectFromDatabase(@RequestBody BusinessplanningeffectVO businessplanningeffectVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)businessplanningeffectVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.businessplanningeffectdetailService.list((Wrapper)queryWrapper);
        List resList = BeanMapper.mapList((Iterable)list, BusinessplanningeffectdetailVO.class);
        HashMap<String, List<BusinessplanningeffectdetailVO>> beans = new HashMap<String, List<BusinessplanningeffectdetailVO>>();
        beans.put("records", this.handleSpecialField(resList));
        ExcelExport.getInstance().export("businessplanningeffect-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportBusinessplanningeffectFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportbusinessplanningeffectFromPage(@RequestBody List<BusinessplanningeffectdetailVO> list, HttpServletResponse response) {
        ArrayList<BusinessplanningeffectdetailVO> concatList = new ArrayList<BusinessplanningeffectdetailVO>();
        for (int i = 0; i < list.size(); ++i) {
            BusinessplanningeffectdetailVO businessplanningeffectdetailVO = list.get(i);
            concatList.add(businessplanningeffectdetailVO);
        }
        List<BusinessplanningeffectdetailVO> allList = this.handleList(list, concatList);
        Collections.sort(allList, new Comparator<BusinessplanningeffectdetailVO>(){

            @Override
            public int compare(BusinessplanningeffectdetailVO o1, BusinessplanningeffectdetailVO o2) {
                return o1.getSort().compareTo(o2.getSort());
            }
        });
        HashMap<String, List<BusinessplanningeffectdetailVO>> beans = new HashMap<String, List<BusinessplanningeffectdetailVO>>();
        beans.put("records", this.handleSpecialField(allList));
        ExcelExport.getInstance().export("businessplanningeffect-export.xlsx", beans, response);
    }

    private List<BusinessplanningeffectdetailVO> handleSpecialField(List<BusinessplanningeffectdetailVO> allList) {
        for (int i = 0; i < allList.size(); ++i) {
            BusinessplanningeffectdetailVO businessplanningeffectdetailVO = allList.get(i);
            if (businessplanningeffectdetailVO.getCompleteTime() != null) {
                businessplanningeffectdetailVO.setCompleteTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getCompleteTime()));
            }
            if (businessplanningeffectdetailVO.getInitiateDate() != null) {
                businessplanningeffectdetailVO.setLxDateShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getInitiateDate()));
            }
            if (businessplanningeffectdetailVO.getProposedCompleteTime() != null) {
                businessplanningeffectdetailVO.setProposedCompleteTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getProposedCompleteTime()));
            }
            if (businessplanningeffectdetailVO.getFinalCompleteTime() != null) {
                businessplanningeffectdetailVO.setFinalCompleteTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getFinalCompleteTime()));
            }
            if (businessplanningeffectdetailVO.getSupervisionNotReportedTime() != null) {
                businessplanningeffectdetailVO.setSupervisionNotReportedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getSupervisionNotReportedTime()));
            }
            if (businessplanningeffectdetailVO.getSupervisionReportedTime() != null) {
                businessplanningeffectdetailVO.setSupervisionReportedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getSupervisionReportedTime()));
            }
            if (businessplanningeffectdetailVO.getSupervisionApprovedTime() != null) {
                businessplanningeffectdetailVO.setSupervisionApprovedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getSupervisionApprovedTime()));
            }
            if (businessplanningeffectdetailVO.getOwnerNotReportedTime() != null) {
                businessplanningeffectdetailVO.setOwnerNotReportedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getOwnerNotReportedTime()));
            }
            if (businessplanningeffectdetailVO.getOwnerReportedTime() != null) {
                businessplanningeffectdetailVO.setOwnerReportedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getOwnerReportedTime()));
            }
            if (businessplanningeffectdetailVO.getOwnerApprovedTime() == null) continue;
            businessplanningeffectdetailVO.setOwnerApprovedTimeShow(DateUtils.dateSimple(businessplanningeffectdetailVO.getOwnerApprovedTime()));
        }
        return allList;
    }

    private List<BusinessplanningeffectdetailVO> handleList(List<BusinessplanningeffectdetailVO> list, List<BusinessplanningeffectdetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }
        for (int i = 0; i < list.size(); ++i) {
            BusinessplanningeffectdetailVO businessplanningeffectdetailVO = list.get(i);
            List<BusinessplanningeffectdetailVO> children = businessplanningeffectdetailVO.getChildren();
            if (children == null || children.size() <= 0) continue;
            concatList.addAll(children);
            this.handleList(children, concatList);
        }
        return concatList;
    }
}

