package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.BusinessplanningeffectEntity;
import com.ejianc.business.busniessplan.bean.BusinessplanningeffectdetailEntity;
import com.ejianc.business.busniessplan.service.IBusinessplanningeffectService;
import com.ejianc.business.change.bean.ChangebusinessplaneffectdetailEntity;
import com.ejianc.business.change.bean.ChangebusinessplanningeffectEntity;
import com.ejianc.business.change.service.IChangebusinessplanningeffectService;
import com.ejianc.business.record.bean.RecordbusinessplaneffectdetailEntity;
import com.ejianc.business.record.bean.RecordbusinessplanningeffectEntity;
import com.ejianc.business.record.service.IRecordbusinessplanningeffectService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changebusinessplanningeffect") 
public class ChangebusinessplanningeffectBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	//业务类型
	private static final String Businessplanningeffect = "zjkj-businessplanningeffect";//项目商务策划立项
	private static final String Businessplanningeffect_CHANGE = "zjkj-businessplanningeffectChange";//项目商务策划立项变更
	private static final String Businessplanningeffect_RECORD = "zjkj-businessplanningeffectRecord";//项目商务策划立项变更记录

	//单据类型
	private static final String Businessplanningeffect_BILLTYPE_CODE = "BT202202000015";//项目商务策划立项
	private static final String Businessplanningeffect_CHANGE_BILLTYPE_CODE = "BT202202000068";//项目商务策划立项变更
	private static final String Businessplanningeffect_RECORD_BILLTYPE_CODE = "BT202202000069";//项目商务策划立项变更记录

	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangebusinessplanningeffectService changebusinessplanningeffectService;
	@Autowired
	private IBusinessplanningeffectService businessplanningeffectService;
	@Autowired
	private IRecordbusinessplanningeffectService recordbusinessplanningeffectService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//1、获取目前单据信息、变更信息
		ChangebusinessplanningeffectEntity changeEntity = changebusinessplanningeffectService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getBusinessplanningeffectId());
		BusinessplanningeffectEntity businessplanningeffectEntity = businessplanningeffectService.selectById(changeEntity.getBusinessplanningeffectId());
		logger.info("主单据id=" + changeEntity.getId() + "主单据创建人" + changeEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecordbusinessplanningeffectEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("businessplanningeffect_id", businessplanningeffectEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordbusinessplanningeffectService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordbusinessplanningeffectEntity recordbusinessplanningeffectEntity = BeanMapper.map(businessplanningeffectEntity, RecordbusinessplanningeffectEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordbusinessplanningeffectEntity);
		recordbusinessplanningeffectEntity.setBillState(null);
		recordbusinessplanningeffectEntity.setBusinessplanningeffectId(businessplanningeffectEntity.getId());
		recordbusinessplanningeffectEntity.setBusinessplanningeffectCode(businessplanningeffectEntity.getBillCode()+"-"+(count+1));
		recordbusinessplanningeffectEntity.setId(recordId);
		recordbusinessplanningeffectEntity.setBillCode(businessplanningeffectEntity.getBillCode());
		recordbusinessplanningeffectEntity.setChangeReason(changeEntity.getChangeReason());
		recordbusinessplanningeffectEntity.setEffectTime(new Date());

		logger.info("---------给变更记录子表赋值--------");
		List<BusinessplanningeffectdetailEntity> businessplanningeffectdetailEntity = businessplanningeffectEntity.getBusinessplanningeffectdetailEntities();
		if(businessplanningeffectdetailEntity!=null&&businessplanningeffectdetailEntity.size()>0){
			List<RecordbusinessplaneffectdetailEntity> recordbusinessplaneffectdetailEntity = new ArrayList<>();
			for(BusinessplanningeffectdetailEntity entity : businessplanningeffectdetailEntity){
				RecordbusinessplaneffectdetailEntity reEntity = BeanMapper.map(entity, RecordbusinessplaneffectdetailEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setMid(recordId);
				recordbusinessplaneffectdetailEntity.add(reEntity);
				entity.setRowState("del");
			}
			recordbusinessplanningeffectEntity.setBusinessplaneffectdetailEntities(recordbusinessplaneffectdetailEntity);
		}
		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		//原单据类型
		sourceBillType = Businessplanningeffect_BILLTYPE_CODE;
		String targetBillType = "";
		//变更记录单剧类型
		targetBillType = Businessplanningeffect_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(businessplanningeffectEntity.getId().toString(), sourceBillType, Businessplanningeffect , recordId.toString(), targetBillType, Businessplanningeffect_RECORD);
		recordbusinessplanningeffectService.saveOrUpdate(recordbusinessplanningeffectEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + businessplanningeffectEntity.getCreateUserCode());
		//3、修改当前单据状态
		BusinessplanningeffectEntity newBusinessplanningeffectEntity = BeanMapper.map(changeEntity, BusinessplanningeffectEntity.class);
		newBusinessplanningeffectEntity.setChangeState("3");//状态改为已变更
		newBusinessplanningeffectEntity.setChangeId(null);
		newBusinessplanningeffectEntity.setBillState(businessplanningeffectEntity.getBillState());
		newBusinessplanningeffectEntity.setId(businessplanningeffectEntity.getId());
		newBusinessplanningeffectEntity.setCreateTime(businessplanningeffectEntity.getCreateTime());
		newBusinessplanningeffectEntity.setCreateUserCode(businessplanningeffectEntity.getCreateUserCode());
		newBusinessplanningeffectEntity.setTenantId(businessplanningeffectEntity.getTenantId());
		newBusinessplanningeffectEntity.setVersion(businessplanningeffectEntity.getVersion());

		logger.info("---------处理子表变更--------");
		//子表
		//处理子表变更
		List<ChangebusinessplaneffectdetailEntity> changebusinessplaneffectdetailEntityList = changeEntity.getBusinessplanningeffectdetailEntities();
		if(changebusinessplaneffectdetailEntityList!=null&&changebusinessplaneffectdetailEntityList.size()>0){
			List<BusinessplanningeffectdetailEntity> newBusinessplanningeffectdetailEntity = BeanMapper.mapList(changebusinessplaneffectdetailEntityList, BusinessplanningeffectdetailEntity.class);
			newBusinessplanningeffectdetailEntity.addAll(businessplanningeffectdetailEntity);
			newBusinessplanningeffectEntity.setBusinessplanningeffectdetailEntities(newBusinessplanningeffectdetailEntity);
		}
		logger.info("---------保存--------");
		businessplanningeffectService.saveOrUpdate(newBusinessplanningeffectEntity, false);

		sourceBillType = Businessplanningeffect_CHANGE_BILLTYPE_CODE;
		targetBillType = Businessplanningeffect_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Businessplanningeffect_CHANGE, businessplanningeffectEntity.getId().toString(), targetBillType, Businessplanningeffect);
		recordbusinessplanningeffectService.saveOrUpdate(recordbusinessplanningeffectEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
