package com.ejianc.business.busniessplan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.CountersignatureEntity;
import com.ejianc.business.busniessplan.bean.ProjoverviewEntity;
import com.ejianc.business.busniessplan.service.ICountersignatureService;
import com.ejianc.business.busniessplan.service.IProjoverviewService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("projoverview")
public class ProjoverviewBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private ICountersignatureService service;
	@Autowired
	private IProjoverviewService projoverviewService;


	@Autowired
	private IBillCodeApi billCodeApi;
	private static final String BILL_CODE = "busniessplan-countersignature";//此处需要根据实际修改

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		if (state == 1 || state == 3){
			ProjoverviewEntity entity = projoverviewService.selectById(billId);
			QueryWrapper<CountersignatureEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("project_id", entity.getProjectId());
			queryWrapper.eq("dr", "0");

			List<CountersignatureEntity> countersignatureList = service.list(queryWrapper);
			if(countersignatureList == null || countersignatureList.size() == 0){
				CountersignatureEntity resEntity = new CountersignatureEntity();
				resEntity.setProjectId(entity.getProjectId());
				resEntity.setPlanningName(entity.getProjectName());
				resEntity.setAgentId(entity.getAgentId());
				resEntity.setOrgId(entity.getOrgId());

				CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
				if(billCode.isSuccess()) {
					resEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
				}else{
					throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
				}
				resEntity.setChangeState("1");
				service.saveOrUpdate(resEntity,false);
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		if (!resp.isSuccess()) {
			logger.info("该单据已被“商务策划会签”引用，不允许撤回！");
			return CommonResponse.error(resp.getMsg());
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
