package com.ejianc.business.change.controller;

import java.io.Serializable;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.FundrecoveryplanEntity;
import com.ejianc.business.busniessplan.bean.FundrecoveryplanningdetailEntity;
import com.ejianc.business.busniessplan.bean.FundsplanningEntity;
import com.ejianc.business.busniessplan.bean.FundsplanningdetailEntity;
import com.ejianc.business.busniessplan.service.IFundsplanningService;
import com.ejianc.business.busniessplan.vo.FundsplanningVO;
import com.ejianc.business.change.bean.ChangeFundsplanningEntity;
import com.ejianc.business.change.bean.ChangeFundsplanningdetailEntity;
import com.ejianc.business.change.service.IChangeFundsplanningService;
import com.ejianc.business.change.service.IChangeFundsplanningdetailService;
import com.ejianc.business.change.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;


/**
 * 项目资金管理策划变更表
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("changeFundsplanning")
public class ChangeFundsplanningController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IFundsplanningService iFundsplanningService;
    @Autowired
    private IChangeFundsplanningService service;
    @Autowired
    private IChangeFundsplanningdetailService iChangeFundsplanningdetailService;

    /**
     * 初始化更详情页面
     *
     * @param
     * @return
     */
    @GetMapping(value = "queryDetailByFundsplanningId")
    @ResponseBody
    public CommonResponse<ChangeFundsplanningVO> queryDetailByFundrecoveryplanId(@RequestParam(value = "fundsplanningId") Long fundsplanningId) {
        FundsplanningEntity changeFundsplanningEntity = iFundsplanningService.selectById(fundsplanningId);
        ChangeFundsplanningVO changeVO = BeanMapper.map(changeFundsplanningEntity, ChangeFundsplanningVO.class);
        Long id = IdWorker.getId();
        changeVO.setFundsplanningId(fundsplanningId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
//        changeVO.setAgentId(null);
        changeVO.setUpdateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setChangeReason(null);
        changeVO.setId(id);

        //资金管理策划子表
        List<FundsplanningdetailEntity> fundsplanningdetailEntities = changeFundsplanningEntity.getFundsplanningdetailEntities();
        if(fundsplanningdetailEntities!=null&&fundsplanningdetailEntities.size()>0){
            List<ChangeFundsplanningdetailVO> changeFundsplanningdetailvo = new ArrayList<>();
            for(FundsplanningdetailEntity entity : fundsplanningdetailEntities){
                ChangeFundsplanningdetailVO vo = BeanMapper.map(entity, ChangeFundsplanningdetailVO.class);
                vo.setMid(id);
                vo.setCreateTime(entity.getCreateTime());
                vo.setCreateUserCode(null);
                vo.setTenantId(null);
                vo.setUpdateTime(null);
                vo.setUpdateUserCode(null);
                vo.setRowState("edit");
                vo.setId(IdWorker.getId());
                changeFundsplanningdetailvo.add(vo);
            }
            changeVO.setFundsplanningdetailEntities(changeFundsplanningdetailvo);
        }

        return CommonResponse.success("查询详情成功！", changeVO);

    }
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangeFundsplanningVO> saveOrUpdate(@RequestBody ChangeFundsplanningVO saveOrUpdateVO) {
    	return service.saveChange(saveOrUpdateVO);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeFundsplanningVO> queryDetail(Long id) {
        ChangeFundsplanningEntity entity = service.selectById(id);
    	ChangeFundsplanningVO vo = BeanMapper.map(entity, ChangeFundsplanningVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangeFundsplanningVO> saveChange(@RequestBody ChangeFundsplanningVO saveOrUpdateVO) {
        return service.saveChange(saveOrUpdateVO);
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangeFundsplanningVO> vos) {
        return service.delete(vos);
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangeFundsplanningVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ChangeFundsplanningEntity> page = service.queryPage(param,false);
        IPage<ChangeFundsplanningVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeFundsplanningVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ChangeFundsplanningEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ChangeFundsplanning-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refChangeFundsplanningData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ChangeFundsplanningVO>> refChangeFundsplanningData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ChangeFundsplanningEntity> page = service.queryPage(param,false);
        IPage<ChangeFundsplanningVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeFundsplanningVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/selectPrevious", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse selectPrevious(String projectId){
        QueryWrapper<ChangeFundsplanningEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("bill_state",1,3);
        queryWrapper.eq("project_id",projectId);
        queryWrapper.eq("dr",0);
        queryWrapper.lt("create_time", DateUtil.now());
        List<ChangeFundsplanningEntity> fundsplanningEntityList = service.list(queryWrapper);

        BigDecimal decimal = new BigDecimal(0);

        for (ChangeFundsplanningEntity entity : fundsplanningEntityList) {
            QueryWrapper<ChangeFundsplanningdetailEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("mid",entity.getId());
            queryWrapper.eq("dr",0);
            List<ChangeFundsplanningdetailEntity> fundsplanningdetailEntityList = iChangeFundsplanningdetailService.list(wrapper);
            for (ChangeFundsplanningdetailEntity fundsplanningdetailEntity : fundsplanningdetailEntityList) {
                BigDecimal current = fundsplanningdetailEntity.getCurrent();
                decimal = decimal.add(current);
            }
        }
        return CommonResponse.success(decimal);
    }
}
