package com.ejianc.business.change.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.SubpackagepackgedetailEntity;
import com.ejianc.business.busniessplan.service.ISubpackagepackgedetailService;
import com.ejianc.business.busniessplan.vo.SubpackageVO;
import com.ejianc.business.busniessplan.vo.SubpackagepackgedetailVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 分包分供  分包子表导入导出
 */
@Controller
@RequestMapping("changeSubpackageExport")
public class ExcelChangeSubpakageController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISubpackagepackgedetailService subpackagepackgedetailService;
    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadSubpackage")
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "subpackage-import.xlsx", "分包管理策划表模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportSubpackage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<SubpackagepackgedetailVO> successList = new ArrayList<>();
        List<SubpackagepackgedetailVO> errorList = new ArrayList<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=1;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    SubpackagepackgedetailVO subpackagepackgedetailVO = new SubpackagepackgedetailVO();
                    subpackagepackgedetailVO.setId(IdWorker.getId());//id
                    subpackagepackgedetailVO.setSort(datas.get(0)); // 序号
                    subpackagepackgedetailVO.setManagerContent(StringUtils.isNotBlank(datas.get(1))?datas.get(1):null); // 管理内容
                    subpackagepackgedetailVO.setManagerAim(StringUtils.isNotBlank(datas.get(2))?datas.get(2):null); // 管理目标
                    subpackagepackgedetailVO.setManagerMeasures(StringUtils.isNotBlank(datas.get(3))?datas.get(3):null); // 管理措施
                    subpackagepackgedetailVO.setPersonLiable(StringUtils.isNotBlank(datas.get(4))?datas.get(4):null); // 责任人
                    subpackagepackgedetailVO.setPlanCompleteTime(StringUtils.isNotBlank(datas.get(5))? datas.get(5):null); // 计划完成时间
                    subpackagepackgedetailVO.setImplementationEffect(StringUtils.isNotBlank(datas.get(6))?datas.get(6):null); // 实施效果
                    if(StringUtils.isEmpty(datas.get(0))) {
                        subpackagepackgedetailVO.setErrorMsg("序号不能为空！");
                        if(successList.contains(datas.get(0))){
                            subpackagepackgedetailVO.setErrorMsg("序号不能重复！");
                        }
                        errorList.add(subpackagepackgedetailVO);
                        continue;
                    }
                     /*if(StringUtils.isEmpty(datas.get(1))) {
                        subpackagepackgedetailVO.setErrorMsg("名称不能为空！");
                        errorList.add(subpackagepackgedetailVO);
                        continue;
                    }
                   if(StringUtils.isEmpty(datas.get(2))) {
                        fundsplanningdetailVO.setErrorMsg("单位不能为空！");
                        errorList.add(fundsplanningdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(3))) {
                        fundsplanningdetailVO.setErrorMsg("投标工程量不能为空！");
                        errorList.add(fundsplanningdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(4))) {
                        fundsplanningdetailVO.setErrorMsg("建筑面积(m²)不能为空！");
                        errorList.add(fundsplanningdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(5))) {
                        fundsplanningdetailVO.setErrorMsg("投标指标不能为空！");
                        errorList.add(fundsplanningdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(6))) {
                        fundsplanningdetailVO.setErrorMsg("(计划成本)限额设计指标不能为空！");
                        errorList.add(fundsplanningdetailVO);
                        continue;
                    }*/
                    successList.add(subpackagepackgedetailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportSubpackageFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSubpackageFromDatabase(@RequestBody SubpackageVO subpackageVO, HttpServletResponse response) {
        QueryWrapper<SubpackagepackgedetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", subpackageVO.getId());
        queryWrapper.eq("dr", 0);
        List<SubpackagepackgedetailEntity> list = subpackagepackgedetailService.list(queryWrapper);
        List<SubpackagepackgedetailVO> resList = BeanMapper.mapList(list, SubpackagepackgedetailVO.class);
        if (resList != null && resList.size() > 0) {
            for (int i = 0; i < resList.size(); i++) {
                SubpackagepackgedetailVO subpackagepackgedetailVO = resList.get(i);
                subpackagepackgedetailVO.setSort(String.valueOf(i + 1));

                if (subpackagepackgedetailVO.getPlanCompleteTime()!=null){
                    subpackagepackgedetailVO.setPlanCompleteTimeShow(subpackagepackgedetailVO.getPlanCompleteTime());
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", resList);
        ExcelExport.getInstance().export("subpackage-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportSubpackageFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportbusinessplanningeffectFromPage(@RequestBody List<SubpackagepackgedetailVO> list, HttpServletResponse response) {
        for (int i = 0; i < list.size(); i++) {
            SubpackagepackgedetailVO subpackagepackgedetailVO = list.get(i);
            subpackagepackgedetailVO.setSort(String.valueOf(i + 1));
            if (subpackagepackgedetailVO.getPlanCompleteTime()!=null){
                subpackagepackgedetailVO.setPlanCompleteTimeShow(subpackagepackgedetailVO.getPlanCompleteTime());
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("subpackage-export.xlsx", beans, response);
    }
}
